% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{extractProtos}
\alias{extractProtos}
\title{Prototypes extraction}
\usage{
extractProtos(
  data.sample,
  method,
  K.max = 20,
  kmeans.variance.min = 0.95,
  user.name = ""
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{method}{character vector specifying the clustering method (already performed) to use.}

\item{K.max}{maximal number of clusters (K.max=20 by default).}

\item{kmeans.variance.min}{elbow method cumulative explained variance > criteria to stop K-search.}

\item{user.name}{character vector specifying the user name.}
}
\value{
csv file containing the prototypes
}
\description{
Extract prototypes of each cluster automatically, according to a clustering result, and save them in different directories. 
In order to catch the whole variability, each cluster is divided into several sub-clusters, and medoids of each sub-cluster are considered as prototypes.
}
\details{
extractProtos extracts prototypes automatically according to a clustering result, and save them in different directories
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

dir.results <- tempdir()
x <- importSample(file.features=tf1, dir.save=dir.results)
x <- computeUnSupervised(x, K=3, method.name="K-means")

extractProtos(x, method = "K-means_preprocessed")


}
