% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{computeGap2}
\alias{computeGap2}
\title{Gap computation}
\usage{
computeGap2(sim, Kmax)
}
\arguments{
\item{sim}{similarity matrix.}

\item{Kmax}{maximal number of clusters.}
}
\value{
The function returns a list containing:
\item{val}{vector containing the eigenvalues of the similarity matrix.}
\item{gap}{vector containing gap values between two successive eigenvalues.}
\item{Kmax}{estimated number of clusters.}
}
\description{
Estimate the number of clusters thanks to the gap computation.
}
\details{
computeGap2 returns an estimated number of clusters
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarity(dat, 1)
res <- computeGap2(sim, Kmax = 20)

plot(res$val[1:20], type = "o", ann = FALSE, axes = FALSE)
abline(v = res$Kmax, col = "darkred")
abline(h = res$val[res$Kmax], col = "darkred")
axis(side = 1, at = c(seq(0,20,by=5), res$Kmax), 
     labels = c(seq(0,20,by=5), res$Kmax), cex.axis = .7)
axis(side = 2)
title("Automatic estimation of number of clusters - Gap method")
mtext("Number of clusters", side = 1, line = 3)
mtext("Eigenvalue", side = 2, line = 3)
box()
}
\keyword{internal}
