\name{ggplot_geopos}
\alias{ggplot_geopos}
\alias{get_geopos}

\title{
reads and plots geolocation estimates derived from archival tagging data
}
\description{
In case that geolocations are provided by csv-files or data frames, line and scatter plots are implemented.
If ncdf-files or kmz-files, generated by the \href{https://my.wildlifecomputers.com/}{Wildlife Computers-data portal}, are selected, a \link{SpatialPolygonsDataFrame} will be created and a surface probability maps are illustrated. The netcdf transformation procedure is based on the R-code given in the \href{https://static.wildlifecomputers.com/manuals/Location-Processing-User-Guide.pdf}{location processing user guide} by \href{https://wildlifecomputers.com/}{Wildlife Computers}. The kmz-files already include the contour lines of the 50, 95 and 99\% likelihood areas that are being extracted and likewise transformed to a \link{SpatialPolygonsDataFrame}. In case of kmz-files, no other areas can be selected.
}

\usage{
ggplot_geopos(x, ggobj, xlim, ylim, zlim, standard_year=FALSE, 
              full_year=standard_year, date_format, lang_format="en", tz="UTC", 
              Breaks, cb.title, cb.date_format, cbpos, cb.height = 10, cb.xlab = "",
              cb.reverse=FALSE, pal.reverse=cb.reverse, prob_lim=.75, color_by="date", 
              pal, alpha=70, type="p",
              main ,lwd=1, size=2, shape=19, verbose= FALSE, ...)
            
get_geopos(x, xlim, ylim, date_format, lang_format="en", tz="UTC", 
           proj4string, prob_lim=.5,verbose=TRUE)
}

\arguments{
\item{x}{

\link{data.frame} containing horziontal position records (allowed column names are 'Most.Likely.Longitude', 'Longitude' or 'Lon' and 'Most.Likely.Latitude', 'Latitude' or 'Lat', respectively. path and file name of \code{.csv}, \code{.kmz}, \code{.kml} or \code{.nc}-files, or a loaded nc-file via \code{get_geopos}.

Please note that netcdf- and kmz-file outputs from similiar probability thresholds (e.g. 0.50) may differ due to differences in the generation algorithm.

Please also note that the kmz-files from WC include only a subsample (up to 50) of the GPE3 likelihood areas. The kmz-file transformation is very fast, but due to the limitation stated above, only recommended for display purposes. Please contact WC if you need the complete GPE3 likelihood areas or use the netcdf-file transformation.
}

\item{ggobj}{
ggplot object.
}

%\item{v_area}{
%Character string used as a short key by the \link{oceanmap}-package to identify region (limits) to be plotted. See   \link{region_definitions} for existing for region definitions and use add.region to define new ones.
%}

\item{xlim, ylim}{
Numeric vector, defining the limts of the x and y-axes.
}

\item{zlim, Breaks, standard_year,full_year}{
date range and breaks of the colorbar. If standard_year is set \code{TRUE}, positions are standardized on a yearly basis and tick breaks are ignored.
If full_year is set \code{TRUE} as well, the color scale will cover all months from January until December.
}

\item{date_format, lang_format, tz}{
character strings indicating the date format, language format and the corresponding time zone, defined by the vectors Date and Time (by default: date_format="\%d-\%b-\%Y \%H:\%M:\%S", lang_format="en", tz='UTC')
If formatting fails, please check as well the input language format, defined by \code{lang_format} (and use abbrviations such as "en" for English,"es" for Spanish, "fr" for French, etc.) as well.
}

\item{proj4string}{
Coordinate reference system (CRS; \link{projection}).
}

\item{cb.title}{
character string indicating the title of the colorbar (by default \code{'Date'}.)
}

\item{cb.date_format}{
character strings indicating the date format of the color bar ticks (by default "\%Y-\%m-\%d").
}

\item{cbpos, cb.xlab, cb.height}{
position, xlab and height of the colorbar
}

\item{prob_lim}{
in case that a kmz, kml, or netcdf-file (.nc) is selected, the value defines the limit of the probability surfaces in \% (By default 0.50 for 50\%). Note that in case of kmz, kml-files valid values are 0.50, 0.95 or 0.99). Otherwise ignored.
}

\item{color_by}{
colomn or vector by which the geolocations should be colored (by default \code{"date"}).
}

\item{pal}{
  color map to be plotted in case of polygon (.nc-files) or scatter plots (default is the 'jet'-colormap, and 'year.jet' in case \code{standard_year} & \code{full_year} are set \code{TRUE}). See \link{cmap} for pre-installed color maps. Note that tracking data with constant time steps is being assumed in the color assignment. To verify this, a \link{data.frame} containing the colors at each time steps will be returned for polygon and scatter plots.
}

\item{cb.reverse, pal.reverse}{
  inverse order of ticks and colormap of colorscale.
}

\item{alpha}{transparency of polygons and dots to be plotted in percent (By default 70\%).
}

\item{type}{
character string giving the type of plot desired. The following values are possible, for details (By default "p" for points, but "l" for lines is also implemented).
}

\item{size, shape}{
size and dot-type (by default '19' for solid dots) of the points to be plotted (requires \code{'type'} set to points or line-points).
}

\item{lwd}{
line width
}

\item{\dots}{
additional arguments to be passed to \link[oceanmap]{ggplotmap}.
}

\item{main}{
an overall title for the plot
}

\item{verbose}{
whether the file names should be printed during loading geolocation files(By default \code{TRUE} for \code{get_geopos()}, but \code{FALSE} for \code{ggplot_geopos()}).
}

}


\seealso{\link{leaflet_geopos}, \link{ggplotly_geopos}, \link[oceanmap]{ggplotmap}} 


\author{
Robert K. Bauer
}

\examples{
# ## example 1a) line plot from several csv-files:
# library(oceanmap)
# csv_file <- system.file("example_files/15P1019-104659-1-GPE3.csv",package="RchivalTag")
# pos <- get_geopos(csv_file)  ## show tracks as line plot
# ggobj <- ggplot_geopos(pos)
# ggobj
# ggplotly_geopos(ggobj)
# 
# ## load second file and add to plot:
# csv_file2 <- system.file("example_files/14P0911-46177-1-GPE3.csv",package="RchivalTag")
# pos2 <- get_geopos(csv_file2)  ## show tracks as line plot
# ggobj2 <- ggplot_geopos(pos2)
# ggplotly_geopos(ggobj2)
# 
# pos3 <- rbind(pos,pos2)
# ggobj3 <- ggplot_geopos(pos3,type = "l")
# # ggobj3 <- ggplot_geopos(pos3,type = "b")
# # ggobj3 <- ggplot_geopos(pos3,type = "p")
# ggplotly_geopos(ggobj3)
# 
# 
# ## example 1b) scatter plot from csv-file on existing landmask:
# ggobj <- oceanmap::ggplotmap('lion',grid.res = 5) # use keyword to derive area limits
# ggobj4 <- ggplot_geopos(csv_file,ggobj)
# ggplotly_geopos(ggobj4)
# 
# ## alternatives:
# pos <- get_geopos(csv_file)
# r <- oceanmap::regions("lion")
# ggobj5 <- ggplot_geopos(pos, xlim = r$xlim, ylim = r$ylim)
# ggplotly_geopos(ggobj5)
# 
# 
# ## example 2) probability surfaces of horizontal tracks from nc-file:
# ## this can take some time as it inlcudes time consuming data processing
# nc_file <- system.file("example_files/15P1019-104659-1-GPE3.nc",package="RchivalTag")
# ggobj6 <- ggplot_geopos(nc_file)
# ggobj6
# ggplotly_geopos(ggobj6)
# 
# 
# ## alternative:
# pols_df <- get_geopos(nc_file)
# ggplot_geopos(pols_df)
# 
# 
# ## example 3) probability surfaces of horizontal tracks from kmz-file:
# kmz_file <- system.file("example_files/15P1019-104659-1-GPE3.kmz",package="RchivalTag")
# ggobj7 <- ggplot_geopos(kmz_file)
# ggobj7
# ggplotly_geopos(ggobj7)
# 
# 
# kmz_file2 <- system.file("example_files/15P0986-15P0986-2-GPE3.kmz",package="RchivalTag")
# ggobj8 <- ggplot_geopos(kmz_file2)
# ggobj8
# ggplotly_geopos(ggobj8)
# 
# ## example 4) combine polygon tracks:
# k1 = get_geopos(kmz_file)
# k2 = get_geopos(kmz_file2)
# 
# ggobj <- ggplotmap("mednw4")
# ## p1 <- ggplot_geopos(k1,ggobj = ggobj) ## not working, need to change date format:
# p1 <- ggplot_geopos(k1,grid.res=1)
# p1
# p2 <- ggplot_geopos(k2,p1,zlim = as.Date(range(c(k1$datetime,k2$datetime))))
# ggplotly_geopos(p2)
# 
# ## change plot window:
# p1b <- ggplot_geopos(k1,ggobj = ggobj)
# p2b <- ggplot_geopos(k2,p1b,zlim = as.Date(range(c(k1$datetime,k2$datetime))))
# p2b
# ggplotly_geopos(p2b)

}

