% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_utilities.R
\name{rvn_get_prd}
\alias{rvn_get_prd}
\title{Check period input}
\usage{
rvn_get_prd(x = NULL, prd = NULL)
}
\arguments{
\item{x}{xts object}

\item{prd}{period argument in format YYYY-MM-DD/YYYY-MM-DD as a character}
}
\value{
{prd argument with warnings provided if needed}
}
\description{
Checks a period argument either as
a character or against an xts object.
}
\details{
The function may take some combination of an xts object, a character string or both.

If a character is provided, the consistency of the character string against the YYYY-MM-DD/YYYY-MM-DD format
is checked. If an xts object is provided, the period for that xts object is returned. If both
are provided to the function, both checks are made and the consistency of the character period
against the xts object is performed. In any case, a period character string is returned.
}
\examples{
data(rvn_hydrograph_data)

# check if string is a valid prd argument
rvn_get_prd(prd="2000-10-01/2002-09-30")
# rvn_get_prd(prd="2000-10-01/2002-24-30") # returns error

# get full valid prd argument for xts object
rvn_get_prd(rvn_hydrograph_data$hyd$Sub43_obs)

# check prd argument against xts object
rvn_get_prd(rvn_hydrograph_data$hyd$Sub43_obs, "2020-01-01/2020-02-01")
# rvn_get_prd(rvn_hydrograph_data$hyd$Sub43_obs, "2002-24-01/2020-02-01") # returns error
# rvn_get_prd(rvn_hydrograph_data$hyd$Sub43_obs, "20-24-01/2020-02-01")   # returns error


}
\seealso{
\code{\link{rvn_theme_RavenR}} provides a theme for the RavenR package
}
