% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_wyear_indices.R
\name{rvn_wyear_indices}
\alias{rvn_wyear_indices}
\title{Water Year Indices}
\usage{
rvn_wyear_indices(x, mm = 9, dd = 30)
}
\arguments{
\item{x}{xts object or Date/POSITXtc series to obtain indices for}

\item{mm}{month of water year (default 9)}

\item{dd}{day of water year (default 30)}
}
\value{
\item{ep}{array of indices corresponding to start/end of
water years}
}
\description{
rvn_wyear_indices returns the indices of the provided time series for the
start/end of the water year. The month/day of the water year defaults to September 30 for
an October 1 water year cycle. However, this may be supplied as other values,
for example as June 30th for a July 1 water year (i.e. the Australian water year).
This function is useful in supplying endpoints for water year evaluations.
}
\details{
Note that this function is meant to emulate the \code{\link{endpoints}} function
for a water year period. The first and last points are included in all supplied endpoints,
which may introduce partial periods to the analysis.#'
}
\examples{

# read in sample forcings data
data(rvn_forcing_data)

# get the indices of the water year for October 1 (the default)
rvn_wyear_indices(rvn_forcing_data$forcings)
rvn_wyear_indices(rvn_forcing_data$forcings) \%>\%
rvn_forcing_data$forcings[., 1:2]

# get the indices of the start of the water year for July 1
## note that the last period is the last index, and not a complete water year period
rvn_wyear_indices(rvn_forcing_data$forcings, mm=6, dd=30) \%>\%
rvn_forcing_data$forcings[., 1:2]

}
\seealso{
\code{\link{rvn_apply_wyearly}} to apply functions over the water year
\code{\link{endpoints}} workhorse function for generating endpoints in xts for other periods
}
