% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{many}
\alias{many}
\title{\code{many} matches 0 or more of pattern \code{p}. In BNF notation, 
repetition occurs often enough to merit its own abbreviation. When zero or 
more repetitions of a phrase \code{p} are admissible, we simply write 
\code{p*}. The \code{many} combinator corresponds directly to this operator, 
and is defined in much the same way.}
\usage{
many(p)
}
\arguments{
\item{p}{is the parser to matched 0 or more times.}
}
\description{
This implementation of \code{many} differs from (Hutton92) due to the nature 
of R's data structures. Since R does not support the concept of a list of
tuples, we must revert to using a list rather than a vector, since all values
in an R vector must be the same datatype.
}
\examples{
Digit <- function(...) {satisfy(function(x) {return(!!length(grep("[0-9]", x)))})}
many(Digit()) ("123abc")
many(Digit()) ("abc")
}

