% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexplot.R
\name{hexplot}
\alias{hexplot}
\title{A hexplot function for Radviz objects}
\usage{
hexplot(
  x,
  main = NULL,
  nbins = 30,
  color = NULL,
  label.color,
  label.size,
  mincnt,
  style
)
}
\arguments{
\item{x}{a radviz object as produced by do.radviz}

\item{main}{[Optional] a title to the graph, displayed on top}

\item{nbins}{the number of equally spaced bins for the binning computation (see \link[ggplot2]{geom_hex}
for details)}

\item{color}{if color is not \code{NULL} and corresponds to one of the channels
in the \code{hexcols} slot of the Radviz object, cells will be colored
using colors in the \code{hexcols} slot}

\item{label.color}{deprecated, see \code{\link{do.radviz}}}

\item{label.size}{deprecated, see \code{\link{do.radviz}}}

\item{mincnt}{deprecated, see \code{\link{stat_summary_hex}} instead}

\item{style}{deprecated, see \code{\link{stat_summary_hex}} instead}
}
\value{
the internal ggplot2 object plus added layers, allowing for extra geoms to be added
}
\description{
Plots the Dimensional Anchors and a hexplot-based density representation
of projected data points in a 2D space.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
hexplot(rv,color='Sepal.Length')

}
\author{
Yann Abraham
}
