% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{unstableMaps}
\alias{unstableMaps}
\title{Notes on unstable maps}
\description{
Tips for exploring maps that are difficult to find a consistent optimal solution for.
}
\details{
Maps may be difficult to optimize or unstable for a variety of reasons, a common
one with larger maps being simply that it is difficult to find a global optima
and so many different local optima are found each time.

One approach that can sometimes
help is to consider running the optimizer with \code{options = list(dim_annealing = TRUE)}
(see see \code{vignette("intro-to-antigenic-cartography")} for an explanation of the
dimensional annealing approach). However be wary that in our experience, while applying
dimensional annealing can sometimes significantly speed up finding a better minima, it
can also sometimes be more prone to getting stuck in worse local optima.

If there are many missing or non-detectable titers it is also
possible that points in map are too poorly connected to find a robust
solution, to check this see \code{mapCohesion()}.
}
\seealso{
Other map diagnostic functions: 
\code{\link{agCohesion}()},
\code{\link{bootstrapBlobs}()},
\code{\link{bootstrapMap}()},
\code{\link{checkHemisphering}()},
\code{\link{dimensionTestMap}()},
\code{\link{logtiterTable}()},
\code{\link{map-table-distances}},
\code{\link{mapBootstrapCoords}},
\code{\link{mapDistances}()},
\code{\link{mapRelaxed}()},
\code{\link{mapResiduals}()},
\code{\link{pointStress}},
\code{\link{ptBootstrapBlob}},
\code{\link{ptBootstrapCoords}()},
\code{\link{ptLeverage}},
\code{\link{ptTriangulationBlob}},
\code{\link{recalculateStress}()},
\code{\link{stressTable}()},
\code{\link{tableColbases}()},
\code{\link{tableDistances}()},
\code{\link{triangulationBlobs}()}
}
\concept{map diagnostic functions}
