% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_viewer.R
\name{RacViewer.options}
\alias{RacViewer.options}
\title{Set viewer options}
\usage{
RacViewer.options(
  point.opacity = NA,
  viewer.controls = "hidden",
  grid.display = "static",
  grid.col = "#cfcfcf",
  background.col = "#ffffff",
  show.names = FALSE,
  show.errorlines = FALSE,
  show.connectionlines = FALSE,
  show.titers = FALSE,
  xlim = NULL,
  ylim = NULL,
  translation = c(0, 0, 0),
  rotation = c(0, 0, 0),
  zoom = NULL
)
}
\arguments{
\item{point.opacity}{Default opacity for unselected points, or "inherit" to take
opacity from the color values themselves.}

\item{viewer.controls}{Should viewer controls be shown or hidden by default?}

\item{grid.display}{For 3d maps, should the grid be fixed in the background
or enclose and rotate along with the map}

\item{grid.col}{Color to use for the grid shown behind the map}

\item{background.col}{Color for the viewer background}

\item{show.names}{Toggle name labels on, can be true or false or "antigens"
or "sera"}

\item{show.errorlines}{Toggle error lines on}

\item{show.connectionlines}{Toggle connection lines on}

\item{show.titers}{Toggle titer labels on}

\item{xlim}{x limits to zoom the plot to}

\item{ylim}{y limits to zoom the plot to}

\item{translation}{Plot starting translation}

\item{rotation}{Plot starting rotation as an XYZ Euler rotation}

\item{zoom}{Plot starting zoom factor}
}
\value{
Returns a named list of viewer options
}
\description{
This function facilitates setting racviewer options by returning a list of
option settings.
}
\seealso{
Other functions to view maps: 
\code{\link{RacViewer}()},
\code{\link{export_viewer}()},
\code{\link{ggplot.acmap}()},
\code{\link{mapGadget}()},
\code{\link{plot.acmap}()},
\code{\link{setLegend}()},
\code{\link{view.acmap}()},
\code{\link{view.default}()},
\code{\link{view}()}
}
\concept{functions to view maps}
