% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\docType{class}
\name{SCseq}
\alias{SCseq}
\alias{SCseq-class}
\title{The SCseq Class}
\arguments{
\item{object}{An SCseq object.}
}
\description{
The SCseq class is the central object storing all information generated during cell type identification with the RaceID3 algorithm.
It comprises a number of slots for a variety of objects.
}
\section{Slots}{

\describe{
\item{\code{expdata}}{The raw expression data matrix with cells as columns and genes as rows in sparse matrix format.}

\item{\code{ndata}}{Filtered data with expression normalized to one for each cell.}

\item{\code{noise}}{Matrix with local gene expression noise estimates (used for VarID analysis)}

\item{\code{counts}}{Vector with total transcript counts for each cell in \code{ndata} remaining after filtering.}

\item{\code{genes}}{Vector with gene names of all genes in \code{ndata} remaining after filtering.}

\item{\code{dimRed}}{list object object storing information on a feature matrix obtained by dimensional reduction, batch effect correction etc.
Component \code{x} stores the actual feature matrix.}

\item{\code{distances}}{distance (or dis-similarity) matrix computed by RaceID3.}

\item{\code{imputed}}{list with two matrices computed for imputing gene expression. The first matrix \code{nn} contains the cell indices of the \code{knn} nearest neighbours,
the second matrix contains the probabilities at which each cell contributes to thye imputed gene expression value for the cell correponding to the columns.}

\item{\code{tsne}}{data.frame with coordinates of two-dimensional tsne layout computed by RaceID3.}

\item{\code{fr}}{data.frame with coordinates of two-dimensional Fruchterman-Rheingold graphlayout computed by RaceID3.}

\item{\code{umap}}{data.frame with coordinates of two-dimensional umap representation computed by RaceID3.}

\item{\code{cluster}}{list storing information on the initial clustering step of the RaceID3 algorithm}

\item{\code{background}}{list storing the polynomial fit for the background model of gene expression variability computed by RaceID3,
which is used for outlier identification.}

\item{\code{out}}{list storing information on outlier cells used for the prediction of rare cell types by RaceID3}

\item{\code{cpart}}{vector containing the final clustering (i.e. cell type) partition computed by RaceID3}

\item{\code{fcol}}{vector contaning the colour scheme for the RaceID3 clusters}

\item{\code{medoids}}{vector containing the cell ids for th cluster medoids}

\item{\code{filterpar}}{list containing the parameters used for cell and gene filterung}

\item{\code{clusterpar}}{list containing the parameters used for clustering}

\item{\code{outlierpar}}{list containing the parameters used for outlier identification}
}}

