% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{compdist}
\alias{compdist}
\title{Computing a distance matrix for cell type inference}
\usage{
compdist(object, metric = "pearson", FSelect = TRUE, knn = NULL)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{metric}{Distances are computed from the filtered expression matrix after optional feature selection, dimensional reduction, and/or transformation (batch correction).
Possible values for \code{metric} are \code{"pearson", "spearman", "logpearson",  "euclidean"}.  Default is \code{"pearson"}. In case of the correlation based methods,
the distance is computed as 1 – correlation.}

\item{FSelect}{Logical parameter. If \code{TRUE}, then feature selection is performed prior to RaceID3 analysis. Default is \code{TRUE}.}

\item{knn}{Positive integer number of nearest neighbours used for imputing gene expression values. Default is \code{NULL} and no imputing is done.}
}
\value{
\code{SCseq} object with the distance matrix in slot \code{distances}. If \code{FSelect=TRUE}, the genes used for computing the distance object are stored in
slot \code{cluster$features}.
}
\description{
This functions computes the distance matrix used for cell type inference by RaceID3.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
}
