% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzmlFunctions.R
\name{grabSpectraMz}
\alias{grabSpectraMz}
\title{Extract the mass-to-charge data from the spectra of an mzML nodeset}
\usage{
grabSpectraMz(xml_nodes, file_metadata)
}
\arguments{
\item{xml_nodes}{An xml_nodeset object corresponding to the spectra collected
by the mass spectrometer, usually produced by applying `xml_find_all` to an
MS1 or MS2 nodeset.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information. Here, the compression and
mz precision information is relevant.}
}
\value{
A numeric vector of masses, many for each scan.
}
\description{
The mz and intensity information of mzML files are encoded as binary arrays,
sometimes compressed via gzip or zlib or numpress. This code finds all the
m/z binary arrays and converts them back to the original measurements. See
https://github.com/ProteoWizard/pwiz/issues/1301
}
