/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;

public class DatabaseSaver
extends AbstractSaver
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler {
    static final long serialVersionUID = 863971733782624956L;
    private DatabaseConnection m_DataBaseConnection;
    private String m_tableName;
    private String m_inputFile;
    private String m_createText;
    private String m_createDouble;
    private String m_createInt;
    private String m_createDate;
    private SimpleDateFormat m_DateFormat;
    private String m_idColumn;
    private int m_count;
    private boolean m_id;
    private boolean m_tabName;
    private String m_Username;
    private String m_Password;
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Properties PROPERTIES;

    public DatabaseSaver() throws Exception {
        this.resetOptions();
        this.m_createText = PROPERTIES.getProperty("CREATE_STRING");
        this.m_createDouble = PROPERTIES.getProperty("CREATE_DOUBLE");
        this.m_createInt = PROPERTIES.getProperty("CREATE_INT");
        this.m_createDate = PROPERTIES.getProperty("CREATE_DATE", "DATETIME");
        this.m_DateFormat = new SimpleDateFormat(PROPERTIES.getProperty("DateFormat", "yyyy-MM-dd HH:mm:ss"));
        this.m_idColumn = PROPERTIES.getProperty("idColumn");
    }

    public void resetOptions() {
        super.resetOptions();
        this.setRetrieval(0);
        this.m_tableName = "";
        this.m_Username = "";
        this.m_Password = "";
        this.m_count = 1;
        this.m_id = false;
        this.m_tabName = true;
        try {
            if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            this.m_DataBaseConnection = new DatabaseConnection();
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            try {
                this.m_DataBaseConnection.update("DROP TABLE " + this.m_tableName);
                if (this.m_DataBaseConnection.tableExists(this.m_tableName)) {
                    System.err.println("Table cannot be dropped.");
                }
            }
            catch (Exception ex) {
                this.printException(ex);
            }
            this.resetOptions();
        }
    }

    public String globalInfo() {
        return "Writes to a database (tested with MySQL, InstantDB, HSQLDB).";
    }

    public void setTableName(String tn) {
        this.m_tableName = tn;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String tableNameTipText() {
        return "Sets the name of the table.";
    }

    public void setAutoKeyGeneration(boolean flag) {
        this.m_id = flag;
    }

    public boolean getAutoKeyGeneration() {
        return this.m_id;
    }

    public String autoKeyGenerationTipText() {
        return "If set to true, a primary key column is generated automatically (containing the row number as INTEGER). The name of the key is read from DatabaseUtils (idColumn) This primary key can be used for incremental loading (requires an unique key). This primary key will not be loaded as an attribute.";
    }

    public void setRelationForTableName(boolean flag) {
        this.m_tabName = flag;
    }

    public boolean getRelationForTableName() {
        return this.m_tabName;
    }

    public String relationForTableNameTipText() {
        return "If set to true, the relation name will be used as name for the database table. Otherwise the user has to provide a table name.";
    }

    public void setUrl(String url) {
        this.m_DataBaseConnection.setDatabaseURL(url);
    }

    public String getUrl() {
        return this.m_DataBaseConnection.getDatabaseURL();
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    public void setUser(String user) {
        this.m_Username = user;
        this.m_DataBaseConnection.setUsername(user);
    }

    public String getUser() {
        return this.m_DataBaseConnection.getUsername();
    }

    public String userTipText() {
        return "The user name for the database";
    }

    public void setPassword(String password) {
        this.m_Password = password;
        this.m_DataBaseConnection.setPassword(password);
    }

    public String getPassword() {
        return this.m_DataBaseConnection.getPassword();
    }

    public String passwordTipText() {
        return "The database password";
    }

    public void setDestination(String url, String userName, String password) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(url);
            this.m_DataBaseConnection.setUsername(userName);
            this.m_DataBaseConnection.setPassword(password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setDestination(String url) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(url);
            this.m_DataBaseConnection.setUsername(this.m_Username);
            this.m_DataBaseConnection.setPassword(this.m_Password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void setDestination() {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setUsername(this.m_Username);
            this.m_DataBaseConnection.setPassword(this.m_Password);
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void writeStructure() throws Exception {
        StringBuffer query = new StringBuffer();
        Instances structure = this.getInstances();
        query.append("CREATE TABLE ");
        if (this.m_tabName || this.m_tableName.equals("")) {
            this.m_tableName = this.m_DataBaseConnection.maskKeyword(structure.relationName());
        }
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_tableName = this.m_tableName.toUpperCase();
            this.m_createInt = this.m_createInt.toUpperCase();
            this.m_createDouble = this.m_createDouble.toUpperCase();
            this.m_createText = this.m_createText.toUpperCase();
            this.m_createDate = this.m_createDate.toUpperCase();
        }
        this.m_tableName = this.m_tableName.replaceAll("[^\\w]", "_");
        this.m_tableName = this.m_DataBaseConnection.maskKeyword(this.m_tableName);
        query.append(this.m_tableName);
        if (structure.numAttributes() == 0) {
            throw new Exception("Instances have no attribute.");
        }
        query.append(" ( ");
        if (this.m_id) {
            if (this.m_DataBaseConnection.getUpperCase()) {
                this.m_idColumn = this.m_idColumn.toUpperCase();
            }
            query.append(this.m_DataBaseConnection.maskKeyword(this.m_idColumn));
            query.append(" ");
            query.append(this.m_createInt);
            query.append(" PRIMARY KEY,");
        }
        for (int i = 0; i < structure.numAttributes(); ++i) {
            Attribute att = structure.attribute(i);
            String attName = att.name();
            attName = attName.replaceAll("[^\\w]", "_");
            attName = this.m_DataBaseConnection.maskKeyword(attName);
            if (this.m_DataBaseConnection.getUpperCase()) {
                query.append(attName.toUpperCase());
            } else {
                query.append(attName);
            }
            if (att.isDate()) {
                query.append(" " + this.m_createDate);
            } else if (att.isNumeric()) {
                query.append(" " + this.m_createDouble);
            } else {
                query.append(" " + this.m_createText);
            }
            if (i == structure.numAttributes() - 1) continue;
            query.append(", ");
        }
        query.append(" )");
        this.m_DataBaseConnection.update(query.toString());
        this.m_DataBaseConnection.close();
        if (!this.m_DataBaseConnection.tableExists(this.m_tableName)) {
            throw new IOException("Table cannot be built.");
        }
    }

    private void writeInstance(Instance inst) throws Exception {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO ");
        insert.append(this.m_tableName);
        insert.append(" VALUES ( ");
        if (this.m_id) {
            insert.append(this.m_count);
            insert.append(", ");
            ++this.m_count;
        }
        for (int j = 0; j < inst.numAttributes(); ++j) {
            if (inst.isMissing(j)) {
                insert.append("NULL");
            } else if (inst.attribute(j).isDate()) {
                insert.append("'" + this.m_DateFormat.format((long)inst.value(j)) + "'");
            } else if (inst.attribute(j).isNumeric()) {
                insert.append(inst.value(j));
            } else {
                String stringInsert = "'" + inst.stringValue(j) + "'";
                if (stringInsert.length() > 2) {
                    stringInsert = stringInsert.replaceAll("''", "'");
                }
                insert.append(stringInsert);
            }
            if (j == inst.numAttributes() - 1) continue;
            insert.append(", ");
        }
        insert.append(" )");
        if (this.m_DataBaseConnection.update(insert.toString()) < 1) {
            throw new IOException("Tuple cannot be inserted.");
        }
        this.m_DataBaseConnection.close();
    }

    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (writeMode == 1) {
                if (structure == null) {
                    this.setWriteMode(2);
                    if (inst != null) {
                        throw new Exception("Structure(Header Information) has to be set in advance");
                    }
                } else {
                    this.setWriteMode(3);
                }
                writeMode = this.getWriteMode();
            }
            if (writeMode == 2) {
                this.cancel();
            }
            if (writeMode == 3) {
                this.setWriteMode(0);
                this.writeStructure();
                writeMode = this.getWriteMode();
            }
            if (writeMode == 0) {
                if (structure == null) {
                    throw new IOException("No instances information available.");
                }
                if (inst != null) {
                    this.writeInstance(inst);
                } else {
                    this.m_DataBaseConnection.disconnectFromDatabase();
                    this.resetStructure();
                    this.m_count = 1;
                }
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    public void writeBatch() throws IOException {
        Instances instances = this.getInstances();
        if (instances == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No database has been set up.");
        }
        this.setRetrieval(1);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            this.setWriteMode(0);
            this.writeStructure();
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.writeInstance(instances.instance(i));
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.setWriteMode(1);
            this.resetStructure();
            this.m_count = 1;
        }
        catch (Exception ex) {
            this.printException(ex);
        }
    }

    private void printException(Exception ex) {
        System.out.println("\n--- Exception caught ---\n");
        while (ex != null) {
            System.out.println("Message:   " + ex.getMessage());
            if (ex instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)ex).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)ex).getErrorCode());
                ex = ((SQLException)ex).getNextException();
            } else {
                ex = null;
            }
            System.out.println("");
        }
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getUrl() != null && this.getUrl().length() != 0) {
            options.add("-url");
            options.add(this.getUrl());
        }
        if (this.getUser() != null && this.getUser().length() != 0) {
            options.add("-user");
            options.add(this.getUser());
        }
        if (this.getPassword() != null && this.getPassword().length() != 0) {
            options.add("-password");
            options.add(this.getPassword());
        }
        if (this.m_tableName != null && this.m_tableName.length() != 0) {
            options.add("-T");
            options.add(this.m_tableName);
        }
        if (this.m_id) {
            options.add("-P");
        }
        if (this.m_inputFile != null && this.m_inputFile.length() != 0) {
            options.add("-i");
            options.add(this.m_inputFile);
        }
        return options.toArray(new String[options.size()]);
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe JDBC URL to connect to.\n\t(default: from DatabaseUtils.props file)", "url", 1, "-url <JDBC URL>"));
        newVector.addElement(new Option("\tThe user to connect with to the database.\n\t(default: none)", "user", 1, "-user <name>"));
        newVector.addElement(new Option("\tThe password to connect with to the database.\n\t(default: none)", "password", 1, "-password <password>"));
        newVector.addElement(new Option("\tThe name of the table.\n\t(default: the relation name)", "T", 1, "-T <table name>"));
        newVector.addElement(new Option("\tAdd an ID column as primary key. The name is specified\n\tin the DatabaseUtils file ('idColumn'). The DatabaseLoader\n\twon't load this column.", "P", 0, "-P"));
        newVector.addElement(new Option("\tInput file in arff format that should be saved in database.", "i", 1, "-i <input file name>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String tmpStr = Utils.getOption("url", options);
        if (tmpStr.length() != 0) {
            this.setUrl(tmpStr);
        }
        if ((tmpStr = Utils.getOption("user", options)).length() != 0) {
            this.setUser(tmpStr);
        }
        if ((tmpStr = Utils.getOption("password", options)).length() != 0) {
            this.setPassword(tmpStr);
        }
        String tableString = Utils.getOption('T', options);
        String inputString = Utils.getOption('i', options);
        if (tableString.length() != 0) {
            this.m_tableName = tableString;
            this.m_tabName = false;
        }
        this.m_id = Utils.getFlag('P', options);
        if (inputString.length() != 0) {
            try {
                this.m_inputFile = inputString;
                ArffLoader al = new ArffLoader();
                File inputFile = new File(inputString);
                al.setSource(inputFile);
                this.setInstances(al.getDataSet());
                if (tableString.length() == 0) {
                    this.m_tableName = this.getInstances().relationName();
                }
            }
            catch (Exception ex) {
                this.printException(ex);
                ex.printStackTrace();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] options) {
        StringBuffer text = new StringBuffer();
        text.append("\n\nDatabaseSaver options:\n");
        try {
            DatabaseSaver asv = new DatabaseSaver();
            try {
                Enumeration enumi = asv.listOptions();
                while (enumi.hasMoreElements()) {
                    Option option = (Option)enumi.nextElement();
                    text.append(option.synopsis() + '\n');
                    text.append(option.description() + '\n');
                }
                asv.setOptions(options);
                asv.setDestination();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            asv.writeBatch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(text);
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception ex) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(ex);
        }
    }
}

