/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import weka.gui.beans.InteractiveTableModel;

public class InteractiveTablePanel
extends JPanel {
    private static final long serialVersionUID = 4495705463732140410L;
    protected String[] m_columnNames;
    protected JTable m_table;
    protected JScrollPane m_scroller;
    protected InteractiveTableModel m_tableModel;

    public InteractiveTablePanel(String[] colNames) {
        this.m_columnNames = colNames;
        this.initComponent();
    }

    public void initComponent() {
        this.m_tableModel = new InteractiveTableModel(this.m_columnNames);
        this.m_tableModel.addTableModelListener(new InteractiveTableModelListener());
        this.m_table = new JTable();
        this.m_table.setModel(this.m_tableModel);
        this.m_table.setSurrendersFocusOnKeystroke(true);
        if (!this.m_tableModel.hasEmptyRow()) {
            this.m_tableModel.addEmptyRow();
        }
        InteractiveTableModel model = (InteractiveTableModel)this.m_table.getModel();
        this.m_scroller = new JScrollPane(this.m_table);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(500, 80));
        TableColumn hidden = this.m_table.getColumnModel().getColumn(model.m_hidden_index);
        hidden.setMinWidth(2);
        hidden.setPreferredWidth(2);
        hidden.setMaxWidth(2);
        hidden.setCellRenderer(new InteractiveRenderer(model.m_hidden_index));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_scroller, "Center");
    }

    public JTable getTable() {
        return this.m_table;
    }

    public void highlightLastRow(int row) {
        int lastrow = this.m_tableModel.getRowCount();
        if (row == lastrow - 1) {
            this.m_table.setRowSelectionInterval(lastrow - 1, lastrow - 1);
        } else {
            this.m_table.setRowSelectionInterval(row + 1, row + 1);
        }
        this.m_table.setColumnSelectionInterval(0, 0);
    }

    public class InteractiveTableModelListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int column = evt.getColumn();
                int row = evt.getFirstRow();
                InteractiveTablePanel.this.m_table.setColumnSelectionInterval(column + 1, column + 1);
                InteractiveTablePanel.this.m_table.setRowSelectionInterval(row, row);
            }
        }
    }

    class InteractiveRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6186813827783402502L;
        protected int m_interactiveColumn;

        public InteractiveRenderer(int interactiveColumn) {
            this.m_interactiveColumn = interactiveColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == this.m_interactiveColumn && hasFocus) {
                if (InteractiveTablePanel.this.m_tableModel.getRowCount() - 1 == row && !InteractiveTablePanel.this.m_tableModel.hasEmptyRow()) {
                    InteractiveTablePanel.this.m_tableModel.addEmptyRow();
                }
                InteractiveTablePanel.this.highlightLastRow(row);
            }
            return c;
        }
    }
}

