/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class Kernel
implements Serializable,
OptionHandler,
CapabilitiesHandler,
CapabilitiesIgnorer,
RevisionHandler {
    private static final long serialVersionUID = -6102771099905817064L;
    protected Instances m_data;
    protected boolean m_Debug = false;
    protected boolean m_ChecksTurnedOff = false;
    protected boolean m_DoNotCheckCapabilities = false;

    public String doNotCheckCapabilitiesTipText() {
        return "If set, associator capabilities are not checked before associator is built (Use with caution to reduce runtime).";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public abstract String globalInfo();

    public abstract double eval(int var1, int var2, Instance var3) throws Exception;

    public abstract void clean();

    public abstract int numEvals();

    public abstract int numCacheHits();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tEnables debugging output (if available) to be printed.\n\t(default: off)", "output-debug-info", 0, "-output-debug-info"));
        result.addElement(new Option("\tTurns off all checks - use with caution!\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag("output-debug-info", options));
        this.setChecksTurnedOff(Utils.getFlag("no-checks", options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-output-debug-info");
        }
        if (this.getChecksTurnedOff()) {
            result.add("-no-checks");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Turns on the output of debugging information.";
    }

    public void setChecksTurnedOff(boolean value) {
        this.m_ChecksTurnedOff = value;
    }

    public boolean getChecksTurnedOff() {
        return this.m_ChecksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    protected void initVars(Instances data) {
        this.m_data = data;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11013 $");
    }

    public void buildKernel(Instances data) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(data);
        }
        this.initVars(data);
    }

    public static Kernel makeCopy(Kernel kernel) throws Exception {
        if (kernel instanceof Copyable) {
            return (Kernel)((Copyable)((Object)kernel)).copy();
        }
        return (Kernel)new SerializedObject(kernel).getObject();
    }

    public static Kernel[] makeCopies(Kernel model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model kernel set");
        }
        Kernel[] kernels = new Kernel[num];
        if (model instanceof Copyable) {
            for (int i = 0; i < kernels.length; ++i) {
                kernels[i] = (Kernel)((Copyable)((Object)model)).copy();
            }
        } else {
            SerializedObject so = new SerializedObject(model);
            for (int i = 0; i < kernels.length; ++i) {
                kernels[i] = (Kernel)so.getObject();
            }
        }
        return kernels;
    }

    public static Kernel forName(String kernelName, String[] options) throws Exception {
        return (Kernel)Utils.forName(Kernel.class, kernelName, options);
    }
}

