/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import weka.classifiers.UpdateableClassifier;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.Classifier;

public class ClassifierCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -6688000820160821429L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private JPanel m_incrementalPanel = new JPanel();
    private JCheckBox m_updateIncrementalClassifier = new JCheckBox("Update classifier on incoming instance stream");
    private boolean m_panelVisible = false;

    public ClassifierCustomizer() {
        this.m_updateIncrementalClassifier.setToolTipText("Train the classifier on each individual incoming streamed instance.");
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier classifier = this.m_dsClassifier.getClassifier();
        if (classifier instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
            }
        } else if (this.m_panelVisible) {
            this.remove(this.m_incrementalPanel);
            this.m_panelVisible = false;
        }
    }

    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifier());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.checkOnClassifierType();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

