/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class RandomSubset
extends SimpleStreamFilter {
    private static final long serialVersionUID = 2911221724251628050L;
    protected double m_NumAttributes = 0.5;
    protected int m_Seed = 1;
    protected int[] m_Indices = null;

    public String globalInfo() {
        return "Chooses a random subset of attributes, either an absolute number or a percentage. The class is always included in the output (as the last attribute).";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe number of attributes to randomly select.\n\tIf < 1 then percentage, >= 1 absolute number.\n\t(default: 0.5)", "N", 1, "-N <double>"));
        vector.addElement(new Option("\tThe seed value.\n\t(default: 1)", "S", 1, "-S <int>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-N");
        vector.add("" + this.m_NumAttributes);
        vector.add("-S");
        vector.add("" + this.m_Seed);
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption("N", stringArray);
        if (string.length() != 0) {
            this.setNumAttributes(Double.parseDouble(string));
        } else {
            this.setNumAttributes(0.5);
        }
        string = Utils.getOption("S", stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
        super.setOptions(stringArray);
    }

    public String numAttributesTipText() {
        return "The number of attributes to choose: < 1 percentage, >= 1 absolute number.";
    }

    public double getNumAttributes() {
        return this.m_NumAttributes;
    }

    public void setNumAttributes(double d) {
        this.m_NumAttributes = d;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        int n;
        int n2 = instances.numAttributes();
        if (instances.classIndex() > -1) {
            --n2;
        }
        if (this.m_NumAttributes < 1.0) {
            n2 = (int)Math.round((double)n2 * this.m_NumAttributes);
        } else if (this.m_NumAttributes < (double)n2) {
            n2 = (int)this.m_NumAttributes;
        }
        if (this.getDebug()) {
            System.out.println("# of atts: " + n2);
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            vector.add(n);
        }
        Vector vector2 = new Vector();
        Random random = new Random(this.m_Seed);
        for (n = 0; n < n2; ++n) {
            int n3 = random.nextInt(vector.size());
            vector2.add(vector.get(n3));
            vector.remove(n3);
        }
        Collections.sort(vector2);
        if (instances.classIndex() > -1) {
            vector2.add(instances.classIndex());
        }
        if (this.getDebug()) {
            System.out.println("indices: " + vector2);
        }
        FastVector fastVector = new FastVector();
        this.m_Indices = new int[vector2.size()];
        for (n = 0; n < vector2.size(); ++n) {
            fastVector.addElement(instances.attribute((Integer)vector2.get(n)));
            this.m_Indices[n] = (Integer)vector2.get(n);
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector, 0);
        if (instances.classIndex() > -1) {
            instances2.setClassIndex(instances2.numAttributes() - 1);
        }
        return instances2;
    }

    protected Instance process(Instance instance) throws Exception {
        double[] dArray = new double[this.m_Indices.length];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            dArray[i] = instance.value(this.m_Indices[i]);
        }
        Instance instance2 = new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        return instance2;
    }

    public static void main(String[] stringArray) {
        RandomSubset.runFilter(new RandomSubset(), stringArray);
    }
}

