/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixCSV
extends ResultMatrix {
    private static final long serialVersionUID = -171838863135042743L;

    public ResultMatrixCSV() {
        this(1, 1);
    }

    public ResultMatrixCSV(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixCSV(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "CSV";
    }

    public void clear() {
        super.clear();
        this.setRowNameWidth(25);
        this.setPrintColNames(false);
        this.setEnumerateColNames(true);
        this.LEFT_PARENTHESES = "[";
        this.RIGHT_PARENTHESES = "]";
    }

    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    public String toStringMatrix() {
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Utils.quote(stringArray[i][j]));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toStringKey() {
        String string = "Key,\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            string = string + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + "," + Utils.quote(this.removeFilterName(this.m_ColNames[i])) + "\n";
        }
        return string;
    }

    public String toStringSummary() {
        int n;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String string = "";
        String string2 = "";
        int n2 = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            if (!string2.equals("")) {
                string2 = string2 + ",";
            }
            string2 = string2 + this.getSummaryTitle(n);
        }
        string = string + string2 + ",'(No. of datasets where [col] >> [row])'\n";
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            String string3 = "";
            for (int i = 0; i < this.getColCount(); ++i) {
                if (this.getColHidden(i)) continue;
                if (!string3.equals("")) {
                    string3 = string3 + ",";
                }
                string3 = i == n ? string3 + "-" : string3 + this.m_NonSigWins[n][i] + " (" + this.m_Wins[n][i] + ")";
            }
            string = string + string3 + "," + this.getSummaryTitle(n) + " = " + this.removeFilterName(this.m_ColNames[n]) + '\n';
        }
        return string;
    }

    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int n = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int n2 = Math.max(2 + (int)(Math.log(n) / Math.log(10.0)), ">-<".length());
        String string = ">-<,>,<,Resultset\n";
        int[] nArray = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (this.getColHidden(n3)) continue;
            string = string + this.m_RankingDiff[n3] + "," + this.m_RankingWins[n3] + "," + this.m_RankingLosses[n3] + "," + this.removeFilterName(this.m_ColNames[n3]) + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ResultMatrixCSV resultMatrixCSV = new ResultMatrixCSV(3, 3);
        resultMatrixCSV.addHeader("header1", "value1");
        resultMatrixCSV.addHeader("header2", "value2");
        resultMatrixCSV.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixCSV.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixCSV.getColCount(); ++j) {
                resultMatrixCSV.setMean(j, i, (i + 1) * j);
                resultMatrixCSV.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixCSV.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixCSV.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixCSV).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        resultMatrixCSV.setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixCSV.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixCSV.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixCSV.setRowHidden(2, true);
        resultMatrixCSV.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixCSV.setMeanPrec(3);
        resultMatrixCSV.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixCSV).toStringMatrix());
    }
}

