/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;

public abstract class NormalizableDistance
implements DistanceFunction,
OptionHandler,
Serializable {
    public static final int R_MIN = 0;
    public static final int R_MAX = 1;
    public static final int R_WIDTH = 2;
    protected Instances m_Data = null;
    protected boolean m_DontNormalize = false;
    protected double[][] m_Ranges;
    protected Range m_AttributeIndices = new Range("first-last");
    protected boolean[] m_ActiveIndices;
    protected boolean m_Validated;

    public NormalizableDistance() {
        this.invalidate();
    }

    public NormalizableDistance(Instances instances) {
        this.setInstances(instances);
    }

    public abstract String globalInfo();

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tTurns off the normalization of attribute \n\tvalues in distance calculation.", "D", 0, "-D"));
        vector.addElement(new Option("\tSpecifies list of columns to used in the calculation of the \n\tdistance. 'first' and 'last' are valid indices.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tInvert matching sense of column indices.", "V", 0, "-V"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDontNormalize()) {
            vector.add("-D");
        }
        vector.add("-R");
        vector.add(this.getAttributeIndices());
        if (this.getInvertSelection()) {
            vector.add("-V");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDontNormalize(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
    }

    public String dontNormalizeTipText() {
        return "Whether if the normalization of attributes should be turned off for distance calculation (Default: false i.e. attribute values are normalized). ";
    }

    public void setDontNormalize(boolean bl) {
        this.m_DontNormalize = bl;
        this.invalidate();
    }

    public boolean getDontNormalize() {
        return this.m_DontNormalize;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String string) {
        this.m_AttributeIndices.setRanges(string);
        this.invalidate();
    }

    public String getAttributeIndices() {
        return this.m_AttributeIndices.getRanges();
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be used in the distance calculation; if true, only non-selected attributes will be used for the calculation.";
    }

    public void setInvertSelection(boolean bl) {
        this.m_AttributeIndices.setInvert(bl);
        this.invalidate();
    }

    public boolean getInvertSelection() {
        return this.m_AttributeIndices.getInvert();
    }

    protected void invalidate() {
        this.m_Validated = false;
    }

    protected void validate() {
        if (!this.m_Validated) {
            this.initialize();
            this.m_Validated = true;
        }
    }

    protected void initialize() {
        this.initializeAttributeIndices();
        this.initializeRanges();
    }

    protected void initializeAttributeIndices() {
        this.m_AttributeIndices.setUpper(this.m_Data.numAttributes() - 1);
        this.m_ActiveIndices = new boolean[this.m_Data.numAttributes()];
        for (int i = 0; i < this.m_ActiveIndices.length; ++i) {
            this.m_ActiveIndices[i] = this.m_AttributeIndices.isInRange(i);
        }
    }

    public void setInstances(Instances instances) {
        this.m_Data = instances;
        this.invalidate();
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public void postProcessDistances(double[] dArray) {
    }

    public void update(Instance instance) {
        this.validate();
        this.m_Ranges = this.updateRanges(instance, this.m_Ranges);
    }

    public double distance(Instance instance, Instance instance2) {
        return this.distance(instance, instance2, null);
    }

    public double distance(Instance instance, Instance instance2, PerformanceStats performanceStats) {
        return this.distance(instance, instance2, Double.POSITIVE_INFINITY, performanceStats);
    }

    public double distance(Instance instance, Instance instance2, double d) {
        return this.distance(instance, instance2, d, null);
    }

    public double distance(Instance instance, Instance instance2, double d, PerformanceStats performanceStats) {
        double d2 = 0.0;
        int n = instance.numValues();
        int n2 = instance2.numValues();
        int n3 = this.m_Data.numAttributes();
        int n4 = this.m_Data.classIndex();
        this.validate();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n || n6 < n2) {
            double d3;
            int n7 = n5 >= n ? n3 : instance.index(n5);
            int n8 = n6 >= n2 ? n3 : instance2.index(n6);
            if (n7 == n4) {
                ++n5;
                continue;
            }
            if (n7 < n3 && !this.m_ActiveIndices[n7]) {
                ++n5;
                continue;
            }
            if (n8 == n4) {
                ++n6;
                continue;
            }
            if (n8 < n3 && !this.m_ActiveIndices[n8]) {
                ++n6;
                continue;
            }
            if (n7 == n8) {
                d3 = this.difference(n7, instance.valueSparse(n5), instance2.valueSparse(n6));
                ++n5;
                ++n6;
            } else if (n7 > n8) {
                d3 = this.difference(n8, 0.0, instance2.valueSparse(n6));
                ++n6;
            } else {
                d3 = this.difference(n7, instance.valueSparse(n5), 0.0);
                ++n5;
            }
            if (performanceStats != null) {
                performanceStats.incrCoordCount();
            }
            if (!((d2 = this.updateDistance(d2, d3)) > d)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    protected abstract double updateDistance(double var1, double var3);

    protected double norm(double d, int n) {
        if (Double.isNaN(this.m_Ranges[n][0]) || this.m_Ranges[n][1] == this.m_Ranges[n][0]) {
            return 0.0;
        }
        return (d - this.m_Ranges[n][0]) / this.m_Ranges[n][2];
    }

    protected double difference(int n, double d, double d2) {
        switch (this.m_Data.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    double d3;
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        if (!this.m_DontNormalize) {
                            return 1.0;
                        }
                        return this.m_Ranges[n][1] - this.m_Ranges[n][0];
                    }
                    if (Instance.isMissingValue(d2)) {
                        d3 = !this.m_DontNormalize ? this.norm(d, n) : d;
                    } else {
                        double d4 = d3 = !this.m_DontNormalize ? this.norm(d2, n) : d2;
                    }
                    if (!this.m_DontNormalize && d3 < 0.5) {
                        d3 = 1.0 - d3;
                    } else if (this.m_DontNormalize) {
                        if (this.m_Ranges[n][1] - d3 > d3 - this.m_Ranges[n][0]) {
                            return this.m_Ranges[n][1] - d3;
                        }
                        return d3 - this.m_Ranges[n][0];
                    }
                    return d3;
                }
                return !this.m_DontNormalize ? this.norm(d, n) - this.norm(d2, n) : d - d2;
            }
        }
        return 0.0;
    }

    public double[][] initializeRanges() {
        if (this.m_Data == null) {
            this.m_Ranges = null;
            return this.m_Ranges;
        }
        int n = this.m_Data.numAttributes();
        double[][] dArray = new double[n][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n, dArray);
            this.m_Ranges = dArray;
            return this.m_Ranges;
        }
        this.updateRangesFirst(this.m_Data.instance(0), n, dArray);
        for (int i = 1; i < this.m_Data.numInstances(); ++i) {
            this.updateRanges(this.m_Data.instance(i), n, dArray);
        }
        this.m_Ranges = dArray;
        return this.m_Ranges;
    }

    public void updateRangesFirst(Instance instance, int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            if (!instance.isMissing(i)) {
                dArray[i][0] = instance.value(i);
                dArray[i][1] = instance.value(i);
                dArray[i][2] = 0.0;
                continue;
            }
            dArray[i][0] = Double.POSITIVE_INFINITY;
            dArray[i][1] = Double.NEGATIVE_INFINITY;
            dArray[i][2] = Double.POSITIVE_INFINITY;
        }
    }

    public void updateRanges(Instance instance, int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            double d = instance.value(i);
            if (instance.isMissing(i)) continue;
            if (d < dArray[i][0]) {
                dArray[i][0] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                if (!(d > dArray[i][1])) continue;
                dArray[i][1] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                continue;
            }
            if (!(d > dArray[i][1])) continue;
            dArray[i][1] = d;
            dArray[i][2] = dArray[i][1] - dArray[i][0];
        }
    }

    public void initializeRangesEmpty(int n, double[][] dArray) {
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = Double.POSITIVE_INFINITY;
            dArray[i][1] = Double.NEGATIVE_INFINITY;
            dArray[i][2] = Double.POSITIVE_INFINITY;
        }
    }

    public double[][] updateRanges(Instance instance, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = instance.value(i);
            if (instance.isMissing(i)) continue;
            if (d < dArray[i][0]) {
                dArray[i][0] = d;
                dArray[i][2] = dArray[i][1] - dArray[i][0];
                continue;
            }
            if (!(instance.value(i) > dArray[i][1])) continue;
            dArray[i][1] = d;
            dArray[i][2] = dArray[i][1] - dArray[i][0];
        }
        return dArray;
    }

    public double[][] initializeRanges(int[] nArray) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int n = this.m_Data.numAttributes();
        double[][] dArray = new double[n][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n, dArray);
            return dArray;
        }
        this.updateRangesFirst(this.m_Data.instance(nArray[0]), n, dArray);
        for (int i = 1; i < nArray.length; ++i) {
            this.updateRanges(this.m_Data.instance(nArray[i]), n, dArray);
        }
        return dArray;
    }

    public double[][] initializeRanges(int[] nArray, int n, int n2) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int n3 = this.m_Data.numAttributes();
        double[][] dArray = new double[n3][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(n3, dArray);
            return dArray;
        }
        this.updateRangesFirst(this.m_Data.instance(nArray[n]), n3, dArray);
        for (int i = n + 1; i <= n2; ++i) {
            this.updateRanges(this.m_Data.instance(nArray[i]), n3, dArray);
        }
        return dArray;
    }

    public void updateRanges(Instance instance) {
        this.validate();
        this.m_Ranges = this.updateRanges(instance, this.m_Ranges);
    }

    public boolean inRanges(Instance instance, double[][] dArray) {
        boolean bl = true;
        for (int i = 0; bl && i < dArray.length; ++i) {
            if (instance.isMissing(i)) continue;
            double d = instance.value(i);
            boolean bl2 = bl = d <= dArray[i][1];
            if (!bl) continue;
            bl = d >= dArray[i][0];
        }
        return bl;
    }

    public boolean rangesSet() {
        return this.m_Ranges != null;
    }

    public double[][] getRanges() throws Exception {
        this.validate();
        if (this.m_Ranges == null) {
            throw new Exception("Ranges not yet set.");
        }
        return this.m_Ranges;
    }

    public String toString() {
        return "";
    }
}

