/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.gui.GenericPropertiesCreator;

public class FindWithCapabilities
implements OptionHandler,
CapabilitiesHandler {
    protected Capabilities m_Capabilities = new Capabilities(this);
    protected Capabilities m_NotCapabilities = new Capabilities(this);
    protected Vector m_Packages = new Vector();
    protected CapabilitiesHandler m_Handler = null;
    protected String m_Filename = "";
    protected SingleIndex m_ClassIndex = new SingleIndex();
    protected String m_Superclass = "";
    protected boolean m_GenericPropertiesCreator = false;
    protected Vector m_Matches = new Vector();
    protected Vector m_Misses = new Vector();

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("", "", 0, "All class and attribute options can be prefixed with 'not',\ne.g., '-not-numeric-class'. This makes sure that the returned\nschemes 'cannot' handle numeric classes."));
        vector.addElement(new Option("\tThe minimum number of instances (default 1).", "num-instances", 1, "-num-instances <num>"));
        vector.addElement(new Option("\tMust handle unray classes.", "unary-class", 0, "-unary-class"));
        vector.addElement(new Option("\tMust handle binary classes.", "binary-class", 0, "-binary-class"));
        vector.addElement(new Option("\tMust handle nominal classes.", "nominal-class", 0, "-nominal-class"));
        vector.addElement(new Option("\tMust handle numeric classes.", "numeric-class", 0, "-numeric-class"));
        vector.addElement(new Option("\tMust handle string classes.", "string-class", 0, "-string-class"));
        vector.addElement(new Option("\tMust handle date classes.", "date-class", 0, "-date-class"));
        vector.addElement(new Option("\tMust handle relational classes.", "relational-class", 0, "-relational-class"));
        vector.addElement(new Option("\tDoesn't need a class.", "no-class", 0, "-no-class"));
        vector.addElement(new Option("\tMust handle unary attributes.", "unary-atts", 0, "-unary-atts"));
        vector.addElement(new Option("\tMust handle binary attributes.", "binary-atts", 0, "-binary-atts"));
        vector.addElement(new Option("\tMust handle nominal attributes.", "nominal-atts", 0, "-nominal-atts"));
        vector.addElement(new Option("\tMust handle numeric attributes.", "numeric-atts", 0, "-numeric-atts"));
        vector.addElement(new Option("\tMust handle string attributes.", "string-atts", 0, "-string-atts"));
        vector.addElement(new Option("\tMust handle date attributes.", "date-atts", 0, "-date-atts"));
        vector.addElement(new Option("\tMust handle relational attributes.", "relational-atts", 0, "-relational-atts"));
        vector.addElement(new Option("\tMust handle multi-instance data.", "only-multiinstance", 0, "-only-multiinstance"));
        vector.addElement(new Option("\tThe Capabilities handler to base the handling on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler. Additional parameters for\n\thandler can be passed on after the '--'.\n\tEither '-W' or '-t' can be used.", "W", 1, "-W <classname>"));
        vector.addElement(new Option("\tThe dataset to base the capabilities on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler.\n\tEither '-t' or '-W' can be used.", "t", 1, "-t <file>"));
        vector.addElement(new Option("\tThe index of the class attribute, -1 for none.\n\t'first' and 'last' are also valid.\n\tOnly in conjunction with option '-t'.", "c", 1, "-c <num>"));
        vector.addElement(new Option("\tSuperclass to look for in the packages.\n", "superclass", 1, "-superclass"));
        vector.addElement(new Option("\tComma-separated list of packages to search in.", "packages", 1, "-packages"));
        vector.addElement(new Option("\tRetrieves the package list from the GenericPropertiesCreator\n\tfor the given superclass. (overrides -packages <list>).", "generic", 1, "-generic"));
        vector.addElement(new Option("\tAlso prints the classname that didn't match the criteria.", "misses", 0, "-misses"));
        return vector.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOptions(String[] stringArray) throws Exception {
        StringTokenizer stringTokenizer;
        this.m_Capabilities = new Capabilities(this);
        boolean bl = false;
        String string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            Class<?> clazz = Class.forName(string);
            if (!ClassDiscovery.hasInterface(CapabilitiesHandler.class, clazz)) throw new IllegalArgumentException("Class '" + string + "' is not a CapabilitiesHandler!");
            bl = true;
            CapabilitiesHandler capabilitiesHandler = (CapabilitiesHandler)clazz.newInstance();
            if (capabilitiesHandler instanceof OptionHandler) {
                ((OptionHandler)((Object)capabilitiesHandler)).setOptions(Utils.partitionOptions(stringArray));
            }
            this.setHandler(capabilitiesHandler);
        } else {
            string = Utils.getOption('c', stringArray);
            if (string.length() != 0) {
                this.setClassIndex(string);
            } else {
                this.setClassIndex("last");
            }
            string = Utils.getOption('t', stringArray);
            this.setFilename(string);
        }
        string = Utils.getOption("num-instances", stringArray);
        if (string.length() != 0) {
            this.m_Capabilities.setMinimumNumberInstances(Integer.parseInt(string));
        } else if (!bl) {
            this.m_Capabilities.setMinimumNumberInstances(1);
        }
        if (Utils.getFlag("no-class", stringArray)) {
            this.enable(Capabilities.Capability.NO_CLASS);
        }
        if (Utils.getFlag("not-no-class", stringArray)) {
            this.enableNot(Capabilities.Capability.NO_CLASS);
        }
        if (!this.m_Capabilities.handles(Capabilities.Capability.NO_CLASS)) {
            if (Utils.getFlag("nominal-class", stringArray)) {
                this.enable(Capabilities.Capability.NOMINAL_CLASS);
                this.disable(Capabilities.Capability.BINARY_CLASS);
            }
            if (Utils.getFlag("binary-class", stringArray)) {
                this.enable(Capabilities.Capability.BINARY_CLASS);
                this.disable(Capabilities.Capability.UNARY_CLASS);
            }
            if (Utils.getFlag("unary-class", stringArray)) {
                this.enable(Capabilities.Capability.UNARY_CLASS);
            }
            if (Utils.getFlag("numeric-class", stringArray)) {
                this.enable(Capabilities.Capability.NUMERIC_CLASS);
            }
            if (Utils.getFlag("string-class", stringArray)) {
                this.enable(Capabilities.Capability.STRING_CLASS);
            }
            if (Utils.getFlag("date-class", stringArray)) {
                this.enable(Capabilities.Capability.DATE_CLASS);
            }
            if (Utils.getFlag("relational-class", stringArray)) {
                this.enable(Capabilities.Capability.RELATIONAL_CLASS);
            }
        }
        if (Utils.getFlag("not-nominal-class", stringArray)) {
            this.enableNot(Capabilities.Capability.NOMINAL_CLASS);
            this.disableNot(Capabilities.Capability.BINARY_CLASS);
        }
        if (Utils.getFlag("not-binary-class", stringArray)) {
            this.enableNot(Capabilities.Capability.BINARY_CLASS);
            this.disableNot(Capabilities.Capability.UNARY_CLASS);
        }
        if (Utils.getFlag("not-unary-class", stringArray)) {
            this.enableNot(Capabilities.Capability.UNARY_CLASS);
        }
        if (Utils.getFlag("not-numeric-class", stringArray)) {
            this.enableNot(Capabilities.Capability.NUMERIC_CLASS);
        }
        if (Utils.getFlag("not-string-class", stringArray)) {
            this.enableNot(Capabilities.Capability.STRING_CLASS);
        }
        if (Utils.getFlag("not-date-class", stringArray)) {
            this.enableNot(Capabilities.Capability.DATE_CLASS);
        }
        if (Utils.getFlag("not-relational-class", stringArray)) {
            this.enableNot(Capabilities.Capability.RELATIONAL_CLASS);
        }
        if (Utils.getFlag("nominal-atts", stringArray)) {
            this.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
            this.disable(Capabilities.Capability.BINARY_ATTRIBUTES);
        }
        if (Utils.getFlag("binary-atts", stringArray)) {
            this.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
            this.disable(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("unary-atts", stringArray)) {
            this.enable(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("numeric-atts", stringArray)) {
            this.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        }
        if (Utils.getFlag("string-atts", stringArray)) {
            this.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        }
        if (Utils.getFlag("date-atts", stringArray)) {
            this.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        }
        if (Utils.getFlag("relational-atts", stringArray)) {
            this.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        }
        if (Utils.getFlag("not-nominal-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.NOMINAL_ATTRIBUTES);
            this.disableNot(Capabilities.Capability.BINARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-binary-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.BINARY_ATTRIBUTES);
            this.disableNot(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-unary-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.UNARY_ATTRIBUTES);
        }
        if (Utils.getFlag("not-numeric-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        }
        if (Utils.getFlag("not-string-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.STRING_ATTRIBUTES);
        }
        if (Utils.getFlag("not-date-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.DATE_ATTRIBUTES);
        }
        if (Utils.getFlag("not-relational-atts", stringArray)) {
            this.enableNot(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        }
        if (Utils.getFlag("only-multiinstance", stringArray)) {
            this.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        }
        if ((string = Utils.getOption("superclass", stringArray)).length() == 0) {
            throw new IllegalArgumentException("A superclass has to be specified!");
        }
        this.m_Superclass = string;
        string = Utils.getOption("packages", stringArray);
        if (string.length() != 0) {
            stringTokenizer = new StringTokenizer(string, ",");
            this.m_Packages = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                this.m_Packages.add(stringTokenizer.nextToken());
            }
        }
        if (!Utils.getFlag("generic", stringArray)) return;
        GenericPropertiesCreator genericPropertiesCreator = new GenericPropertiesCreator();
        genericPropertiesCreator.execute(false);
        Properties properties = genericPropertiesCreator.getInputProperties();
        stringTokenizer = new StringTokenizer(properties.getProperty(this.m_Superclass), ",");
        this.m_Packages = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            this.m_Packages.add(stringTokenizer.nextToken());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-num-instances");
        vector.add("" + this.m_Capabilities.getMinimumNumberInstances());
        if (this.isEnabled(Capabilities.Capability.NO_CLASS)) {
            vector.add("-no-class");
        } else {
            if (this.isEnabled(Capabilities.Capability.UNARY_CLASS)) {
                vector.add("-unary-class");
            }
            if (this.isEnabled(Capabilities.Capability.BINARY_CLASS)) {
                vector.add("-binary-class");
            }
            if (this.isEnabled(Capabilities.Capability.NOMINAL_CLASS)) {
                vector.add("-nominal-class");
            }
            if (this.isEnabled(Capabilities.Capability.NUMERIC_CLASS)) {
                vector.add("-numeric-class");
            }
            if (this.isEnabled(Capabilities.Capability.STRING_CLASS)) {
                vector.add("-string-class");
            }
            if (this.isEnabled(Capabilities.Capability.DATE_CLASS)) {
                vector.add("-date-class");
            }
            if (this.isEnabled(Capabilities.Capability.RELATIONAL_CLASS)) {
                vector.add("-relational-class");
            }
        }
        if (this.isEnabled(Capabilities.Capability.UNARY_ATTRIBUTES)) {
            vector.add("-unary-atts");
        }
        if (this.isEnabled(Capabilities.Capability.BINARY_ATTRIBUTES)) {
            vector.add("-binary-atts");
        }
        if (this.isEnabled(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
            vector.add("-nominal-atts");
        }
        if (this.isEnabled(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            vector.add("-numeric-atts");
        }
        if (this.isEnabled(Capabilities.Capability.STRING_ATTRIBUTES)) {
            vector.add("-string-atts");
        }
        if (this.isEnabled(Capabilities.Capability.DATE_ATTRIBUTES)) {
            vector.add("-date-atts");
        }
        if (this.isEnabled(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
            vector.add("-relational-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.NO_CLASS)) {
            vector.add("-not-no-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.UNARY_CLASS)) {
            vector.add("-not-unary-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.BINARY_CLASS)) {
            vector.add("-not-binary-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.NOMINAL_CLASS)) {
            vector.add("-not-nominal-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.NUMERIC_CLASS)) {
            vector.add("-not-numeric-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.STRING_CLASS)) {
            vector.add("-not-string-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.DATE_CLASS)) {
            vector.add("-not-date-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.RELATIONAL_CLASS)) {
            vector.add("-not-relational-class");
        }
        if (this.isEnabledNot(Capabilities.Capability.UNARY_ATTRIBUTES)) {
            vector.add("-not-unary-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.BINARY_ATTRIBUTES)) {
            vector.add("-not-binary-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
            vector.add("-not-nominal-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            vector.add("-not-numeric-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.STRING_ATTRIBUTES)) {
            vector.add("-not-string-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.DATE_ATTRIBUTES)) {
            vector.add("-not-date-atts");
        }
        if (this.isEnabledNot(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
            vector.add("-not-relational-atts");
        }
        if (this.isEnabled(Capabilities.Capability.ONLY_MULTIINSTANCE)) {
            vector.add("-only-multi-instance");
        }
        if (this.getHandler() != null) {
            vector.add("-W");
            vector.add(this.getHandler().getClass().getName());
            if (this.getHandler() instanceof OptionHandler) {
                vector.add("--");
                String[] stringArray = ((OptionHandler)((Object)this.getHandler())).getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
            }
        } else if (this.getFilename().length() != 0) {
            vector.add("-t");
            vector.add(this.getFilename());
            vector.add("-c");
            vector.add(this.m_ClassIndex.getSingleIndex());
        }
        if (this.m_Superclass.length() != 0) {
            vector.add("-superclass");
            vector.add(this.m_Superclass);
        } else {
            vector.add("-packages");
            vector.add(this.m_Packages.toString().replaceAll("\\[", "").replaceAll("\\]", ""));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setHandler(CapabilitiesHandler capabilitiesHandler) {
        this.m_Handler = capabilitiesHandler;
        this.setCapabilities(this.m_Handler.getCapabilities());
    }

    public CapabilitiesHandler getHandler() {
        return this.m_Handler;
    }

    public void setFilename(String string) {
        this.m_Filename = string;
        if (this.m_Filename.length() != 0) {
            try {
                Instances instances = new Instances(new BufferedReader(new FileReader(this.m_Filename)));
                this.m_ClassIndex.setUpper(instances.numAttributes());
                instances.setClassIndex(Integer.parseInt(this.getClassIndex()) - 1);
                this.setCapabilities(Capabilities.forInstances(instances));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public void setClassIndex(String string) {
        this.m_ClassIndex = string.equals("-1") ? null : new SingleIndex(string);
    }

    public String getClassIndex() {
        if (this.m_ClassIndex == null) {
            return "-1";
        }
        return "" + this.m_ClassIndex.getIndex();
    }

    public void enable(Capabilities.Capability capability) {
        this.m_Capabilities.enable(capability);
    }

    public boolean isEnabled(Capabilities.Capability capability) {
        return this.m_Capabilities.handles(capability);
    }

    public void disable(Capabilities.Capability capability) {
        this.m_Capabilities.disable(capability);
    }

    public void enableNot(Capabilities.Capability capability) {
        this.m_NotCapabilities.enable(capability);
    }

    public boolean isEnabledNot(Capabilities.Capability capability) {
        return this.m_NotCapabilities.handles(capability);
    }

    public void disableNot(Capabilities.Capability capability) {
        this.m_NotCapabilities.disable(capability);
    }

    public boolean handles(Capabilities.Capability capability) {
        return this.m_Capabilities.handles(capability);
    }

    public Capabilities getCapabilities() {
        return this.m_Capabilities;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.m_Capabilities = (Capabilities)capabilities.clone();
    }

    public Capabilities getNotCapabilities() {
        return this.m_NotCapabilities;
    }

    public void setNotCapabilities(Capabilities capabilities) {
        this.m_NotCapabilities = (Capabilities)capabilities.clone();
    }

    public Vector getMatches() {
        return this.m_Matches;
    }

    public Vector getMisses() {
        return this.m_Misses;
    }

    public Vector find() {
        this.m_Matches = new Vector();
        this.m_Misses = new Vector();
        Vector vector = ClassDiscovery.find(this.m_Superclass, this.m_Packages.toArray(new String[this.m_Packages.size()]));
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Class<?> clazz = Class.forName((String)vector.get(i));
                Object obj = clazz.newInstance();
                if (clazz == this.getClass() || !(obj instanceof CapabilitiesHandler)) continue;
                CapabilitiesHandler capabilitiesHandler = (CapabilitiesHandler)obj;
                Capabilities capabilities = capabilitiesHandler.getCapabilities();
                boolean bl = true;
                for (Capabilities.Capability capability : Capabilities.Capability.values()) {
                    if (!this.m_Capabilities.handles(capability) || capabilities.handles(capability)) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    this.m_Misses.add(vector.get(i));
                    continue;
                }
                for (Capabilities.Capability capability : Capabilities.Capability.values()) {
                    if (!this.m_NotCapabilities.handles(capability) || !capabilities.handles(capability)) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    this.m_Misses.add(vector.get(i));
                    continue;
                }
                if (capabilities.getMinimumNumberInstances() > this.m_Capabilities.getMinimumNumberInstances()) {
                    this.m_Misses.add(vector.get(i));
                    continue;
                }
                this.m_Matches.add(vector.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_Matches;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            int n;
            FindWithCapabilities findWithCapabilities = new FindWithCapabilities();
            try {
                bl = Utils.getFlag("misses", stringArray);
                findWithCapabilities.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\n\n" + findWithCapabilities.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration enumeration = findWithCapabilities.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            System.out.println("\nSearching for the following Capabilities:");
            System.out.print("- allowed: ");
            Iterator iterator = findWithCapabilities.getCapabilities().capabilities();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                if (!bl2) {
                    System.out.print(", ");
                }
                bl2 = false;
                System.out.print(iterator.next());
            }
            System.out.println();
            System.out.print("- not allowed: ");
            iterator = findWithCapabilities.getNotCapabilities().capabilities();
            bl2 = true;
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (!bl2) {
                        System.out.print(", ");
                    }
                    bl2 = false;
                    System.out.print(iterator.next());
                }
                System.out.println();
            } else {
                System.out.println("-");
            }
            findWithCapabilities.find();
            Vector vector = findWithCapabilities.getMatches();
            if (vector.size() == 1) {
                System.out.println("\nFound " + vector.size() + " class that matched the criteria:\n");
            } else {
                System.out.println("\nFound " + vector.size() + " classes that matched the criteria:\n");
            }
            for (n = 0; n < vector.size(); ++n) {
                System.out.println(vector.get(n));
            }
            if (bl) {
                vector = findWithCapabilities.getMisses();
                if (vector.size() == 1) {
                    System.out.println("\nFound " + vector.size() + " class that didn't match the criteria:\n");
                } else {
                    System.out.println("\nFound " + vector.size() + " classes that didn't match the criteria:\n");
                }
                for (n = 0; n < vector.size(); ++n) {
                    System.out.println(vector.get(n));
                }
            }
            System.out.println();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

