/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MakeIndicator
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 766001176862773163L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private Range m_ValIndex = new Range("last");
    private boolean m_Numeric = true;

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        this.m_ValIndex.setUpper(instances.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instances.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instances.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(instance2 = (Instance)instance.copy()).isMissing(this.m_AttIndex.getIndex())) {
            if (this.m_ValIndex.isInRange((int)instance2.value(this.m_AttIndex.getIndex()))) {
                instance2.setValue(this.m_AttIndex.getIndex(), 1.0);
            } else {
                instance2.setValue(this.m_AttIndex.getIndex(), 0.0);
            }
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSets the attribute index.", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSpecify the list of values to indicate. First and last are\n\tvalid indexes (default last)", "V", 1, "-V <index1,index2-index4,...>"));
        vector.addElement(new Option("\tSet if new boolean attribute nominal.", "N", 0, "-N <index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        String string2 = Utils.getOption('V', stringArray);
        if (string2.length() != 0) {
            this.setValueIndices(string2);
        } else {
            this.setValueIndices("last");
        }
        this.setNumeric(!Utils.getFlag('N', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        stringArray[n++] = "-V";
        stringArray[n++] = this.getValueIndices();
        if (!this.getNumeric()) {
            stringArray[n++] = "-N";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that creates a new dataset with a boolean attribute replacing a nominal attribute.  In the new dataset, a value of 1 is assigned to an instance that exhibits a particular range of attribute values, a 0 to an instance that doesn't. The boolean attribute is coded as numeric by default.";
    }

    public String attributeIndexTipText() {
        return "Sets which attribute should be replaced by the indicator. This attribute must be nominal.";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public Range getValueRange() {
        return this.m_ValIndex;
    }

    public String valueIndicesTipText() {
        return "Specify range of nominal values to act on. This is a comma separated list of attribute indices (numbered from 1), with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getValueIndices() {
        return this.m_ValIndex.getRanges();
    }

    public void setValueIndices(String string) {
        this.m_ValIndex.setRanges(string);
    }

    public void setValueIndex(int n) {
        this.setValueIndices("" + (n + 1));
    }

    public void setValueIndicesArray(int[] nArray) {
        this.setValueIndices(Range.indicesToRangeList(nArray));
    }

    public String numericTipText() {
        return "Determines whether the output indicator attribute is numeric. If this is set to false, the output attribute will be nominal.";
    }

    public void setNumeric(boolean bl) {
        this.m_Numeric = bl;
    }

    public boolean getNumeric() {
        return this.m_Numeric;
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i != this.m_AttIndex.getIndex()) {
                fastVector.addElement(attribute);
                continue;
            }
            if (this.m_Numeric) {
                fastVector.addElement(new Attribute(attribute.name()));
                continue;
            }
            int[] nArray = this.m_ValIndex.getSelection();
            String string = nArray.length == 1 ? attribute.value(nArray[0]) : this.m_ValIndex.getRanges().replace(',', '_');
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement("neg_" + string);
            fastVector2.addElement("pos_" + string);
            fastVector.addElement(new Attribute(attribute.name(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    public static void main(String[] stringArray) {
        MakeIndicator.runFilter(new MakeIndicator(), stringArray);
    }
}

