/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.core.Utils;

public class AttributeSummaryPanel
extends JPanel {
    static final long serialVersionUID = -5434987925737735880L;
    protected static final String NO_SOURCE = "None";
    protected JLabel m_AttributeNameLab = new JLabel("None");
    protected JLabel m_AttributeTypeLab = new JLabel("None");
    protected JLabel m_MissingLab = new JLabel("None");
    protected JLabel m_UniqueLab = new JLabel("None");
    protected JLabel m_DistinctLab = new JLabel("None");
    protected JTable m_StatsTable = new JTable(){
        private static final long serialVersionUID = 7165142874670048578L;

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    protected Instances m_Instances;
    protected AttributeStats[] m_AttributeStats;

    public AttributeSummaryPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Name:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.m_AttributeNameLab, gridBagConstraints);
        jPanel.add(this.m_AttributeNameLab);
        this.m_AttributeNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        jLabel = new JLabel("Type:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_AttributeTypeLab, gridBagConstraints);
        jPanel.add(this.m_AttributeTypeLab);
        this.m_AttributeTypeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        jLabel = new JLabel("Missing:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_MissingLab, gridBagConstraints);
        jPanel.add(this.m_MissingLab);
        this.m_MissingLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        jLabel = new JLabel("Distinct:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_DistinctLab, gridBagConstraints);
        jPanel.add(this.m_DistinctLab);
        this.m_DistinctLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        jLabel = new JLabel("Unique:", 4);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 100.0;
        gridBagLayout.setConstraints(this.m_UniqueLab, gridBagConstraints);
        jPanel.add(this.m_UniqueLab);
        this.m_UniqueLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_StatsTable), "Center");
        this.m_StatsTable.getSelectionModel().setSelectionMode(0);
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_AttributeStats = new AttributeStats[instances.numAttributes()];
        this.m_AttributeNameLab.setText(NO_SOURCE);
        this.m_AttributeTypeLab.setText(NO_SOURCE);
        this.m_MissingLab.setText(NO_SOURCE);
        this.m_UniqueLab.setText(NO_SOURCE);
        this.m_DistinctLab.setText(NO_SOURCE);
        this.m_StatsTable.setModel(new DefaultTableModel());
    }

    public void setAttribute(final int n) {
        this.setHeader(n);
        if (this.m_AttributeStats[n] == null) {
            Thread thread = new Thread(){

                public void run() {
                    AttributeSummaryPanel.this.m_AttributeStats[n] = AttributeSummaryPanel.this.m_Instances.attributeStats(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AttributeSummaryPanel.this.setDerived(n);
                            AttributeSummaryPanel.this.m_StatsTable.sizeColumnsToFit(-1);
                            AttributeSummaryPanel.this.m_StatsTable.revalidate();
                            AttributeSummaryPanel.this.m_StatsTable.repaint();
                        }
                    });
                }
            };
            thread.setPriority(1);
            thread.start();
        } else {
            this.setDerived(n);
        }
    }

    protected void setDerived(int n) {
        AttributeStats attributeStats = this.m_AttributeStats[n];
        long l = Math.round(100.0 * (double)attributeStats.missingCount / (double)attributeStats.totalCount);
        this.m_MissingLab.setText("" + attributeStats.missingCount + " (" + l + "%)");
        l = Math.round(100.0 * (double)attributeStats.uniqueCount / (double)attributeStats.totalCount);
        this.m_UniqueLab.setText("" + attributeStats.uniqueCount + " (" + l + "%)");
        this.m_DistinctLab.setText("" + attributeStats.distinctCount);
        this.setTable(attributeStats, n);
    }

    protected void setTable(AttributeStats attributeStats, int n) {
        if (attributeStats.nominalCounts != null) {
            Attribute attribute = this.m_Instances.attribute(n);
            Object[] objectArray = new Object[]{"No.", "Label", "Count"};
            Object[][] objectArray2 = new Object[attributeStats.nominalCounts.length][3];
            for (int i = 0; i < attributeStats.nominalCounts.length; ++i) {
                objectArray2[i][0] = new Integer(i + 1);
                objectArray2[i][1] = attribute.value(i);
                objectArray2[i][2] = new Integer(attributeStats.nominalCounts[i]);
            }
            this.m_StatsTable.setModel(new DefaultTableModel(objectArray2, objectArray));
            this.m_StatsTable.getColumnModel().getColumn(0).setMaxWidth(60);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(4);
            this.m_StatsTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        } else if (attributeStats.numericStats != null) {
            Object[] objectArray = new Object[]{"Statistic", "Value"};
            Object[][] objectArray3 = new Object[4][2];
            objectArray3[0][0] = "Minimum";
            objectArray3[0][1] = Utils.doubleToString(attributeStats.numericStats.min, 3);
            objectArray3[1][0] = "Maximum";
            objectArray3[1][1] = Utils.doubleToString(attributeStats.numericStats.max, 3);
            objectArray3[2][0] = "Mean";
            objectArray3[2][1] = Utils.doubleToString(attributeStats.numericStats.mean, 3);
            objectArray3[3][0] = "StdDev";
            objectArray3[3][1] = Utils.doubleToString(attributeStats.numericStats.stdDev, 3);
            this.m_StatsTable.setModel(new DefaultTableModel(objectArray3, objectArray));
        } else {
            this.m_StatsTable.setModel(new DefaultTableModel());
        }
        this.m_StatsTable.getColumnModel().setColumnMargin(4);
    }

    protected void setHeader(int n) {
        Attribute attribute = this.m_Instances.attribute(n);
        this.m_AttributeNameLab.setText(attribute.name());
        switch (attribute.type()) {
            case 1: {
                this.m_AttributeTypeLab.setText("Nominal");
                break;
            }
            case 0: {
                this.m_AttributeTypeLab.setText("Numeric");
                break;
            }
            case 2: {
                this.m_AttributeTypeLab.setText("String");
                break;
            }
            case 3: {
                this.m_AttributeTypeLab.setText("Date");
                break;
            }
            case 4: {
                this.m_AttributeTypeLab.setText("Relational");
                break;
            }
            default: {
                this.m_AttributeTypeLab.setText("Unknown");
            }
        }
        this.m_MissingLab.setText("...");
        this.m_UniqueLab.setText("...");
        this.m_DistinctLab.setText("...");
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Attribute Panel");
            jFrame.getContentPane().setLayout(new BorderLayout());
            final AttributeSummaryPanel attributeSummaryPanel = new AttributeSummaryPanel();
            attributeSummaryPanel.setBorder(BorderFactory.createTitledBorder("Attribute"));
            jFrame.getContentPane().add((Component)attributeSummaryPanel, "Center");
            final JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.setEnabled(false);
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    attributeSummaryPanel.setAttribute(jComboBox.getSelectedIndex());
                }
            });
            jFrame.getContentPane().add(jComboBox, "North");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                attributeSummaryPanel.setInstances(instances);
                attributeSummaryPanel.setAttribute(0);
                String[] stringArray2 = new String[instances.numAttributes()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = instances.attribute(i).name();
                }
                jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray2));
                jComboBox.setEnabled(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

