/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class NumericCleaner
extends SimpleStreamFilter {
    private static final long serialVersionUID = -352890679895066592L;
    protected double m_MinThreshold = -1.7976931348623157E308;
    protected double m_MinDefault = -1.7976931348623157E308;
    protected double m_MaxThreshold = Double.MAX_VALUE;
    protected double m_MaxDefault = Double.MAX_VALUE;
    protected double m_CloseTo = 0.0;
    protected double m_CloseToDefault = 0.0;
    protected double m_CloseToTolerance = 1.0E-6;
    protected Range m_Cols = new Range("first-last");
    protected boolean m_IncludeClass = false;
    protected int m_Decimals = -1;

    public String globalInfo() {
        return "A filter that 'cleanses' the numeric data from values that are too small, too big or very close to a certain value (e.g., 0) and sets these values to a pre-defined default.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe minimum threshold. (default -Double.MAX_VALUE)", "min", 1, "-min <double>"));
        vector.addElement(new Option("\tThe replacement for values smaller than the minimum threshold.\n\t(default -Double.MAX_VALUE)", "min-default", 1, "-min-default <double>"));
        vector.addElement(new Option("\tThe maximum threshold. (default Double.MAX_VALUE)", "max", 1, "-max <double>"));
        vector.addElement(new Option("\tThe replacement for values larger than the maximum threshold.\n\t(default Double.MAX_VALUE)", "max-default", 1, "-max-default <double>"));
        vector.addElement(new Option("\tThe number values are checked for closeness. (default 0)", "closeto", 1, "-closeto <double>"));
        vector.addElement(new Option("\tThe replacement for values that are close to '-closeto'.\n\t(default 0)", "closeto-default", 1, "-closeto-default <double>"));
        vector.addElement(new Option("\tThe tolerance below which numbers are considered being close to \n\tto each other. (default 1E-6)", "closeto-tolerance", 1, "-closeto-tolerance <double>"));
        vector.addElement(new Option("\tThe number of decimals to round to, -1 means no rounding at all.\n\t(default -1)", "decimals", 1, "-decimals <int>"));
        vector.addElement(new Option("\tThe list of columns to cleanse, e.g., first-last or first-3,5-last.\n\t(default first-last)", "R", 1, "-R <col1,col2,...>"));
        vector.addElement(new Option("\tInverts the matching sense.", "V", 0, "-V"));
        vector.addElement(new Option("\tWhether to include the class in the cleansing.\n\tThe class column will always be skipped, if this flag is not\n\tpresent. (default no)", "include-class", 0, "-include-class"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-min");
        vector.add("" + this.m_MinThreshold);
        vector.add("-min-default");
        vector.add("" + this.m_MinDefault);
        vector.add("-max");
        vector.add("" + this.m_MaxThreshold);
        vector.add("-max-default");
        vector.add("" + this.m_MaxDefault);
        vector.add("-closeto");
        vector.add("" + this.m_CloseTo);
        vector.add("-closeto-default");
        vector.add("" + this.m_CloseToDefault);
        vector.add("-closeto-tolerance");
        vector.add("" + this.m_CloseToTolerance);
        vector.add("-R");
        vector.add("" + this.m_Cols.getRanges());
        if (this.m_Cols.getInvert()) {
            vector.add("-V");
        }
        if (this.m_IncludeClass) {
            vector.add("-include-class");
        }
        vector.add("-decimals");
        vector.add("" + this.getDecimals());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption("min", stringArray);
        if (string.length() != 0) {
            this.setMinThreshold(Double.parseDouble(string));
        } else {
            this.setMinThreshold(-1.7976931348623157E308);
        }
        string = Utils.getOption("min-default", stringArray);
        if (string.length() != 0) {
            this.setMinDefault(Double.parseDouble(string));
        } else {
            this.setMinDefault(-1.7976931348623157E308);
        }
        string = Utils.getOption("max", stringArray);
        if (string.length() != 0) {
            this.setMaxThreshold(Double.parseDouble(string));
        } else {
            this.setMaxThreshold(Double.MAX_VALUE);
        }
        string = Utils.getOption("max-default", stringArray);
        if (string.length() != 0) {
            this.setMaxDefault(Double.parseDouble(string));
        } else {
            this.setMaxDefault(Double.MAX_VALUE);
        }
        string = Utils.getOption("closeto", stringArray);
        if (string.length() != 0) {
            this.setCloseTo(Double.parseDouble(string));
        } else {
            this.setCloseTo(0.0);
        }
        string = Utils.getOption("closeto-default", stringArray);
        if (string.length() != 0) {
            this.setCloseToDefault(Double.parseDouble(string));
        } else {
            this.setCloseToDefault(0.0);
        }
        string = Utils.getOption("closeto-tolerance", stringArray);
        if (string.length() != 0) {
            this.setCloseToTolerance(Double.parseDouble(string));
        } else {
            this.setCloseToTolerance(1.0E-6);
        }
        string = Utils.getOption("R", stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag("V", stringArray));
        this.setIncludeClass(Utils.getFlag("include-class", stringArray));
        string = Utils.getOption("decimals", stringArray);
        if (string.length() != 0) {
            this.setDecimals(Integer.parseInt(string));
        } else {
            this.setDecimals(-1);
        }
        super.setOptions(stringArray);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        this.m_Cols.setUpper(instances.numAttributes() - 1);
        return new Instances(instances);
    }

    protected Instance process(Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        double d = this.m_Decimals > -1 ? StrictMath.pow(10.0, this.m_Decimals) : 1.0;
        for (int i = 0; i < instance2.numAttributes(); ++i) {
            if (!instance2.attribute(i).isNumeric() || !this.m_Cols.isInRange(i) || instance2.classIndex() == i && !this.m_IncludeClass) continue;
            if (instance2.value(i) < this.m_MinThreshold) {
                if (this.getDebug()) {
                    System.out.println("Too small: " + instance2.value(i) + " -> " + this.m_MinDefault);
                }
                instance2.setValue(i, this.m_MinDefault);
            } else if (instance2.value(i) > this.m_MaxThreshold) {
                if (this.getDebug()) {
                    System.out.println("Too big: " + instance2.value(i) + " -> " + this.m_MaxDefault);
                }
                instance2.setValue(i, this.m_MaxDefault);
            } else if (instance2.value(i) - this.m_CloseTo < this.m_CloseToTolerance && this.m_CloseTo - instance2.value(i) < this.m_CloseToTolerance && instance2.value(i) != this.m_CloseTo) {
                if (this.getDebug()) {
                    System.out.println("Too close: " + instance2.value(i) + " -> " + this.m_CloseToDefault);
                }
                instance2.setValue(i, this.m_CloseToDefault);
            }
            if (this.m_Decimals <= -1) continue;
            double d2 = instance2.value(i);
            d2 = (double)StrictMath.round(d2 * d) / d;
            instance2.setValue(i, d2);
        }
        return instance2;
    }

    public String minThresholdTipText() {
        return "The minimum threshold below values are replaced by a default.";
    }

    public double getMinThreshold() {
        return this.m_MinThreshold;
    }

    public void setMinThreshold(double d) {
        this.m_MinThreshold = d;
    }

    public String minDefaultTipText() {
        return "The default value to replace values that are below the minimum threshold.";
    }

    public double getMinDefault() {
        return this.m_MinDefault;
    }

    public void setMinDefault(double d) {
        this.m_MinDefault = d;
    }

    public String maxThresholdTipText() {
        return "The maximum threshold above values are replaced by a default.";
    }

    public double getMaxThreshold() {
        return this.m_MaxThreshold;
    }

    public void setMaxThreshold(double d) {
        this.m_MaxThreshold = d;
    }

    public String maxDefaultTipText() {
        return "The default value to replace values that are above the maximum threshold.";
    }

    public double getMaxDefault() {
        return this.m_MaxDefault;
    }

    public void setMaxDefault(double d) {
        this.m_MaxDefault = d;
    }

    public String closeToTipText() {
        return "The number values are checked for whether they are too close to and get replaced by a default.";
    }

    public double getCloseTo() {
        return this.m_CloseTo;
    }

    public void setCloseTo(double d) {
        this.m_CloseTo = d;
    }

    public String closeToDefaultTipText() {
        return "The default value to replace values with that are too close.";
    }

    public double getCloseToDefault() {
        return this.m_CloseToDefault;
    }

    public void setCloseToDefault(double d) {
        this.m_CloseToDefault = d;
    }

    public String closeToToleranceTipText() {
        return "The value below which values are considered close to.";
    }

    public double getCloseToTolerance() {
        return this.m_CloseToTolerance;
    }

    public void setCloseToTolerance(double d) {
        this.m_CloseToTolerance = d;
    }

    public String attributeIndicesTipText() {
        return "The selection of columns to use in the cleansing processs, first and last are valid indices.";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_Cols.setRanges(string);
    }

    public String invertSelectionTipText() {
        return "If enabled the selection of the columns is inverted.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Cols.setInvert(bl);
    }

    public String includeClassTipText() {
        return "If disabled, the class attribute will be always left out of the cleaning process.";
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    public void setIncludeClass(boolean bl) {
        this.m_IncludeClass = bl;
    }

    public String decimalsTipText() {
        return "The number of decimals to round to, -1 means no rounding at all.";
    }

    public int getDecimals() {
        return this.m_Decimals;
    }

    public void setDecimals(int n) {
        this.m_Decimals = n;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        NumericCleaner.runFilter(new NumericCleaner(), stringArray);
    }
}

