/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.Impurity;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class YongSplitInfo
implements Cloneable,
Serializable,
SplitEvaluate,
RevisionHandler {
    private static final long serialVersionUID = 1864267581079767881L;
    private int number;
    private int first;
    private int last;
    private int position;
    private double maxImpurity;
    private double leftAve;
    private double rightAve;
    private int splitAttr;
    private double splitValue;

    public YongSplitInfo(int n, int n2, int n3) {
        this.number = n2 - n + 1;
        this.first = n;
        this.last = n2;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = n3;
        this.splitValue = 0.0;
        Utils.SMALL = 1.0E-10;
    }

    public final SplitEvaluate copy() throws Exception {
        YongSplitInfo yongSplitInfo = (YongSplitInfo)this.clone();
        return yongSplitInfo;
    }

    public final void initialize(int n, int n2, int n3) {
        this.number = n2 - n + 1;
        this.first = n;
        this.last = n2;
        this.position = -1;
        this.maxImpurity = -1.0E20;
        this.splitAttr = n3;
        this.splitValue = 0.0;
    }

    public final String toString(Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Print SplitInfo:\n");
        stringBuffer.append("    Instances:\t\t" + this.number + " (" + this.first + "-" + this.position + "," + (this.position + 1) + "-" + this.last + ")\n");
        stringBuffer.append("    Maximum Impurity Reduction:\t" + Utils.doubleToString(this.maxImpurity, 1, 4) + "\n");
        stringBuffer.append("    Left average:\t" + this.leftAve + "\n");
        stringBuffer.append("    Right average:\t" + this.rightAve + "\n");
        if (this.maxImpurity > 0.0) {
            stringBuffer.append("    Splitting function:\t" + instances.attribute(this.splitAttr).name() + " = " + this.splitValue + "\n");
        } else {
            stringBuffer.append("    Splitting function:\tnull\n");
        }
        return stringBuffer.toString();
    }

    public final void attrSplit(int n, Instances instances) throws Exception {
        int n2 = 0;
        int n3 = instances.numInstances() - 1;
        this.initialize(n2, n3, n);
        if (this.number < 4) {
            return;
        }
        int n4 = n3 - n2 + 1 < 5 ? 1 : (n3 - n2 + 1) / 5;
        this.position = n2;
        int n5 = n2 + n4 - 1;
        Impurity impurity = new Impurity(n5, n, instances, 5);
        int n6 = 0;
        for (int i = n2 + n4; i <= n3 - n4 - 1; ++i) {
            impurity.incremental(instances.instance(i).classValue(), 1);
            if (Utils.eq(instances.instance(i + 1).value(n), instances.instance(i).value(n))) continue;
            n6 = i;
            if (!(impurity.impurity > this.maxImpurity)) continue;
            this.maxImpurity = impurity.impurity;
            this.splitValue = (instances.instance(i).value(n) + instances.instance(i + 1).value(n)) * 0.5;
            this.leftAve = impurity.sl / impurity.nl;
            this.rightAve = impurity.sr / impurity.nr;
            this.position = i;
        }
    }

    public double maxImpurity() {
        return this.maxImpurity;
    }

    public int splitAttr() {
        return this.splitAttr;
    }

    public int position() {
        return this.position;
    }

    public double splitValue() {
        return this.splitValue;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

