/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CitationKNN
extends Classifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8435377743874094852L;
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected int m_IdIndex;
    protected boolean m_Debug;
    protected int[] m_Classes;
    protected Instances m_Attributes;
    protected int m_NumReferences = 1;
    protected int m_NumCiters = 1;
    protected Instances m_TrainBags;
    protected boolean m_CNNDebug = false;
    protected boolean m_CitersDebug = false;
    protected boolean m_ReferencesDebug = false;
    protected boolean m_HDistanceDebug = false;
    protected boolean m_NeighborListDebug = false;
    protected NeighborList[] m_CNN;
    protected int[] m_Citers;
    protected int[] m_References;
    protected int m_HDRank = 1;
    private double[] m_Diffs;
    private double[] m_Min;
    private double m_MinNorm = 0.95;
    private double[] m_Max;
    private double m_MaxNorm = 1.05;

    public String globalInfo() {
        return "Modified version of the Citation kNN multi instance classifier.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Jun Wang and Zucker and Jean-Daniel");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Solving Multiple-Instance Problem: A Lazy Learning Approach");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "17th International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "Pat Langley");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "1119-1125");
        return technicalInformation;
    }

    public void preprocessData() {
        for (int i = 0; i < this.m_Attributes.numAttributes(); ++i) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < this.m_TrainBags.numInstances(); ++j) {
                Instances instances = this.m_TrainBags.instance(j).relationalValue(1);
                for (int k = 0; k < instances.numInstances(); ++k) {
                    Instance instance = instances.instance(k);
                    if (instance.value(i) < d) {
                        d = instance.value(i);
                    }
                    if (!(instance.value(i) > d2)) continue;
                    d2 = instance.value(i);
                }
            }
            this.m_Min[i] = d * this.m_MinNorm;
            this.m_Max[i] = d2 * this.m_MaxNorm;
            this.m_Diffs[i] = d2 * this.m_MaxNorm - d * this.m_MinNorm;
        }
    }

    public String HDRankTipText() {
        return "The rank associated to the Hausdorff distance.";
    }

    public void setHDRank(int n) {
        this.m_HDRank = n;
    }

    public int getHDRank() {
        return this.m_HDRank;
    }

    public String numReferencesTipText() {
        return "The number of references considered to estimate the class prediction of tests bags.";
    }

    public void setNumReferences(int n) {
        this.m_NumReferences = n;
    }

    public int getNumReferences() {
        return this.m_NumReferences;
    }

    public String numCitersTipText() {
        return "The number of citers considered to estimate the class prediction of test bags.";
    }

    public void setNumCiters(int n) {
        this.m_NumCiters = n;
    }

    public int getNumCiters() {
        return this.m_NumCiters;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_TrainBags = instances;
        this.m_ClassIndex = instances.classIndex();
        this.m_IdIndex = 0;
        this.m_NumClasses = instances.numClasses();
        this.m_Classes = new int[instances.numInstances()];
        this.m_Attributes = instances.instance(0).relationalValue(1).stringFreeStructure();
        this.m_Citers = new int[instances.numClasses()];
        this.m_References = new int[instances.numClasses()];
        this.m_Diffs = new double[this.m_Attributes.numAttributes()];
        this.m_Min = new double[this.m_Attributes.numAttributes()];
        this.m_Max = new double[this.m_Attributes.numAttributes()];
        this.preprocessData();
        this.buildCNN();
        if (this.m_CNNDebug) {
            System.out.println("########################################### ");
            System.out.println("###########CITATION######################## ");
            System.out.println("########################################### ");
            for (int i = 0; i < this.m_CNN.length; ++i) {
                System.out.println("Bag: " + i);
                this.m_CNN[i].printReducedList();
            }
        }
    }

    public void buildCNN() throws Exception {
        int n = 0;
        if (this.m_NumCiters >= this.m_TrainBags.numInstances() || this.m_NumCiters < 0) {
            throw new Exception("Number of citers is out of the range [0, numInstances)");
        }
        n = this.m_NumCiters;
        this.m_CNN = new NeighborList[this.m_TrainBags.numInstances()];
        for (int i = 0; i < this.m_TrainBags.numInstances(); ++i) {
            NeighborList neighborList;
            Instance instance = this.m_TrainBags.instance(i);
            this.m_CNN[i] = neighborList = this.findNeighbors(instance, n, this.m_TrainBags);
        }
    }

    public void countBagCiters(Instance instance) {
        int n;
        for (int i = 0; i < this.m_TrainBags.numClasses(); ++i) {
            this.m_Citers[i] = 0;
        }
        if (this.m_CitersDebug) {
            System.out.println("-------CITERS--------");
        }
        boolean bl = false;
        double d = 0.0;
        for (n = 0; n < this.m_TrainBags.numInstances(); ++n) {
            int n2;
            d = this.distanceSet(instance, this.m_TrainBags.instance(n));
            if (this.m_CitersDebug) {
                System.out.print("bag - bag(" + n + "): " + d);
                System.out.println("   <" + this.m_TrainBags.instance(n).classValue() + ">");
            }
            NeighborList neighborList = this.m_CNN[n];
            NeighborNode neighborNode = neighborList.mFirst;
            while (neighborNode != null && !bl) {
                if (this.m_CitersDebug) {
                    System.out.println("\t\tciter Distance: " + neighborNode.mDistance);
                }
                if (neighborNode.mDistance < d) {
                    neighborNode = neighborNode.mNext;
                    continue;
                }
                bl = true;
                if (!this.m_CitersDebug) continue;
                System.out.println("\t***");
            }
            if (!bl) continue;
            bl = false;
            int n3 = n2 = (int)this.m_TrainBags.instance(n).classValue();
            this.m_Citers[n3] = this.m_Citers[n3] + 1;
        }
        if (this.m_CitersDebug) {
            for (n = 0; n < this.m_Citers.length; ++n) {
                System.out.println("[" + n + "]: " + this.m_Citers[n]);
            }
        }
    }

    public void countBagReferences(Instance instance) {
        int n;
        int n2 = 0;
        int n3 = 0;
        n3 = this.m_TrainBags.numInstances() < this.m_NumReferences ? this.m_TrainBags.numInstances() - 1 : this.m_NumReferences;
        if (this.m_CitersDebug) {
            System.out.println("-------References (" + n3 + ")--------");
        }
        for (n = 0; n < this.m_References.length; ++n) {
            this.m_References[n] = 0;
        }
        if (n3 > 0) {
            NeighborList neighborList = this.findNeighbors(instance, n3, this.m_TrainBags);
            if (this.m_ReferencesDebug) {
                System.out.println("Bag: " + instance + " Neighbors: ");
                neighborList.printReducedList();
            }
            NeighborNode neighborNode = neighborList.mFirst;
            while (neighborNode != null) {
                int n4 = n2 = (int)neighborNode.mBag.classValue();
                this.m_References[n4] = this.m_References[n4] + 1;
                neighborNode = neighborNode.mNext;
            }
        }
        if (this.m_ReferencesDebug) {
            System.out.println("References:");
            for (n = 0; n < this.m_References.length; ++n) {
                System.out.println("[" + n + "]: " + this.m_References[n]);
            }
        }
    }

    protected NeighborList findNeighbors(Instance instance, int n, Instances instances) {
        int n2 = 0;
        if (n > instances.numInstances()) {
            n = instances.numInstances() - 1;
        }
        NeighborList neighborList = new NeighborList(n);
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instance == instances.instance(i)) continue;
            double d = this.distanceSet(instance, instances.instance(i));
            if (this.m_NeighborListDebug) {
                System.out.println("distance(bag, " + i + "): " + d);
            }
            if (neighborList.isEmpty() || n2 < n || d <= neighborList.mLast.mDistance) {
                neighborList.insertSorted(d, instances.instance(i), i);
            }
            ++n2;
        }
        if (this.m_NeighborListDebug) {
            System.out.println("bag neighbors:");
            neighborList.printReducedList();
        }
        return neighborList;
    }

    public double distanceSet(Instance instance, Instance instance2) {
        int n;
        int n2;
        int n3;
        double[] dArray = new double[instance.relationalValue(1).numInstances()];
        for (n3 = 0; n3 < dArray.length; ++n3) {
            dArray[n3] = Double.MAX_VALUE;
        }
        n3 = this.m_HDRank >= instance.relationalValue(1).numInstances() ? instance.relationalValue(1).numInstances() : (this.m_HDRank < 1 ? 1 : this.m_HDRank);
        if (this.m_HDistanceDebug) {
            System.out.println("-------HAUSDORFF DISTANCE--------");
            System.out.println("rank: " + n3 + "\nset of instances:");
            System.out.println("\tset 1:");
            for (n2 = 0; n2 < instance.relationalValue(1).numInstances(); ++n2) {
                System.out.println(instance.relationalValue(1).instance(n2));
            }
            System.out.println("\n\tset 2:");
            for (n2 = 0; n2 < instance2.relationalValue(1).numInstances(); ++n2) {
                System.out.println(instance2.relationalValue(1).instance(n2));
            }
            System.out.println("\n");
        }
        for (n2 = 0; n2 < instance.relationalValue(1).numInstances(); ++n2) {
            if (this.m_HDistanceDebug) {
                System.out.println("\nDistances:");
            }
            for (n = 0; n < instance2.relationalValue(1).numInstances(); ++n) {
                double d = this.distance(instance.relationalValue(1).instance(n2), instance2.relationalValue(1).instance(n));
                if (d < dArray[n2]) {
                    dArray[n2] = d;
                }
                if (!this.m_HDistanceDebug) continue;
                System.out.println("\tdist(" + n2 + ", " + n + "): " + d + "  --> h_f[" + n2 + "]: " + dArray[n2]);
            }
        }
        int[] nArray = Utils.stableSort(dArray);
        if (this.m_HDistanceDebug) {
            System.out.println("\nRanks:\n");
            for (n = 0; n < nArray.length; ++n) {
                System.out.println("\trank " + (n + 1) + ": " + dArray[nArray[n]]);
            }
            System.out.println("\n\t\t>>>>> rank " + n3 + ": " + dArray[nArray[n3 - 1]] + " <<<<<");
        }
        return dArray[nArray[n3 - 1]];
    }

    public double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        for (int i = 0; i < this.m_Attributes.numAttributes(); ++i) {
            double d2 = (instance.value(i) - this.m_Min[i]) / this.m_Diffs[i] - (instance2.value(i) - this.m_Min[i]) / this.m_Diffs[i];
            d += d2 * d2;
        }
        d = Math.sqrt(d);
        return d;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_TrainBags.numInstances() == 0) {
            throw new Exception("No training bags!");
        }
        this.updateNormalization(instance);
        this.countBagReferences(instance);
        this.countBagCiters(instance);
        return this.makeDistribution();
    }

    public void updateNormalization(Instance instance) {
        for (int i = 0; i < this.m_TrainBags.attribute(1).relation().numAttributes(); ++i) {
            double d = this.m_Min[i] / this.m_MinNorm;
            double d2 = this.m_Max[i] / this.m_MaxNorm;
            Instances instances = instance.relationalValue(1);
            for (int j = 0; j < instances.numInstances(); ++j) {
                Instance instance2 = instances.instance(j);
                if (instance2.value(i) < d) {
                    d = instance2.value(i);
                }
                if (!(instance2.value(i) > d2)) continue;
                d2 = instance2.value(i);
            }
            this.m_Min[i] = d * this.m_MinNorm;
            this.m_Max[i] = d2 * this.m_MaxNorm;
            this.m_Diffs[i] = d2 * this.m_MaxNorm - d * this.m_MinNorm;
        }
    }

    public boolean equalExemplars(Instance instance, Instance instance2) {
        if (instance.relationalValue(1).numInstances() == instance2.relationalValue(1).numInstances()) {
            Instances instances = instance.relationalValue(1);
            Instances instances2 = instance2.relationalValue(1);
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance3 = instances.instance(i);
                Instance instance4 = instances2.instance(i);
                for (int j = 0; j < instance3.numAttributes(); ++j) {
                    if (instance3.value(j) == instance4.value(j)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected double[] makeDistribution() throws Exception {
        int n;
        double d = 0.0;
        double[] dArray = new double[this.m_TrainBags.numClasses()];
        boolean bl = false;
        d = (double)this.m_TrainBags.numClasses() / (double)Math.max(1, this.m_TrainBags.numInstances());
        for (n = 0; n < this.m_TrainBags.numClasses(); ++n) {
            dArray[n] = 1.0 / (double)Math.max(1, this.m_TrainBags.numInstances());
            if (!bl) continue;
            System.out.println("distribution[" + n + "]: " + dArray[n]);
        }
        if (bl) {
            System.out.println("total: " + d);
        }
        for (n = 0; n < this.m_TrainBags.numClasses(); ++n) {
            int n2 = n;
            dArray[n2] = dArray[n2] + (double)this.m_References[n];
            int n3 = n;
            dArray[n3] = dArray[n3] + (double)this.m_Citers[n];
        }
        d = 0.0;
        for (n = 0; n < this.m_TrainBags.numClasses(); ++n) {
            d += dArray[n];
            if (!bl) continue;
            System.out.println("distribution[" + n + "]: " + dArray[n]);
        }
        for (n = 0; n < this.m_TrainBags.numClasses(); ++n) {
            dArray[n] = dArray[n] / d;
            if (!bl) continue;
            System.out.println("distribution[" + n + "]: " + dArray[n]);
        }
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tNumber of Nearest References (default 1)", "R", 0, "-R <number of references>"));
        vector.addElement(new Option("\tNumber of Nearest Citers (default 1)", "C", 0, "-C <number of citers>"));
        vector.addElement(new Option("\tRank of the Hausdorff Distance (default 1)", "H", 0, "-H <rank>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setNumReferences(Integer.parseInt(string));
        } else {
            this.setNumReferences(1);
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setNumCiters(Integer.parseInt(string));
        } else {
            this.setNumCiters(1);
        }
        string = Utils.getOption('H', stringArray);
        if (string.length() != 0) {
            this.setHDRank(Integer.parseInt(string));
        } else {
            this.setHDRank(1);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        vector.add("-R");
        vector.add("" + this.getNumReferences());
        vector.add("-C");
        vector.add("" + this.getNumCiters());
        vector.add("-H");
        vector.add("" + this.getHDRank());
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
        stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
        if (this.m_Citers == null) {
            stringBuffer.append("no model built yet!\n");
        } else {
            int n;
            stringBuffer.append("Citers....: " + Utils.arrayToString(this.m_Citers) + "\n");
            stringBuffer.append("References: " + Utils.arrayToString(this.m_References) + "\n");
            stringBuffer.append("Min.......: ");
            for (n = 0; n < this.m_Min.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Utils.doubleToString(this.m_Min[n], 3));
            }
            stringBuffer.append("\n");
            stringBuffer.append("Max.......: ");
            for (n = 0; n < this.m_Max.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Utils.doubleToString(this.m_Max[n], 3));
            }
            stringBuffer.append("\n");
            stringBuffer.append("Diffs.....: ");
            for (n = 0; n < this.m_Diffs.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(Utils.doubleToString(this.m_Diffs[n], 3));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5527 $");
    }

    public static void main(String[] stringArray) {
        CitationKNN.runClassifier(new CitationKNN(), stringArray);
    }

    private class NeighborList
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 3432555644456217394L;
        private NeighborNode mFirst;
        private NeighborNode mLast;
        private int mLength = 1;

        public NeighborList(int n) {
            this.mLength = n;
        }

        public boolean isEmpty() {
            return this.mFirst == null;
        }

        public int currentLength() {
            int n = 0;
            NeighborNode neighborNode = this.mFirst;
            while (neighborNode != null) {
                ++n;
                neighborNode = neighborNode.mNext;
            }
            return n;
        }

        public void insertSorted(double d, Instance instance, int n) {
            if (this.isEmpty()) {
                this.mFirst = this.mLast = new NeighborNode(d, instance, n);
            } else {
                NeighborNode neighborNode = this.mFirst;
                if (d < this.mFirst.mDistance) {
                    this.mFirst = new NeighborNode(d, instance, n, this.mFirst);
                } else {
                    while (neighborNode.mNext != null && neighborNode.mNext.mDistance < d) {
                        neighborNode = neighborNode.mNext;
                    }
                    neighborNode.mNext = new NeighborNode(d, instance, n, neighborNode.mNext);
                    if (neighborNode.equals(this.mLast)) {
                        this.mLast = neighborNode.mNext;
                    }
                }
                int n2 = 0;
                neighborNode = this.mFirst;
                while (neighborNode.mNext != null) {
                    if (++n2 >= this.mLength && neighborNode.mDistance != neighborNode.mNext.mDistance) {
                        this.mLast = neighborNode;
                        neighborNode.mNext = null;
                        break;
                    }
                    neighborNode = neighborNode.mNext;
                }
            }
        }

        public void pruneToK(int n) {
            if (this.isEmpty()) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            int n2 = 0;
            double d = this.mFirst.mDistance;
            NeighborNode neighborNode = this.mFirst;
            while (neighborNode.mNext != null) {
                d = neighborNode.mDistance;
                if (++n2 >= n && d != neighborNode.mNext.mDistance) {
                    this.mLast = neighborNode;
                    neighborNode.mNext = null;
                    break;
                }
                neighborNode = neighborNode.mNext;
            }
        }

        public void printList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode neighborNode = this.mFirst;
                while (neighborNode != null) {
                    System.out.print("Node: instance " + neighborNode.mBagPosition + "\n");
                    System.out.println(neighborNode.mBag);
                    System.out.println(", distance " + neighborNode.mDistance);
                    neighborNode = neighborNode.mNext;
                }
                System.out.println();
            }
        }

        public void printReducedList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode neighborNode = this.mFirst;
                while (neighborNode != null) {
                    System.out.print("Node: bag " + neighborNode.mBagPosition + "  (" + neighborNode.mBag.relationalValue(1).numInstances() + "): ");
                    System.out.print("   <" + neighborNode.mBag.classValue() + ">");
                    System.out.println("  (d: " + neighborNode.mDistance + ")");
                    neighborNode = neighborNode.mNext;
                }
                System.out.println();
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5527 $");
        }
    }

    private class NeighborNode
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -3947320761906511289L;
        private Instance mBag;
        private double mDistance;
        private NeighborNode mNext;
        private int mBagPosition;

        public NeighborNode(double d, Instance instance, int n, NeighborNode neighborNode) {
            this.mDistance = d;
            this.mBag = instance;
            this.mNext = neighborNode;
            this.mBagPosition = n;
        }

        public NeighborNode(double d, Instance instance, int n) {
            this(d, instance, n, null);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5527 $");
        }
    }
}

