/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.core.matrix.SingularValueDecomposition;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LatentSemanticAnalysis
extends UnsupervisedAttributeEvaluator
implements AttributeTransformer,
OptionHandler {
    static final long serialVersionUID = -8712112988018106198L;
    private Instances m_trainInstances;
    private Instances m_trainHeader;
    private Instances m_transformedFormat;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttributes;
    private int m_numInstances;
    private boolean m_transpose = false;
    private Matrix m_u = null;
    private Matrix m_s = null;
    private Matrix m_v = null;
    private Matrix m_transformationMatrix = null;
    private ReplaceMissingValues m_replaceMissingFilter;
    private Normalize m_normalizeFilter;
    private NominalToBinary m_nominalToBinaryFilter;
    private Remove m_attributeFilter;
    private int m_outputNumAttributes = -1;
    private boolean m_normalize = false;
    private double m_rank = 0.95;
    private double m_sumSquaredSingularValues = 0.0;
    private int m_actualRank = -1;
    private int m_maxAttributesInName = 5;

    public String globalInfo() {
        return "Performs latent semantic analysis and transformation of the data. Use in conjunction with a Ranker search. A low-rank approximation of the full data is found by either specifying the number of singular values to use or specifying a proportion of the singular values to cover.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tNormalize input data.", "N", 0, "-N"));
        vector.addElement(new Option("\tRank approximation used in LSA. \n\tMay be actual number of LSA attributes \n\tto include (if greater than 1) or a \n\tproportion of total singular values to \n\taccount for (if between 0 and 1). \n\tA value less than or equal to zero means \n\tuse all latent variables.(default = 0.95)", "R", 1, "-R"));
        vector.addElement(new Option("\tMaximum number of attributes to include\n\tin transformed attribute names.\n\t(-1 = include all)", "A", 1, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            double d = Double.valueOf(string);
            this.setRank(d);
        }
        if ((string = Utils.getOption('A', stringArray)).length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(string));
        }
        this.setNormalize(Utils.getFlag('N', stringArray));
    }

    private void resetOptions() {
        this.m_rank = 0.95;
        this.m_normalize = true;
        this.m_maxAttributesInName = 5;
    }

    public String normalizeTipText() {
        return "Normalize input data.";
    }

    public void setNormalize(boolean bl) {
        this.m_normalize = bl;
    }

    public boolean getNormalize() {
        return this.m_normalize;
    }

    public String rankTipText() {
        return "Matrix rank to use for data reduction. Can be a proportion to indicate desired coverage";
    }

    public void setRank(double d) {
        this.m_rank = d;
    }

    public double getRank() {
        return this.m_rank;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int n) {
        this.m_maxAttributesInName = n;
    }

    public int getMaximumAttributeNames() {
        return this.m_maxAttributesInName;
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        if (this.getNormalize()) {
            stringArray[n++] = "-N";
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getRank();
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.getMaximumAttributeNames();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.buildAttributeConstructor(instances);
    }

    private void buildAttributeConstructor(Instances instances) throws Exception {
        int n;
        this.m_transpose = false;
        this.m_s = null;
        this.m_u = null;
        this.m_v = null;
        this.m_outputNumAttributes = -1;
        this.m_actualRank = -1;
        this.m_sumSquaredSingularValues = 0.0;
        this.m_trainInstances = new Instances(instances);
        this.m_trainHeader = null;
        this.m_attributeFilter = null;
        this.m_nominalToBinaryFilter = null;
        this.m_replaceMissingFilter = new ReplaceMissingValues();
        this.m_replaceMissingFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_replaceMissingFilter);
        Vector<Integer> vector = new Vector<Integer>();
        if (this.m_trainInstances.classIndex() >= 0) {
            this.m_trainHeader = new Instances(this.m_trainInstances);
            this.m_hasClass = true;
            this.m_classIndex = this.m_trainInstances.classIndex();
            vector.addElement(new Integer(this.m_classIndex));
        }
        if (this.m_normalize) {
            this.m_normalizeFilter = new Normalize();
            this.m_normalizeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_normalizeFilter);
        }
        this.m_nominalToBinaryFilter = new NominalToBinary();
        this.m_nominalToBinaryFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_nominalToBinaryFilter);
        for (int i = 0; i < this.m_trainInstances.numAttributes(); ++i) {
            if (this.m_trainInstances.numDistinctValues(i) > 1) continue;
            vector.addElement(new Integer(i));
        }
        if (vector.size() > 0) {
            this.m_attributeFilter = new Remove();
            int[] nArray = new int[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                nArray[n] = (Integer)vector.elementAt(n);
            }
            this.m_attributeFilter.setAttributeIndicesArray(nArray);
            this.m_attributeFilter.setInvertSelection(false);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_attributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_trainInstances);
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numAttributes = this.m_trainInstances.numAttributes();
        double[][] dArray = new double[this.m_numAttributes][this.m_numInstances];
        for (n = 0; n < this.m_numAttributes; ++n) {
            dArray[n] = this.m_trainInstances.attributeToDoubleArray(n);
        }
        Matrix matrix = new Matrix(dArray);
        if (this.m_numAttributes < this.m_numInstances) {
            this.m_transpose = true;
            matrix = matrix.transpose();
        }
        SingularValueDecomposition singularValueDecomposition = matrix.svd();
        this.m_u = singularValueDecomposition.getU();
        this.m_s = singularValueDecomposition.getS();
        this.m_v = singularValueDecomposition.getV();
        int n2 = singularValueDecomposition.rank();
        for (int i = 0; i < this.m_s.getRowDimension(); ++i) {
            this.m_sumSquaredSingularValues += this.m_s.get(i, i) * this.m_s.get(i, i);
        }
        if (n2 == 0) {
            this.m_s = null;
            this.m_u = null;
            this.m_v = null;
            this.m_sumSquaredSingularValues = 0.0;
            throw new Exception("SVD computation produced no non-zero singular values.");
        }
        if (this.m_rank > (double)n2 || this.m_rank <= 0.0) {
            this.m_actualRank = n2;
        } else if (this.m_rank < 1.0) {
            double d = 0.0;
            for (int i = 0; i < this.m_s.getRowDimension() && this.m_actualRank == -1; ++i) {
                if (!((d += this.m_s.get(i, i) * this.m_s.get(i, i)) / this.m_sumSquaredSingularValues >= this.m_rank)) continue;
                this.m_actualRank = i + 1;
            }
        } else {
            this.m_actualRank = (int)this.m_rank;
        }
        if (this.m_transpose) {
            Matrix matrix2 = this.m_u;
            this.m_u = this.m_v;
            this.m_v = matrix2;
        }
        this.m_u = this.m_u.getMatrix(0, this.m_u.getRowDimension() - 1, 0, this.m_actualRank - 1);
        this.m_s = this.m_s.getMatrix(0, this.m_actualRank - 1, 0, this.m_actualRank - 1);
        this.m_v = this.m_v.getMatrix(0, this.m_v.getRowDimension() - 1, 0, this.m_actualRank - 1);
        this.m_transformationMatrix = this.m_u.times(this.m_s.inverse());
        this.m_transformedFormat = this.setOutputFormat();
    }

    private Instances setOutputFormat() {
        if (this.m_s == null) {
            return null;
        }
        this.m_outputNumAttributes = this.m_hasClass ? this.m_actualRank + 1 : this.m_actualRank;
        int n = this.m_maxAttributesInName;
        if (n <= 0 || n >= this.m_numAttributes) {
            n = this.m_numAttributes;
        }
        FastVector fastVector = new FastVector(this.m_outputNumAttributes);
        for (int i = 0; i < this.m_actualRank; ++i) {
            String string = "";
            double[] dArray = this.m_transformationMatrix.getMatrix(0, this.m_numAttributes - 1, i, i).getColumnPackedCopy();
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    string = string + "+";
                }
                string = string + Utils.doubleToString(dArray[j], 5, 3);
                string = string + this.m_trainInstances.attribute(j).name();
            }
            if (n < this.m_numAttributes) {
                string = string + "...";
            }
            fastVector.addElement(new Attribute(string));
        }
        if (this.m_hasClass) {
            fastVector.addElement(this.m_trainHeader.classAttribute().copy());
        }
        Instances instances = new Instances(this.m_trainInstances.relationName() + "_LSA", fastVector, 0);
        this.m_outputNumAttributes = instances.numAttributes();
        if (this.m_hasClass) {
            instances.setClassIndex(this.m_outputNumAttributes - 1);
        }
        return instances;
    }

    public Instances transformedHeader() throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been successfully performed.");
        }
        return this.m_transformedFormat;
    }

    public Instances transformedData(Instances instances) throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been built yet");
        }
        Instances instances2 = new Instances(this.m_transformedFormat, this.m_numInstances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double[] dArray = new double[this.m_outputNumAttributes];
            for (int j = 0; j < this.m_actualRank; ++j) {
                dArray[j] = this.m_v.get(i, j);
            }
            if (this.m_hasClass) {
                dArray[this.m_outputNumAttributes - 1] = instance.classValue();
            }
            Instance instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
            instances2.add(instance2);
        }
        return instances2;
    }

    public double evaluateAttribute(int n) throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been successfully performed yet!");
        }
        return this.m_s.get(n, n) * this.m_s.get(n, n) / this.m_sumSquaredSingularValues;
    }

    public Instance convertInstance(Instance instance) throws Exception {
        if (this.m_s == null) {
            throw new Exception("convertInstance: Latent Semantic Analysis not performed yet.");
        }
        double[] dArray = new double[this.m_outputNumAttributes];
        Instance instance2 = (Instance)instance.copy();
        if (!instance.dataset().equalHeaders(this.m_trainHeader)) {
            throw new Exception("Can't convert instance: headers don't match: LatentSemanticAnalysis");
        }
        this.m_replaceMissingFilter.input(instance2);
        this.m_replaceMissingFilter.batchFinished();
        instance2 = this.m_replaceMissingFilter.output();
        if (this.m_normalize) {
            this.m_normalizeFilter.input(instance2);
            this.m_normalizeFilter.batchFinished();
            instance2 = this.m_normalizeFilter.output();
        }
        this.m_nominalToBinaryFilter.input(instance2);
        this.m_nominalToBinaryFilter.batchFinished();
        instance2 = this.m_nominalToBinaryFilter.output();
        if (this.m_attributeFilter != null) {
            this.m_attributeFilter.input(instance2);
            this.m_attributeFilter.batchFinished();
            instance2 = this.m_attributeFilter.output();
        }
        if (this.m_hasClass) {
            dArray[this.m_outputNumAttributes - 1] = instance.classValue();
        }
        double[][] dArray2 = new double[1][this.m_numAttributes];
        dArray2[0] = instance2.toDoubleArray();
        Matrix matrix = new Matrix(dArray2);
        matrix = matrix.times(this.m_transformationMatrix);
        for (int i = 0; i < this.m_actualRank; ++i) {
            dArray[i] = matrix.get(0, i);
        }
        if (instance instanceof SparseInstance) {
            return new SparseInstance(instance.weight(), dArray);
        }
        return new Instance(instance.weight(), dArray);
    }

    public String toString() {
        if (this.m_s == null) {
            return "Latent Semantic Analysis hasn't been built yet!";
        }
        return "\tLatent Semantic Analysis Attribute Transformer\n\n" + this.lsaSummary();
    }

    private String lsaSummary() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of latent variables utilized: " + this.m_actualRank);
        stringBuffer.append("\n\nSingularValue\tLatentVariable#\n");
        for (n2 = 0; n2 < this.m_actualRank; ++n2) {
            stringBuffer.append(Utils.doubleToString(this.m_s.get(n2, n2), 9, 5) + "\t" + (n2 + 1) + "\n");
        }
        stringBuffer.append("\nAttribute vectors (left singular vectors) -- row vectors show\nthe relation between the original attributes and the latent \nvariables computed by the singular value decomposition:\n");
        for (n2 = 0; n2 < this.m_actualRank; ++n2) {
            stringBuffer.append("LatentVariable#" + (n2 + 1) + "\t");
        }
        stringBuffer.append("AttributeName\n");
        for (n2 = 0; n2 < this.m_u.getRowDimension(); ++n2) {
            for (n = 0; n < this.m_u.getColumnDimension(); ++n) {
                stringBuffer.append(Utils.doubleToString(this.m_u.get(n2, n), 9, 5) + "\t\t");
            }
            stringBuffer.append(this.m_trainInstances.attribute(n2).name() + "\n");
        }
        stringBuffer.append("\n\nInstance vectors (right singular vectors) -- column\nvectors show the relation between the original instances and the\nlatent variables computed by the singular value decomposition:\n");
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            stringBuffer.append("Instance#" + (n2 + 1) + "\t");
        }
        stringBuffer.append("LatentVariable#\n");
        for (n2 = 0; n2 < this.m_v.getColumnDimension(); ++n2) {
            for (n = 0; n < this.m_v.getRowDimension(); ++n) {
                stringBuffer.append(Utils.doubleToString(this.m_v.get(n, n2), 9, 5) + "\t");
            }
            stringBuffer.append(n2 + 1 + "\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5511 $");
    }

    public static void main(String[] stringArray) {
        LatentSemanticAnalysis.runEvaluator(new LatentSemanticAnalysis(), stringArray);
    }
}

