/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.filters.unsupervised.attribute.AbstractTimeSeries;

public class TimeSeriesTranslate
extends AbstractTimeSeries {
    static final long serialVersionUID = -8901621509691785705L;

    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the equivalent attribute values of some previous (or future) instance. For instances where the desired value is unknown either the instance may be dropped, or missing values used. Skips the class attribute if it is set.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (instances.classIndex() > 0 && !this.getFillWithMissing()) {
            throw new IllegalArgumentException("TimeSeriesTranslate: Need to fill in missing values using appropriate option when class index is set.");
        }
        super.setInputFormat(instances);
        Instances instances2 = new Instances(instances, 0);
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() || !this.m_SelectedCols.isInRange(i)) continue;
            if (instances2.attribute(i).isNominal() || instances2.attribute(i).isNumeric()) {
                instances2.renameAttribute(i, instances2.attribute(i).name() + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                continue;
            }
            throw new UnsupportedAttributeTypeException("Only numeric and nominal attributes may be  manipulated in time series.");
        }
        instances2.setClassIndex(instances.classIndex());
        this.setOutputFormat(instances2);
        return true;
    }

    protected Instance mergeInstances(Instance instance, Instance instance2) {
        Instances instances = this.outputFormatPeek();
        double[] dArray = new double[instances.numAttributes()];
        for (int i = 0; i < dArray.length; ++i) {
            if (i != instances.classIndex() && this.m_SelectedCols.isInRange(i)) {
                if (instance != null) {
                    dArray[i] = instance.value(i);
                    continue;
                }
                dArray[i] = Instance.missingValue();
                continue;
            }
            dArray[i] = instance2.value(i);
        }
        Instance instance3 = null;
        instance3 = instance2 instanceof SparseInstance ? new SparseInstance(instance2.weight(), dArray) : new Instance(instance2.weight(), dArray);
        instance3.setDataset(instance2.dataset());
        return instance3;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] stringArray) {
        TimeSeriesTranslate.runFilter(new TimeSeriesTranslate(), stringArray);
    }
}

