/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class RegressionByDiscretization
extends SingleClassifierEnhancer {
    static final long serialVersionUID = 5066426153134050378L;
    protected Discretize m_Discretizer = new Discretize();
    protected int m_NumBins = 10;
    protected double[] m_ClassMeans;
    protected boolean m_DeleteEmptyBins;
    protected Instances m_DiscretizedHeader = null;
    protected boolean m_UseEqualFrequency = false;

    public String globalInfo() {
        return "A regression scheme that employs any classifier on a copy of the data that has the class attribute (equal-width) discretized. The predicted value is the expected value of the mean class value for each discretized interval (based on the predicted probabilities for each interval).";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public RegressionByDiscretization() {
        this.m_Classifier = new J48();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.setMinimumNumberInstances(2);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        Object object;
        Object[] objectArray;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Discretizer.setIgnoreClass(true);
        this.m_Discretizer.setAttributeIndices("" + (instances.classIndex() + 1));
        this.m_Discretizer.setBins(this.getNumBins());
        this.m_Discretizer.setUseEqualFrequency(this.getUseEqualFrequency());
        this.m_Discretizer.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.m_Discretizer);
        if (this.m_DeleteEmptyBins) {
            n2 = 0;
            objectArray = new boolean[instances2.numClasses()];
            for (int i = 0; i < instances2.numInstances(); ++i) {
                if (objectArray[(int)instances2.instance(i).classValue()]) continue;
                ++n2;
                objectArray[(int)instances2.instance((int)i).classValue()] = true;
            }
            FastVector fastVector = new FastVector(n2);
            object = new int[instances2.numClasses()];
            for (int i = 0; i < instances2.numClasses(); ++i) {
                if (!objectArray[i]) continue;
                object[i] = fastVector.size();
                fastVector.addElement(instances2.classAttribute().value(i));
            }
            Attribute attribute = new Attribute(instances2.classAttribute().name(), fastVector);
            FastVector fastVector2 = new FastVector(instances2.numAttributes());
            for (int i = 0; i < instances2.numAttributes(); ++i) {
                if (i != instances2.classIndex()) {
                    fastVector2.addElement(instances2.attribute(i).copy());
                    continue;
                }
                fastVector2.addElement(attribute);
            }
            Instances instances3 = new Instances(instances2.relationName(), fastVector2, instances2.numInstances());
            instances3.setClassIndex(instances2.classIndex());
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance = instances2.instance(i);
                instances3.add(instance);
                instances3.lastInstance().setClassValue((double)object[(int)instance.classValue()]);
            }
            instances2 = instances3;
        }
        this.m_DiscretizedHeader = new Instances(instances2, 0);
        n2 = instances2.numClasses();
        this.m_ClassMeans = new double[n2];
        objectArray = new int[n2];
        for (n = 0; n < instances.numInstances(); ++n) {
            int n3;
            object = instances2.instance(n);
            if (((Instance)object).classIsMissing()) continue;
            int n4 = n3 = (int)((Instance)object).classValue();
            objectArray[n4] = objectArray[n4] + 1;
            int n5 = n3;
            this.m_ClassMeans[n5] = this.m_ClassMeans[n5] + instances.instance(n).classValue();
        }
        for (n = 0; n < n2; ++n) {
            if (objectArray[n] <= 0) continue;
            int n6 = n;
            this.m_ClassMeans[n6] = this.m_ClassMeans[n6] / (double)objectArray[n];
        }
        if (this.m_Debug) {
            System.out.println("Bin Means");
            System.out.println("==========");
            for (n = 0; n < this.m_ClassMeans.length; ++n) {
                System.out.println(this.m_ClassMeans[n]);
            }
            System.out.println();
        }
        this.m_Classifier.buildClassifier(instances2);
    }

    public double classifyInstance(Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        instance2.setDataset(this.m_DiscretizedHeader);
        double[] dArray = this.m_Classifier.distributionForInstance(instance2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * this.m_ClassMeans[i];
            d2 += dArray[i];
        }
        return d / d2;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tNumber of bins for equal-width discretization\n\t(default 10).\n", "B", 1, "-B <int>"));
        vector.addElement(new Option("\tWhether to delete empty bins after discretization\n\t(default false).\n", "E", 0, "-E"));
        vector.addElement(new Option("\tUse equal-frequency instead of equal-width discretization.", "F", 0, "-F"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setNumBins(Integer.parseInt(string));
        } else {
            this.setNumBins(10);
        }
        this.setDeleteEmptyBins(Utils.getFlag('E', stringArray));
        this.setUseEqualFrequency(Utils.getFlag('F', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 4];
        int n = 0;
        stringArray2[n++] = "-B";
        stringArray2[n++] = "" + this.getNumBins();
        if (this.getDeleteEmptyBins()) {
            stringArray2[n++] = "-E";
        }
        if (this.getUseEqualFrequency()) {
            stringArray2[n++] = "-F";
        }
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String numBinsTipText() {
        return "Number of bins for discretization.";
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int n) {
        this.m_NumBins = n;
    }

    public String deleteEmptyBinsTipText() {
        return "Whether to delete empty bins after discretization.";
    }

    public boolean getDeleteEmptyBins() {
        return this.m_DeleteEmptyBins;
    }

    public void setDeleteEmptyBins(boolean bl) {
        this.m_DeleteEmptyBins = bl;
    }

    public String useEqualFrequencyTipText() {
        return "If set to true, equal-frequency binning will be used instead of equal-width binning.";
    }

    public boolean getUseEqualFrequency() {
        return this.m_UseEqualFrequency;
    }

    public void setUseEqualFrequency(boolean bl) {
        this.m_UseEqualFrequency = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Regression by discretization");
        if (this.m_ClassMeans == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            stringBuffer.append("\n\nClass attribute discretized into " + this.m_ClassMeans.length + " values\n");
            stringBuffer.append("\nClassifier spec: " + this.getClassifierSpec() + "\n");
            stringBuffer.append(this.m_Classifier.toString());
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4746 $");
    }

    public static void main(String[] stringArray) {
        RegressionByDiscretization.runClassifier(new RegressionByDiscretization(), stringArray);
    }
}

