/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Utils;

public class GenericPropertiesCreator {
    public static final boolean VERBOSE = false;
    public static final String USE_DYNAMIC = "UseDynamic";
    protected static String CREATOR_FILE = "weka/gui/GenericPropertiesCreator.props";
    protected static String EXCLUDE_FILE = "weka/gui/GenericPropertiesCreator.excludes";
    protected static String EXCLUDE_INTERFACE = "I";
    protected static String EXCLUDE_CLASS = "C";
    protected static String EXCLUDE_SUPERCLASS = "S";
    protected static String PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
    protected String m_InputFilename;
    protected String m_OutputFilename;
    protected Properties m_InputProperties;
    protected Properties m_OutputProperties;
    protected boolean m_ExplicitPropsFile;
    protected Hashtable m_Excludes;

    public GenericPropertiesCreator() throws Exception {
        this(CREATOR_FILE);
        this.m_ExplicitPropsFile = false;
    }

    public GenericPropertiesCreator(String string) throws Exception {
        this.m_InputFilename = string;
        this.m_OutputFilename = PROPERTY_FILE;
        this.m_InputProperties = null;
        this.m_OutputProperties = null;
        this.m_ExplicitPropsFile = true;
        this.m_Excludes = new Hashtable();
    }

    public void setExplicitPropsFile(boolean bl) {
        this.m_ExplicitPropsFile = bl;
    }

    public boolean getExplicitPropsFile() {
        return this.m_ExplicitPropsFile;
    }

    public String getOutputFilename() {
        return this.m_OutputFilename;
    }

    public void setOutputFilename(String string) {
        this.m_OutputFilename = string;
    }

    public String getInputFilename() {
        return this.m_InputFilename;
    }

    public void setInputFilename(String string) {
        this.m_InputFilename = string;
        this.setExplicitPropsFile(true);
    }

    public Properties getInputProperties() {
        return this.m_InputProperties;
    }

    public Properties getOutputProperties() {
        return this.m_OutputProperties;
    }

    protected void loadInputProperties() {
        this.m_InputProperties = new Properties();
        try {
            File file = new File(this.getInputFilename());
            if (this.getExplicitPropsFile() && file.exists()) {
                this.m_InputProperties.load(new FileInputStream(this.getInputFilename()));
            } else {
                this.m_InputProperties = Utils.readProperties(this.getInputFilename());
            }
            this.m_Excludes.clear();
            Properties properties = Utils.readProperties(EXCLUDE_FILE);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                Hashtable hashtable = new Hashtable();
                this.m_Excludes.put(string, hashtable);
                hashtable.put(EXCLUDE_INTERFACE, new Vector());
                hashtable.put(EXCLUDE_CLASS, new Vector());
                hashtable.put(EXCLUDE_SUPERCLASS, new Vector());
                StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(string), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    Vector vector = new Vector();
                    if (string2.startsWith(EXCLUDE_INTERFACE + ":")) {
                        vector = (Vector)hashtable.get(EXCLUDE_INTERFACE);
                    } else if (string2.startsWith(EXCLUDE_CLASS + ":")) {
                        vector = (Vector)hashtable.get(EXCLUDE_CLASS);
                    } else if (string2.startsWith(EXCLUDE_SUPERCLASS)) {
                        vector = (Vector)hashtable.get(EXCLUDE_SUPERCLASS);
                    }
                    vector.add(string2.substring(string2.indexOf(":") + 1));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean useDynamic() {
        if (this.getInputProperties() == null) {
            this.loadInputProperties();
        }
        if (!ClassLoader.getSystemClassLoader().equals(this.getClass().getClassLoader())) {
            if (Boolean.parseBoolean(this.getInputProperties().getProperty(USE_DYNAMIC, "true"))) {
                System.out.println("[GenericPropertiesCreator] classloader in use is not the system classloader: using static entries in weka/gui/GenericObjectEditor.props rather than dynamic class discovery.");
            }
            return false;
        }
        return Boolean.parseBoolean(this.getInputProperties().getProperty(USE_DYNAMIC, "true"));
    }

    protected boolean isValidClassname(String string) {
        return string.indexOf("$") == -1;
    }

    protected boolean isValidClassname(String string, String string2) {
        boolean bl = true;
        if (this.m_Excludes.containsKey(string)) {
            Class<?> clazz;
            int n;
            Vector vector;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName(string2);
            }
            catch (Exception exception) {
                clazz2 = null;
            }
            if (clazz2 != null && bl) {
                vector = (Vector)((Hashtable)this.m_Excludes.get(string)).get(EXCLUDE_INTERFACE);
                for (n = 0; n < vector.size(); ++n) {
                    try {
                        clazz = Class.forName(vector.get(n).toString());
                        if (!ClassDiscovery.hasInterface(clazz, clazz2)) continue;
                        bl = false;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (clazz2 != null && bl) {
                vector = (Vector)((Hashtable)this.m_Excludes.get(string)).get(EXCLUDE_SUPERCLASS);
                for (n = 0; n < vector.size(); ++n) {
                    try {
                        clazz = Class.forName(vector.get(n).toString());
                        if (!ClassDiscovery.isSubclass(clazz, clazz2)) continue;
                        bl = false;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (clazz2 != null && bl) {
                vector = (Vector)((Hashtable)this.m_Excludes.get(string)).get(EXCLUDE_CLASS);
                for (n = 0; n < vector.size(); ++n) {
                    try {
                        clazz = Class.forName(vector.get(n).toString());
                        if (!clazz.getName().equals(clazz2.getName())) continue;
                        bl = false;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    protected void generateOutputProperties() throws Exception {
        this.m_OutputProperties = new Properties();
        Enumeration<?> enumeration = this.m_InputProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            Vector vector;
            String string = enumeration.nextElement().toString();
            if (string.equals(USE_DYNAMIC)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(this.m_InputProperties.getProperty(string), ",");
            HashSet hashSet = new HashSet();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    vector = ClassDiscovery.find(Class.forName(string), string2);
                }
                catch (Exception exception) {
                    System.out.println("Problem with '" + string + "': " + exception);
                    vector = new Vector();
                }
                for (n = 0; n < vector.size(); ++n) {
                    if (!this.isValidClassname(vector.get(n).toString()) || !this.isValidClassname(string, vector.get(n).toString())) continue;
                    hashSet.add(vector.get(n));
                }
            }
            String string3 = "";
            vector = new Vector();
            vector.addAll(hashSet);
            Collections.sort(vector, new ClassDiscovery.StringCompare());
            for (n = 0; n < vector.size(); ++n) {
                if (!string3.equals("")) {
                    string3 = string3 + ",";
                }
                string3 = string3 + vector.get(n).toString();
            }
            this.m_OutputProperties.setProperty(string, string3);
        }
    }

    protected void storeOutputProperties() throws Exception {
        this.m_OutputProperties.store(new FileOutputStream(this.getOutputFilename()), " Customises the list of options given by the GenericObjectEditor\n# for various superclasses.");
    }

    public void execute() throws Exception {
        this.execute(true);
    }

    public void execute(boolean bl) throws Exception {
        this.loadInputProperties();
        this.generateOutputProperties();
        if (bl) {
            this.storeOutputProperties();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        GenericPropertiesCreator genericPropertiesCreator = null;
        if (stringArray.length == 0) {
            genericPropertiesCreator = new GenericPropertiesCreator();
        } else if (stringArray.length == 1) {
            genericPropertiesCreator = new GenericPropertiesCreator();
            genericPropertiesCreator.setOutputFilename(stringArray[0]);
        } else if (stringArray.length == 2) {
            genericPropertiesCreator = new GenericPropertiesCreator(stringArray[0]);
            genericPropertiesCreator.setOutputFilename(stringArray[1]);
        } else {
            System.out.println("usage: " + GenericPropertiesCreator.class.getName() + " [<input.props>] [<output.props>]");
            System.exit(1);
        }
        genericPropertiesCreator.execute(true);
    }
}

