/*
 * Decompiled with CFR 0.152.
 */
package weka.core.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import weka.core.RevisionUtils;
import weka.core.logging.ConsoleLogger;
import weka.core.logging.Logger;

public class FileLogger
extends ConsoleLogger {
    protected File m_LogFile;
    protected String m_LineFeed;

    protected void initialize() {
        super.initialize();
        this.m_LogFile = this.getLogFile();
        try {
            if (this.m_LogFile.exists()) {
                this.m_LogFile.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_LineFeed = System.getProperty("line.separator");
    }

    protected File getLogFile() {
        String string = m_Properties.getProperty("LogFile", "%h/weka.log");
        string = string.replaceAll("%t", System.getProperty("java.io.tmpdir"));
        string = string.replaceAll("%h", System.getProperty("user.home"));
        string = string.replaceAll("%c", System.getProperty("user.dir"));
        string = string.replaceAll("%%", System.getProperty("%"));
        File file = new File(string);
        return file;
    }

    protected void append(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.m_LogFile, true));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doLog(Logger.Level level, String string, String string2, String string3, int n) {
        super.doLog(level, string, string2, string3, n);
        this.append(m_DateFormat.format(new Date()) + " " + string2 + " " + string3 + this.m_LineFeed + (Object)((Object)level) + ": " + string + this.m_LineFeed);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4716 $");
    }
}

