/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discretize
extends Expression {
    protected String m_fieldName;
    protected int m_fieldIndex;
    protected boolean m_mapMissingDefined = false;
    protected String m_mapMissingTo;
    protected boolean m_defaultValueDefined = false;
    protected String m_defaultValue;
    protected ArrayList<DiscretizeBin> m_bins = new ArrayList();
    protected Attribute m_outputDef;

    public Discretize(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) throws Exception {
        super(optype, arrayList);
        if (optype == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[Discretize] must have a categorical or ordinal optype");
        }
        this.m_fieldName = element.getAttribute("field");
        this.m_mapMissingTo = element.getAttribute("mapMissingTo");
        if (this.m_mapMissingTo != null && this.m_mapMissingTo.length() > 0) {
            this.m_mapMissingDefined = true;
        }
        this.m_defaultValue = element.getAttribute("defaultValue");
        if (this.m_defaultValue != null && this.m_defaultValue.length() > 0) {
            this.m_defaultValueDefined = true;
        }
        NodeList nodeList = element.getElementsByTagName("DiscretizeBin");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            DiscretizeBin discretizeBin = new DiscretizeBin(element2);
            this.m_bins.add(discretizeBin);
        }
        this.setUpField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        super.setFieldDefs(arrayList);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        Attribute attribute;
        this.m_fieldIndex = -1;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[Discretize] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            attribute = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!attribute.isNumeric()) {
                throw new Exception("[Discretize] reference field " + this.m_fieldName + " must be continuous.");
            }
        }
        attribute = new Attribute("temp", (FastVector)null);
        for (DiscretizeBin discretizeBin : this.m_bins) {
            attribute.addStringValue(discretizeBin.getBinValue());
        }
        if (this.m_defaultValueDefined) {
            attribute.addStringValue(this.m_defaultValue);
        }
        if (this.m_mapMissingDefined) {
            attribute.addStringValue(this.m_mapMissingTo);
        }
        FastVector fastVector = new FastVector();
        for (int i = 0; i < attribute.numValues(); ++i) {
            fastVector.addElement(attribute.value(i));
        }
        this.m_outputDef = new Attribute(this.m_fieldName + "_discretized", fastVector);
    }

    @Override
    protected Attribute getOutputDef() {
        return this.m_outputDef;
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        double d = Instance.missingValue();
        double d2 = dArray[this.m_fieldIndex];
        if (Instance.isMissingValue(d2)) {
            if (this.m_mapMissingDefined) {
                d = this.m_outputDef.indexOfValue(this.m_mapMissingTo);
            }
        } else {
            boolean bl = false;
            for (DiscretizeBin discretizeBin : this.m_bins) {
                if (!discretizeBin.containsValue(d2)) continue;
                bl = true;
                d = this.m_outputDef.indexOfValue(discretizeBin.getBinValue());
                break;
            }
            if (!bl && this.m_defaultValueDefined) {
                d = this.m_outputDef.indexOfValue(this.m_defaultValue);
            }
        }
        return d;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        double d = this.getResult(dArray);
        if (Instance.isMissingValue(d)) {
            return "**Missing Value**";
        }
        return this.m_outputDef.value((int)d);
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "Discretize (" + this.m_fieldName + "):");
        for (DiscretizeBin discretizeBin : this.m_bins) {
            stringBuffer.append("\n" + string + discretizeBin.toString());
        }
        if (this.m_mapMissingDefined) {
            stringBuffer.append("\n" + string + "map missing values to: " + this.m_mapMissingTo);
        }
        if (this.m_defaultValueDefined) {
            stringBuffer.append("\n" + string + "defautl value: " + this.m_defaultValue);
        }
        return stringBuffer.toString();
    }

    protected class DiscretizeBin
    implements Serializable {
        private static final long serialVersionUID = 5810063243316808400L;
        private ArrayList<FieldMetaInfo.Interval> m_intervals = new ArrayList();
        private String m_binValue;

        protected DiscretizeBin(Element element) throws Exception {
            NodeList nodeList = element.getElementsByTagName("Interval");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                FieldMetaInfo.Interval interval = new FieldMetaInfo.Interval((Element)node);
                this.m_intervals.add(interval);
            }
            this.m_binValue = element.getAttribute("binValue");
        }

        protected String getBinValue() {
            return this.m_binValue;
        }

        protected boolean containsValue(double d) {
            boolean bl = false;
            for (FieldMetaInfo.Interval interval : this.m_intervals) {
                if (!interval.containsValue(d)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"" + this.m_binValue + "\" if value in: ");
            boolean bl = true;
            for (FieldMetaInfo.Interval interval : this.m_intervals) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(interval.toString());
            }
            return stringBuffer.toString();
        }
    }
}

