/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.PairedStats;

public final class CorrelationSplitInfo
implements Cloneable,
Serializable,
SplitEvaluate,
RevisionHandler {
    private static final long serialVersionUID = 4212734895125452770L;
    private int m_first;
    private int m_last;
    private int m_position;
    private double m_maxImpurity;
    private int m_splitAttr;
    private double m_splitValue;
    private int m_number;

    public CorrelationSplitInfo(int n, int n2, int n3) {
        this.initialize(n, n2, n3);
    }

    public final SplitEvaluate copy() throws Exception {
        CorrelationSplitInfo correlationSplitInfo = (CorrelationSplitInfo)this.clone();
        return correlationSplitInfo;
    }

    public final void initialize(int n, int n2, int n3) {
        this.m_number = n2 - n + 1;
        this.m_first = n;
        this.m_last = n2;
        this.m_position = -1;
        this.m_maxImpurity = -1.7976931348623157E308;
        this.m_splitAttr = n3;
        this.m_splitValue = 0.0;
    }

    public final void attrSplit(int n, Instances instances) throws Exception {
        int n2;
        int n3 = 0;
        int n4 = instances.numInstances() - 1;
        PairedStats pairedStats = new PairedStats(0.01);
        PairedStats pairedStats2 = new PairedStats(0.01);
        PairedStats pairedStats3 = new PairedStats(0.01);
        int n5 = instances.classIndex();
        double d = 2.0;
        this.initialize(n3, n4, n);
        if (this.m_number < 4) {
            return;
        }
        int n6 = n4 - n3 + 1 < 5 ? 1 : (n4 - n3 + 1) / 5;
        this.m_position = n3;
        int n7 = n3 + n6 - 1;
        for (n2 = n3; n2 < n6; ++n2) {
            pairedStats.add(instances.instance(n2).value(n), instances.instance(n2).value(n5));
            pairedStats2.add(instances.instance(n2).value(n), instances.instance(n2).value(n5));
        }
        for (n2 = n6; n2 < instances.numInstances(); ++n2) {
            pairedStats.add(instances.instance(n2).value(n), instances.instance(n2).value(n5));
            pairedStats3.add(instances.instance(n2).value(n), instances.instance(n2).value(n5));
        }
        pairedStats.calculateDerived();
        double d2 = pairedStats.yStats.stdDev * pairedStats.yStats.stdDev;
        d2 = Math.abs(d2);
        d2 = Math.pow(d2, 1.0 / d);
        for (n2 = n3 + n6; n2 < n4 - n6 - 1; ++n2) {
            pairedStats3.subtract(instances.instance(n2).value(n), instances.instance(n2).value(n5));
            pairedStats2.add(instances.instance(n2).value(n), instances.instance(n2).value(n5));
            if (Utils.eq(instances.instance(n2 + 1).value(n), instances.instance(n2).value(n))) continue;
            pairedStats2.calculateDerived();
            pairedStats3.calculateDerived();
            double d3 = Math.abs(pairedStats2.correlation);
            double d4 = Math.abs(pairedStats3.correlation);
            double d5 = pairedStats2.yStats.stdDev * pairedStats2.yStats.stdDev;
            d5 = Math.abs(d5);
            d5 = Math.pow(d5, 1.0 / d);
            double d6 = pairedStats3.yStats.stdDev * pairedStats3.yStats.stdDev;
            d6 = Math.abs(d6);
            d6 = Math.pow(d6, 1.0 / d);
            double d7 = d2 - pairedStats2.count / pairedStats.count * d5 - pairedStats3.count / pairedStats.count * d6;
            d3 = pairedStats2.count / pairedStats.count * d3;
            d4 = pairedStats3.count / pairedStats.count * d4;
            double d8 = d3 + d4 - Math.abs(pairedStats.correlation);
            if (Utils.eq(d7, 0.0) || !(d7 > this.m_maxImpurity)) continue;
            this.m_maxImpurity = d7;
            this.m_splitValue = (instances.instance(n2).value(n) + instances.instance(n2 + 1).value(n)) * 0.5;
            this.m_position = n2;
        }
    }

    public double maxImpurity() {
        return this.m_maxImpurity;
    }

    public int splitAttr() {
        return this.m_splitAttr;
    }

    public int position() {
        return this.m_position;
    }

    public double splitValue() {
        return this.m_splitValue;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

