/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.Adler32;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.EnsembleSelection;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class EnsembleSelectionLibrary
extends EnsembleLibrary
implements Serializable {
    private static final long serialVersionUID = -6444026512552917835L;
    private File m_workingDirectory;
    private String m_modelListFile = null;
    private Instances[] m_trainingData;
    private Instances[] m_hillclimbData;
    private double[][][] m_predictions;
    private int m_seed;
    private int m_folds;
    private double m_validationRatio;
    private transient PropertyChangeSupport m_workingDirectoryPropertySupport = new PropertyChangeSupport(this);
    public transient boolean m_Debug = true;

    public EnsembleSelectionLibrary() {
        this.m_workingDirectory = new File(EnsembleSelection.getDefaultWorkingDirectory());
    }

    public EnsembleSelectionLibrary(String string, int n, int n2, double d) {
        if (string != null) {
            this.m_workingDirectory = new File(string);
        }
        this.m_seed = n;
        this.m_folds = n2;
        this.m_validationRatio = d;
    }

    public EnsembleSelectionLibrary(String string) {
        File file = new File(string);
        try {
            EnsembleLibrary.loadLibrary(file, (EnsembleLibrary)this);
        }
        catch (Exception exception) {
            System.err.println("Could not load specified library file: " + string);
        }
    }

    public EnsembleSelectionLibrary(InputStream inputStream) {
        try {
            EnsembleLibrary.loadLibrary(inputStream, (EnsembleLibrary)this);
        }
        catch (Exception exception) {
            System.err.println("Could not load library from XML stream: " + exception);
        }
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
        Iterator iterator = this.getModels().iterator();
        while (iterator.hasNext()) {
            ((EnsembleSelectionLibraryModel)iterator.next()).setDebug(this.m_Debug);
        }
    }

    public void setValidationRatio(double d) {
        this.m_validationRatio = d;
    }

    public void setNumFolds(int n) {
        this.m_folds = n;
    }

    public Instances trainAll(Instances instances, String string, int n) throws Exception {
        Object object2;
        int n2;
        int n3;
        Instances instances2;
        this.createWorkingDirectory(string);
        String string2 = EnsembleSelectionLibrary.getDataDirectoryName(instances);
        File file = new File(string, string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm");
        String string3 = simpleDateFormat.format(new Date()) + "_" + this.size() + "_models.mlf";
        File file2 = new File(file.getPath(), string3);
        EnsembleLibrary.saveLibrary(file2, this, null);
        string3 = simpleDateFormat.format(new Date()) + "_" + this.size() + "_models.model.xml";
        file2 = new File(file.getPath(), string3);
        EnsembleLibrary.saveLibrary(file2, this, null);
        String string4 = instances.toString();
        FileWriter fileWriter = new FileWriter(new File(file.getPath(), file.getName() + ".arff"));
        fileWriter.write(string4);
        fileWriter.close();
        this.m_trainingData = new Instances[this.m_folds];
        this.m_hillclimbData = new Instances[this.m_folds];
        if (this.m_folds > 1) {
            instances2 = new Instances(instances, instances.numInstances());
            for (n3 = 0; n3 < this.m_folds; ++n3) {
                this.m_trainingData[n3] = instances.trainCV(this.m_folds, n3);
                this.m_hillclimbData[n3] = instances.testCV(this.m_folds, n3);
            }
            for (n3 = 0; n3 < this.m_folds; ++n3) {
                for (n2 = 0; n2 < this.m_hillclimbData[n3].numInstances(); ++n2) {
                    instances2.add(this.m_hillclimbData[n3].instance(n2));
                }
            }
        } else {
            n3 = (int)((double)instances.numInstances() * this.m_validationRatio);
            this.m_trainingData[0] = new Instances(instances, 0, instances.numInstances() - n3);
            this.m_hillclimbData[0] = new Instances(instances, instances.numInstances() - n3, n3);
            instances2 = this.m_hillclimbData[0];
        }
        Iterator iterator = this.m_Models.iterator();
        n2 = 0;
        this.m_predictions = new double[this.m_Models.size()][instances2.numInstances()][instances.numClasses()];
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            object2 = (EnsembleSelectionLibraryModel)iterator.next();
            ((EnsembleSelectionLibraryModel)object2).setDebug(this.m_Debug);
            ((EnsembleSelectionLibraryModel)object2).setFolds(this.m_folds);
            ((EnsembleSelectionLibraryModel)object2).setSeed(this.m_seed);
            ((EnsembleSelectionLibraryModel)object2).setValidationRatio(this.m_validationRatio);
            ((EnsembleSelectionLibraryModel)object2).setChecksum(EnsembleSelectionLibrary.getInstancesChecksum(instances));
            try {
                ((EnsembleSelectionLibraryModel)object2).createModel(this.m_trainingData, this.m_hillclimbData, file.getPath(), n);
            }
            catch (Exception exception) {
                System.out.println("**Couldn't create model " + ((EnsembleLibraryModel)object2).getStringRepresentation() + " because of following exception: " + exception.getMessage());
                hashSet.add(object2);
                continue;
            }
            if (hashSet.contains(object2)) continue;
            this.m_predictions[n2] = ((EnsembleSelectionLibraryModel)object2).getValidationPredictions();
            ++n2;
            ((EnsembleSelectionLibraryModel)object2).releaseModel();
        }
        for (Object object2 : hashSet) {
            if (this.m_Debug) {
                System.out.println("removing invalid library model: " + ((EnsembleLibraryModel)object2).getStringRepresentation());
            }
            this.m_Models.remove(object2);
        }
        if (this.m_Debug) {
            System.out.println("model index: " + n2 + " tree set size: " + this.m_Models.size());
        }
        if (hashSet.size() > 0) {
            object2 = new double[this.m_Models.size()][][];
            for (int i = 0; i < this.m_Models.size(); ++i) {
                object2[i] = this.m_predictions[i];
            }
            this.m_predictions = (double[][][])object2;
        }
        if (this.m_Debug) {
            System.out.println("Finished remapping models");
        }
        return instances2;
    }

    public void createWorkingDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void removeModel(String string) {
        this.m_Models.remove(string);
    }

    public Set getModelNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = this.m_Models.iterator();
        while (iterator.hasNext()) {
            treeSet.add(((EnsembleLibraryModel)iterator.next()).getStringRepresentation());
        }
        return treeSet;
    }

    public double[][][] getHillclimbPredictions() {
        return this.m_predictions;
    }

    public File getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public void setWorkingDirectory(File file) {
        this.m_workingDirectory = file;
        if (this.m_workingDirectoryPropertySupport != null) {
            this.m_workingDirectoryPropertySupport.firePropertyChange(null, null, null);
        }
    }

    public String getModelListFile() {
        return this.m_modelListFile;
    }

    public void setModelListFile(String string) {
        this.m_modelListFile = string;
    }

    public EnsembleLibraryModel createModel(Classifier classifier) {
        EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = new EnsembleSelectionLibraryModel(classifier);
        ensembleSelectionLibraryModel.setDebug(this.m_Debug);
        return ensembleSelectionLibraryModel;
    }

    public EnsembleLibraryModel createModel(String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = stringArray[0];
        String string3 = string.replaceAll(stringArray[0], "");
        String[] stringArray2 = string3.split("\\s+");
        EnsembleSelectionLibraryModel ensembleSelectionLibraryModel = null;
        try {
            ensembleSelectionLibraryModel = new EnsembleSelectionLibraryModel(Classifier.forName(string2, stringArray2));
            ensembleSelectionLibraryModel.setDebug(this.m_Debug);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ensembleSelectionLibraryModel;
    }

    public static String getInstancesChecksum(Instances instances) {
        String string = null;
        try {
            Adler32 adler32 = new Adler32();
            byte[] byArray = instances.toString().getBytes("UTF8");
            adler32.update(byArray);
            string = Long.toHexString(adler32.getValue());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public static String getDataDirectoryName(Instances instances) {
        String string = null;
        string = new String(instances.numInstances() + "_instances_" + EnsembleSelectionLibrary.getInstancesChecksum(instances));
        return string;
    }

    public void addWorkingDirectoryListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_workingDirectoryPropertySupport != null) {
            this.m_workingDirectoryPropertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

