/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;

public class BMPWriter
extends JComponentWriter {
    protected Color m_Background;

    public BMPWriter() {
    }

    public BMPWriter(JComponent jComponent) {
        super(jComponent);
    }

    public BMPWriter(JComponent jComponent, File file) {
        super(jComponent, file);
    }

    public void initialize() {
        super.initialize();
        this.setScalingEnabled(false);
    }

    public String getDescription() {
        return "BMP-Image";
    }

    public String getExtension() {
        return ".bmp";
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public void setBackground(Color color) {
        this.m_Background = color;
    }

    public void generateOutput() throws Exception {
        BufferedImage bufferedImage = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setPaintMode();
        graphics.setColor(this.getBackground());
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).scale(this.getXScale(), this.getYScale());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().paint(graphics);
        ImageIO.write((RenderedImage)bufferedImage, "bmp", this.getFile());
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild treeBuild = new TreeBuild();
        PlaceNode2 placeNode2 = new PlaceNode2();
        Node node = treeBuild.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, node, (NodePlace)placeNode2);
        treeVisualizer.setSize(800, 600);
        String string = System.getProperty("java.io.tmpdir") + File.separator + "test.bmp";
        System.out.println("outputting to '" + string + "'...");
        BMPWriter.toOutput(new BMPWriter(), treeVisualizer, new File(string));
        System.out.println("done!");
    }
}

