/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.gui.BrowserHelper;
import weka.gui.EnsembleLibraryEditor;
import weka.gui.ExtensionFileFilter;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MemoryUsagePanel;
import weka.gui.SimpleCLI;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class GUIChooser
extends JFrame {
    private static final long serialVersionUID = 9001529425230247914L;
    protected GUIChooser m_Self;
    protected JPanel m_PanelApplications = new JPanel();
    protected Button m_ExplorerBut = new Button("Explorer");
    protected JFrame m_ExplorerFrame;
    protected Button m_ExperimenterBut = new Button("Experimenter");
    protected JFrame m_ExperimenterFrame;
    protected Button m_KnowledgeFlowBut = new Button("KnowledgeFlow");
    protected JFrame m_KnowledgeFlowFrame;
    protected Button m_SimpleBut = new Button("Simple CLI");
    protected SimpleCLI m_SimpleCLI;
    protected JPanel m_PanelTools = new JPanel();
    protected Button m_ArffViewerBut = new Button("ArffViewer");
    protected Vector m_ArffViewers = new Vector();
    protected Button m_SqlViewerBut = new Button("SqlViewer");
    protected JFrame m_SqlViewerFrame;
    protected Button m_EnsembleLibraryBut = new Button("Ensemble Library");
    protected JFrame m_EnsembleLibraryFrame;
    protected JPanel m_PanelVisualization = new JPanel();
    protected Button m_PlotBut = new Button("Plot");
    protected Vector m_Plots = new Vector();
    protected Button m_ROCBut = new Button("ROC");
    protected Vector m_ROCs = new Vector();
    protected Button m_TreeVisualizerBut = new Button("TreeVisualizer");
    protected Vector m_TreeVisualizers = new Vector();
    protected Button m_GraphVisualizerBut = new Button("GraphVisualizer");
    protected Vector m_GraphVisualizers = new Vector();
    protected Button m_BoundaryVisualizerBut = new Button("BoundaryVisualizer");
    protected JFrame m_BoundaryVisualizerFrame;
    protected JPanel m_PanelHelp = new JPanel();
    protected Button m_HomepageBut = new Button("Homepage");
    protected Button m_WekaDocBut = new Button("Online doc");
    protected Button m_WekaWikiBut = new Button("HOWTOs, ...");
    protected Button m_SourceforgeBut = new Button("Sourceforge");
    protected Button m_SystemInfoBut = new Button("SystemInfo");
    protected JFrame m_SystemInfoFrame;
    protected JPanel m_PanelOther = new JPanel();
    protected Button m_LogWindowBut = new Button("Log");
    protected Button m_MemoryUsageBut = new Button("Memory usage");
    protected JFrame m_MemoryUsageFrame;
    protected Button m_ExitBut = new Button("Exit");
    protected static LogWindow m_LogWindow = new LogWindow();
    Image m_weka = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif"));
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    protected Image m_Icon;
    private static GUIChooser m_chooser;
    private static Memory m_Memory;

    public GUIChooser() {
        super("Weka GUI Chooser");
        this.m_Self = this;
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
        this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_FileChooserPlot.setMultiSelectionEnabled(true);
        this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_Icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
        this.setIconImage(this.m_Icon);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        jPanel.add((Component)this.m_PanelApplications, gridBagConstraints);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        jPanel.add((Component)this.m_PanelTools, gridBagConstraints);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 3.0;
        jPanel.add((Component)this.m_PanelVisualization, gridBagConstraints);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 3.0;
        jPanel.add((Component)this.m_PanelHelp, gridBagConstraints);
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.m_PanelOther, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
        this.m_PanelApplications.setBorder(BorderFactory.createTitledBorder("Applications"));
        this.m_PanelApplications.setLayout(new GridLayout(2, 2));
        this.m_PanelApplications.add(this.m_ExplorerBut);
        this.m_PanelApplications.add(this.m_ExperimenterBut);
        this.m_PanelApplications.add(this.m_KnowledgeFlowBut);
        this.m_PanelApplications.add(this.m_SimpleBut);
        this.m_PanelTools.setBorder(BorderFactory.createTitledBorder("Tools"));
        this.m_PanelTools.setLayout(new GridLayout(1, 2));
        this.m_PanelTools.add(this.m_ArffViewerBut);
        this.m_PanelTools.add(this.m_SqlViewerBut);
        this.m_PanelVisualization.setBorder(BorderFactory.createTitledBorder("Visualization"));
        this.m_PanelVisualization.setLayout(new GridLayout(3, 2));
        this.m_PanelVisualization.add(this.m_PlotBut);
        this.m_PanelVisualization.add(this.m_ROCBut);
        this.m_PanelVisualization.add(this.m_TreeVisualizerBut);
        this.m_PanelVisualization.add(this.m_GraphVisualizerBut);
        this.m_PanelVisualization.add(this.m_BoundaryVisualizerBut);
        this.m_PanelVisualization.add(new JLabel(""));
        this.m_PanelHelp.setBorder(BorderFactory.createTitledBorder("Help"));
        this.m_PanelHelp.setLayout(new GridLayout(3, 2));
        this.m_PanelHelp.add(this.m_HomepageBut);
        this.m_PanelHelp.add(this.m_WekaDocBut);
        this.m_PanelHelp.add(this.m_WekaWikiBut);
        this.m_PanelHelp.add(this.m_SourceforgeBut);
        this.m_PanelHelp.add(this.m_SystemInfoBut);
        this.m_PanelHelp.add(new JLabel(""));
        this.m_PanelOther.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelOther.setLayout(new GridLayout(2, 2));
        this.m_PanelOther.add(this.m_LogWindowBut);
        this.m_PanelOther.add(this.m_MemoryUsageBut);
        this.m_PanelOther.add(this.m_ExitBut);
        this.m_PanelOther.add(new JLabel(""));
        JPanel jPanel2 = new JPanel();
        jPanel2.setToolTipText("Weka, a native bird of New Zealand");
        ImageIcon imageIcon = new ImageIcon(this.m_weka);
        JLabel jLabel = new JLabel(imageIcon);
        jPanel2.add(jLabel);
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(8, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.add(new JLabel("Waikato Environment for", 0));
        jPanel3.add(new JLabel("Knowledge Analysis", 0));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel("Version " + Version.VERSION, 0));
        jPanel3.add(new JLabel(""));
        jPanel3.add(new JLabel("(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear(), 0));
        jPanel3.add(new JLabel(Copyright.getOwner(), 0));
        jPanel3.add(new JLabel(Copyright.getAddress(), 0));
        this.getContentPane().add((Component)jPanel3, "North");
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExplorerFrame == null) {
                    GUIChooser.this.m_ExplorerBut.setEnabled(false);
                    GUIChooser.this.m_ExplorerFrame = new JFrame("Weka Explorer");
                    GUIChooser.this.m_ExplorerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExplorerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExplorerFrame.getContentPane().add((Component)new Explorer(), "Center");
                    GUIChooser.this.m_ExplorerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExplorerFrame.dispose();
                            GUIChooser.this.m_ExplorerFrame = null;
                            GUIChooser.this.m_ExplorerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExplorerFrame.pack();
                    GUIChooser.this.m_ExplorerFrame.setSize(800, 600);
                    GUIChooser.this.m_ExplorerFrame.setVisible(true);
                }
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExperimenterFrame == null) {
                    GUIChooser.this.m_ExperimenterBut.setEnabled(false);
                    GUIChooser.this.m_ExperimenterFrame = new JFrame("Weka Experiment Environment");
                    GUIChooser.this.m_ExperimenterFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                    GUIChooser.this.m_ExperimenterFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExperimenterFrame.dispose();
                            GUIChooser.this.m_ExperimenterFrame = null;
                            GUIChooser.this.m_ExperimenterBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExperimenterFrame.pack();
                    GUIChooser.this.m_ExperimenterFrame.setSize(800, 600);
                    GUIChooser.this.m_ExperimenterFrame.setVisible(true);
                }
            }
        });
        KnowledgeFlowApp.addStartupListener(new StartUpListener(){

            public void startUpComplete() {
                if (GUIChooser.this.m_KnowledgeFlowFrame == null) {
                    final KnowledgeFlowApp knowledgeFlowApp = KnowledgeFlowApp.getSingleton();
                    GUIChooser.this.m_KnowledgeFlowBut.setEnabled(false);
                    GUIChooser.this.m_KnowledgeFlowFrame = new JFrame("Weka KnowledgeFlow Environment");
                    GUIChooser.this.m_KnowledgeFlowFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().add((Component)knowledgeFlowApp, "Center");
                    GUIChooser.this.m_KnowledgeFlowFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            knowledgeFlowApp.clearLayout();
                            GUIChooser.this.m_KnowledgeFlowFrame.dispose();
                            GUIChooser.this.m_KnowledgeFlowFrame = null;
                            GUIChooser.this.m_KnowledgeFlowBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_KnowledgeFlowFrame.pack();
                    GUIChooser.this.m_KnowledgeFlowFrame.setSize(900, 600);
                    GUIChooser.this.m_KnowledgeFlowFrame.setVisible(true);
                }
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.startApp();
            }
        });
        this.m_SimpleBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SimpleCLI == null) {
                    GUIChooser.this.m_SimpleBut.setEnabled(false);
                    try {
                        GUIChooser.this.m_SimpleCLI = new SimpleCLI();
                        GUIChooser.this.m_SimpleCLI.setIconImage(GUIChooser.this.m_Icon);
                    }
                    catch (Exception exception) {
                        throw new Error("Couldn't start SimpleCLI!");
                    }
                    GUIChooser.this.m_SimpleCLI.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_SimpleCLI.dispose();
                            GUIChooser.this.m_SimpleCLI = null;
                            GUIChooser.this.m_SimpleBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SimpleCLI.setVisible(true);
                }
            }
        });
        this.m_ArffViewerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ArffViewer arffViewer = new ArffViewer();
                arffViewer.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_ArffViewers.remove(arffViewer);
                        GUIChooser.this.checkExit();
                    }
                });
                arffViewer.setVisible(true);
                GUIChooser.this.m_ArffViewers.add(arffViewer);
            }
        });
        this.m_SqlViewerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SqlViewerFrame == null) {
                    GUIChooser.this.m_SqlViewerBut.setEnabled(false);
                    final SqlViewer sqlViewer = new SqlViewer(null);
                    GUIChooser.this.m_SqlViewerFrame = new JFrame("SqlViewer");
                    GUIChooser.this.m_SqlViewerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().add((Component)sqlViewer, "Center");
                    GUIChooser.this.m_SqlViewerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            sqlViewer.saveSize();
                            GUIChooser.this.m_SqlViewerFrame.dispose();
                            GUIChooser.this.m_SqlViewerFrame = null;
                            GUIChooser.this.m_SqlViewerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SqlViewerFrame.pack();
                    GUIChooser.this.m_SqlViewerFrame.setVisible(true);
                }
            }
        });
        this.m_EnsembleLibraryBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_EnsembleLibraryFrame == null) {
                    GUIChooser.this.m_EnsembleLibraryBut.setEnabled(false);
                    GUIChooser.this.m_EnsembleLibraryFrame = new JFrame("EnsembleLibrary");
                    GUIChooser.this.m_EnsembleLibraryFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_EnsembleLibraryFrame.getContentPane().setLayout(new BorderLayout());
                    EnsembleLibrary ensembleLibrary = new EnsembleLibrary();
                    EnsembleLibraryEditor ensembleLibraryEditor = new EnsembleLibraryEditor();
                    ensembleLibraryEditor.setValue(ensembleLibrary);
                    GUIChooser.this.m_EnsembleLibraryFrame.getContentPane().add(ensembleLibraryEditor.getCustomEditor(), "Center");
                    GUIChooser.this.m_EnsembleLibraryFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_EnsembleLibraryFrame.dispose();
                            GUIChooser.this.m_EnsembleLibraryFrame = null;
                            GUIChooser.this.m_EnsembleLibraryBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_EnsembleLibraryFrame.pack();
                    GUIChooser.this.m_EnsembleLibraryFrame.setSize(800, 600);
                    GUIChooser.this.m_EnsembleLibraryFrame.setVisible(true);
                }
            }
        });
        this.m_PlotBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserPlot.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                VisualizePanel visualizePanel = new VisualizePanel();
                String string = "";
                File[] fileArray = GUIChooser.this.m_FileChooserPlot.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getAbsolutePath();
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + string2;
                    System.err.println("Loading instances from " + string2);
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                        Instances instances = new Instances(bufferedReader);
                        instances.setClassIndex(instances.numAttributes() - 1);
                        PlotData2D plotData2D = new PlotData2D(instances);
                        if (i == 0) {
                            plotData2D.setPlotName("Master plot");
                            visualizePanel.setMasterPlot(plotData2D);
                            continue;
                        }
                        plotData2D.setPlotName("Plot " + (i + 1));
                        plotData2D.m_useCustomColour = true;
                        plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                        visualizePanel.addPlot(plotData2D);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + fileArray[i] + "':\n" + exception.getMessage());
                        return;
                    }
                }
                final JFrame jFrame = new JFrame("Plot - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)visualizePanel, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_Plots.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_Plots.add(jFrame);
            }
        });
        this.m_ROCBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserROC.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                Instances instances = null;
                try {
                    instances = new Instances(new BufferedReader(new FileReader(string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                instances.setClassIndex(instances.numAttributes() - 1);
                ThresholdVisualizePanel thresholdVisualizePanel = new ThresholdVisualizePanel();
                thresholdVisualizePanel.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
                thresholdVisualizePanel.setName(instances.relationName());
                PlotData2D plotData2D = new PlotData2D(instances);
                plotData2D.setPlotName(instances.relationName());
                plotData2D.addInstanceNumberAttribute();
                try {
                    thresholdVisualizePanel.addPlot(plotData2D);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error adding plot:\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("ROC - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)thresholdVisualizePanel, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_ROCs.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_ROCs.add(jFrame);
            }
        });
        this.m_TreeVisualizerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserTreeVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                TreeBuild treeBuild = new TreeBuild();
                Node node = null;
                PlaceNode2 placeNode2 = new PlaceNode2();
                try {
                    node = treeBuild.create(new FileReader(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("TreeVisualizer - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)new TreeVisualizer(null, node, (NodePlace)placeNode2), "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_TreeVisualizers.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_TreeVisualizers.add(jFrame);
            }
        });
        this.m_GraphVisualizerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserGraphVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                GraphVisualizer graphVisualizer = new GraphVisualizer();
                try {
                    if (string.toLowerCase().endsWith(".xml") || string.toLowerCase().endsWith(".bif")) {
                        graphVisualizer.readBIF(new FileInputStream(string));
                    } else {
                        graphVisualizer.readDOT(new FileReader(string));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("GraphVisualizer - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)graphVisualizer, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_GraphVisualizers.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_GraphVisualizers.add(jFrame);
            }
        });
        this.m_BoundaryVisualizerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_BoundaryVisualizerFrame == null) {
                    GUIChooser.this.m_BoundaryVisualizerBut.setEnabled(false);
                    GUIChooser.this.m_BoundaryVisualizerFrame = new JFrame("BoundaryVisualizer");
                    GUIChooser.this.m_BoundaryVisualizerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().add((Component)new BoundaryVisualizer(), "Center");
                    GUIChooser.this.m_BoundaryVisualizerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_BoundaryVisualizerFrame.dispose();
                            GUIChooser.this.m_BoundaryVisualizerFrame = null;
                            GUIChooser.this.m_BoundaryVisualizerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BoundaryVisualizerFrame.pack();
                    GUIChooser.this.m_BoundaryVisualizerFrame.setSize(800, 600);
                    GUIChooser.this.m_BoundaryVisualizerFrame.setVisible(true);
                    BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                }
            }
        });
        this.m_HomepageBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://www.cs.waikato.ac.nz/~ml/weka/");
            }
        });
        this.m_WekaDocBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://weka.sourceforge.net/wekadoc/");
            }
        });
        this.m_WekaWikiBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://weka.sourceforge.net/wiki/");
            }
        });
        this.m_SourceforgeBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://sourceforge.net/projects/weka/");
            }
        });
        this.m_SystemInfoBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SystemInfoFrame == null) {
                    GUIChooser.this.m_SystemInfoBut.setEnabled(false);
                    GUIChooser.this.m_SystemInfoFrame = new JFrame("SystemInfo");
                    GUIChooser.this.m_SystemInfoFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().setLayout(new BorderLayout());
                    Hashtable hashtable = new SystemInfo().getSystemInfo();
                    Vector vector = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        vector.add(enumeration.nextElement());
                    }
                    Collections.sort(vector);
                    Object[][] objectArray = new String[hashtable.size()][2];
                    for (int i = 0; i < vector.size(); ++i) {
                        objectArray[i][0] = vector.get(i).toString();
                        objectArray[i][1] = hashtable.get(objectArray[i][0]).toString();
                    }
                    Object[] objectArray2 = new String[]{"Key", "Value"};
                    JTable jTable = new JTable(objectArray, objectArray2);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().add((Component)new JScrollPane(jTable), "Center");
                    GUIChooser.this.m_SystemInfoFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_SystemInfoFrame.dispose();
                            GUIChooser.this.m_SystemInfoFrame = null;
                            GUIChooser.this.m_SystemInfoBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SystemInfoFrame.pack();
                    GUIChooser.this.m_SystemInfoFrame.setSize(800, 600);
                    GUIChooser.this.m_SystemInfoFrame.setVisible(true);
                }
            }
        });
        m_LogWindow.setIconImage(this.m_Icon);
        this.m_LogWindowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                m_LogWindow.setVisible(true);
            }
        });
        this.m_MemoryUsageBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_MemoryUsageFrame == null) {
                    final MemoryUsagePanel memoryUsagePanel = new MemoryUsagePanel();
                    GUIChooser.this.m_MemoryUsageBut.setEnabled(false);
                    GUIChooser.this.m_MemoryUsageFrame = new JFrame("Memory usage");
                    GUIChooser.this.m_MemoryUsageFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().add((Component)memoryUsagePanel, "Center");
                    GUIChooser.this.m_MemoryUsageFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            memoryUsagePanel.stopMonitoring();
                            GUIChooser.this.m_MemoryUsageFrame.dispose();
                            GUIChooser.this.m_MemoryUsageFrame = null;
                            GUIChooser.this.m_MemoryUsageBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_MemoryUsageFrame.pack();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(400, 50);
                    Point point = memoryUsagePanel.getFrameLocation();
                    if (point.x != -1 && point.y != -1) {
                        GUIChooser.this.m_MemoryUsageFrame.setLocation(point);
                    }
                    GUIChooser.this.m_MemoryUsageFrame.setVisible(true);
                    Dimension dimension = GUIChooser.this.m_MemoryUsageFrame.getPreferredSize();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight()));
                }
            }
        });
        this.m_ExitBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.pack();
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_ExplorerFrame == null && this.m_ExperimenterFrame == null && this.m_KnowledgeFlowFrame == null && this.m_SimpleCLI == null && this.m_ArffViewers.size() == 0 && this.m_SqlViewerFrame == null && this.m_EnsembleLibraryFrame == null && this.m_Plots.size() == 0 && this.m_ROCs.size() == 0 && this.m_TreeVisualizers.size() == 0 && this.m_GraphVisualizers.size() == 0 && this.m_BoundaryVisualizerFrame == null && this.m_SystemInfoFrame == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            m_chooser = new GUIChooser();
            m_chooser.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                23.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_chooser.dispose();
                                if (m_chooser.m_ExperimenterFrame != null) {
                                    m_chooser.m_ExperimenterFrame.dispose();
                                    m_chooser.m_ExperimenterFrame = null;
                                }
                                if (m_chooser.m_ExplorerFrame != null) {
                                    m_chooser.m_ExplorerFrame.dispose();
                                    m_chooser.m_ExplorerFrame = null;
                                }
                                if (m_chooser.m_KnowledgeFlowFrame != null) {
                                    m_chooser.m_KnowledgeFlowFrame.dispose();
                                    m_chooser.m_KnowledgeFlowFrame = null;
                                }
                                if (m_chooser.m_SimpleCLI != null) {
                                    m_chooser.m_SimpleCLI.dispose();
                                    m_chooser.m_SimpleCLI = null;
                                }
                                if (m_chooser.m_ArffViewers.size() > 0) {
                                    for (int i = 0; i < m_chooser.m_ArffViewers.size(); ++i) {
                                        ArffViewer arffViewer = (ArffViewer)m_chooser.m_ArffViewers.get(i);
                                        arffViewer.dispose();
                                    }
                                    m_chooser.m_ArffViewers.clear();
                                }
                                m_chooser = null;
                                System.gc();
                                m_Memory.stopThreads();
                                m_chooser;
                                m_LogWindow.setVisible(true);
                                m_chooser;
                                m_LogWindow.toFront();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting...");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }
}

