/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import weka.classifiers.Classifier;
import weka.classifiers.functions.neural.LinearUnit;
import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralNode;
import weka.classifiers.functions.neural.SigmoidUnit;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;

public class MultilayerPerceptron
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 572250905027665169L;
    private Classifier m_ZeroR;
    private Instances m_instances = null;
    private Instance m_currentInstance = null;
    private boolean m_numeric = false;
    private double[] m_attributeRanges;
    private double[] m_attributeBases;
    private NeuralEnd[] m_outputs = new NeuralEnd[0];
    private NeuralEnd[] m_inputs = new NeuralEnd[0];
    private NeuralConnection[] m_neuralNodes = new NeuralConnection[0];
    private int m_numClasses = 0;
    private int m_numAttributes = 0;
    private NodePanel m_nodePanel = null;
    private ControlPanel m_controlPanel = null;
    private int m_nextId = 0;
    private FastVector m_selected = new FastVector(4);
    private FastVector m_graphers = new FastVector(2);
    private int m_numEpochs = 500;
    private boolean m_stopIt = true;
    private boolean m_stopped = true;
    private boolean m_accepted = false;
    private JFrame m_win;
    private boolean m_autoBuild = true;
    private boolean m_gui = false;
    private int m_valSize = 0;
    private int m_driftThreshold = 20;
    private long m_randomSeed = 0L;
    private Random m_random = null;
    private boolean m_useNomToBin = true;
    private NominalToBinary m_nominalToBinaryFilter = new NominalToBinary();
    private String m_hiddenLayers = "a";
    private boolean m_normalizeAttributes = true;
    private boolean m_decay = false;
    private double m_learningRate = 0.3;
    private double m_momentum = 0.2;
    private int m_epoch = 0;
    private double m_error = 0.0;
    private boolean m_reset = true;
    private boolean m_normalizeClass = true;
    private SigmoidUnit m_sigmoidUnit = new SigmoidUnit();
    private LinearUnit m_linearUnit = new LinearUnit();

    public static void main(String[] stringArray) {
        MultilayerPerceptron.runClassifier(new MultilayerPerceptron(), stringArray);
    }

    public void setDecay(boolean bl) {
        this.m_decay = bl;
    }

    public boolean getDecay() {
        return this.m_decay;
    }

    public void setReset(boolean bl) {
        if (this.m_gui) {
            bl = false;
        }
        this.m_reset = bl;
    }

    public boolean getReset() {
        return this.m_reset;
    }

    public void setNormalizeNumericClass(boolean bl) {
        this.m_normalizeClass = bl;
    }

    public boolean getNormalizeNumericClass() {
        return this.m_normalizeClass;
    }

    public void setNormalizeAttributes(boolean bl) {
        this.m_normalizeAttributes = bl;
    }

    public boolean getNormalizeAttributes() {
        return this.m_normalizeAttributes;
    }

    public void setNominalToBinaryFilter(boolean bl) {
        this.m_useNomToBin = bl;
    }

    public boolean getNominalToBinaryFilter() {
        return this.m_useNomToBin;
    }

    public void setRandomSeed(long l) {
        if (l >= 0L) {
            this.m_randomSeed = l;
        }
    }

    public long getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setValidationThreshold(int n) {
        if (n > 0) {
            this.m_driftThreshold = n;
        }
    }

    public int getValidationThreshold() {
        return this.m_driftThreshold;
    }

    public void setLearningRate(double d) {
        if (d > 0.0 && d <= 1.0) {
            this.m_learningRate = d;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeLearning.setText("" + d);
            }
        }
    }

    public double getLearningRate() {
        return this.m_learningRate;
    }

    public void setMomentum(double d) {
        if (d >= 0.0 && d <= 1.0) {
            this.m_momentum = d;
            if (this.m_controlPanel != null) {
                this.m_controlPanel.m_changeMomentum.setText("" + d);
            }
        }
    }

    public double getMomentum() {
        return this.m_momentum;
    }

    public void setAutoBuild(boolean bl) {
        if (!this.m_gui) {
            bl = true;
        }
        this.m_autoBuild = bl;
    }

    public boolean getAutoBuild() {
        return this.m_autoBuild;
    }

    public void setHiddenLayers(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 0) {
            return;
        }
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("a") || string3.equals("i") || string3.equals("o") || string3.equals("t")) {
                string2 = string2 + string3;
            } else {
                double d = Double.valueOf(string3);
                int n = (int)d;
                if ((double)n == d && (n != 0 || stringTokenizer.countTokens() == 0 && bl) && n >= 0) {
                    string2 = string2 + n;
                } else {
                    return;
                }
            }
            bl = false;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + ", ";
        }
        this.m_hiddenLayers = string2;
    }

    public String getHiddenLayers() {
        return this.m_hiddenLayers;
    }

    public void setGUI(boolean bl) {
        this.m_gui = bl;
        if (!bl) {
            this.setAutoBuild(true);
        } else {
            this.setReset(false);
        }
    }

    public boolean getGUI() {
        return this.m_gui;
    }

    public void setValidationSetSize(int n) {
        if (n < 0 || n > 99) {
            return;
        }
        this.m_valSize = n;
    }

    public int getValidationSetSize() {
        return this.m_valSize;
    }

    public void setTrainingTime(int n) {
        if (n > 0) {
            this.m_numEpochs = n;
        }
    }

    public int getTrainingTime() {
        return this.m_numEpochs;
    }

    private void addNode(NeuralConnection neuralConnection) {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_neuralNodes.length + 1];
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            neuralConnectionArray[i] = this.m_neuralNodes[i];
        }
        neuralConnectionArray[neuralConnectionArray.length - 1] = neuralConnection;
        this.m_neuralNodes = neuralConnectionArray;
    }

    private boolean removeNode(NeuralConnection neuralConnection) {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_neuralNodes.length - 1];
        int n = 0;
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            if (neuralConnection == this.m_neuralNodes[i]) {
                ++n;
                continue;
            }
            if (i - n < neuralConnectionArray.length) {
                neuralConnectionArray[i - n] = this.m_neuralNodes[i];
                continue;
            }
            return false;
        }
        this.m_neuralNodes = neuralConnectionArray;
        return true;
    }

    private Instances setClassType(Instances instances) throws Exception {
        if (instances != null) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            this.m_attributeRanges = new double[instances.numAttributes()];
            this.m_attributeBases = new double[instances.numAttributes()];
            for (int i = 0; i < instances.numAttributes(); ++i) {
                int n;
                d = Double.POSITIVE_INFINITY;
                d2 = Double.NEGATIVE_INFINITY;
                for (n = 0; n < instances.numInstances(); ++n) {
                    if (instances.instance(n).isMissing(i)) continue;
                    double d3 = instances.instance(n).value(i);
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
                this.m_attributeRanges[i] = (d2 - d) / 2.0;
                this.m_attributeBases[i] = (d2 + d) / 2.0;
                if (i == instances.classIndex() || !this.m_normalizeAttributes) continue;
                for (n = 0; n < instances.numInstances(); ++n) {
                    if (this.m_attributeRanges[i] != 0.0) {
                        instances.instance(n).setValue(i, (instances.instance(n).value(i) - this.m_attributeBases[i]) / this.m_attributeRanges[i]);
                        continue;
                    }
                    instances.instance(n).setValue(i, instances.instance(n).value(i) - this.m_attributeBases[i]);
                }
            }
            this.m_numeric = instances.classAttribute().isNumeric();
        }
        return instances;
    }

    public synchronized void blocker(boolean bl) {
        if (bl) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    private void updateDisplay() {
        if (this.m_gui) {
            this.m_controlPanel.m_errorLabel.repaint();
            this.m_controlPanel.m_epochsLabel.repaint();
        }
    }

    private void resetNetwork() {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].reset();
        }
    }

    private void calculateOutputs() {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].outputValue(true);
        }
    }

    private double calculateErrors() throws Exception {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.m_numAttributes; ++n) {
            this.m_inputs[n].errorValue(true);
        }
        for (n = 0; n < this.m_numClasses; ++n) {
            d2 = this.m_outputs[n].errorValue(false);
            d += d2 * d2;
        }
        return d;
    }

    private void updateNetworkWeights(double d, double d2) {
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i].updateWeights(d, d2);
        }
    }

    private void setupInputs() throws Exception {
        this.m_inputs = new NeuralEnd[this.m_numAttributes];
        int n = 0;
        for (int i = 0; i < this.m_numAttributes + 1; ++i) {
            if (this.m_instances.classIndex() != i) {
                this.m_inputs[i - n] = new NeuralEnd(this.m_instances.attribute(i).name());
                this.m_inputs[i - n].setX(0.1);
                this.m_inputs[i - n].setY(((double)(i - n) + 1.0) / (double)(this.m_numAttributes + 1));
                this.m_inputs[i - n].setLink(true, i);
                continue;
            }
            n = 1;
        }
    }

    private void setupOutputs() throws Exception {
        this.m_outputs = new NeuralEnd[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            this.m_outputs[i] = this.m_numeric ? new NeuralEnd(this.m_instances.classAttribute().name()) : new NeuralEnd(this.m_instances.classAttribute().value(i));
            this.m_outputs[i].setX(0.9);
            this.m_outputs[i].setY(((double)i + 1.0) / (double)(this.m_numClasses + 1));
            this.m_outputs[i].setLink(false, i);
            NeuralNode neuralNode = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
            ++this.m_nextId;
            neuralNode.setX(0.75);
            neuralNode.setY(((double)i + 1.0) / (double)(this.m_numClasses + 1));
            this.addNode(neuralNode);
            NeuralConnection.connect(neuralNode, this.m_outputs[i]);
        }
    }

    private void setupHiddenLayer() {
        int n;
        String string;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_hiddenLayers, ",");
        int n3 = 0;
        int n4 = 0;
        int n5 = stringTokenizer.countTokens();
        for (n2 = 0; n2 < n5; ++n2) {
            string = stringTokenizer.nextToken().trim();
            n3 = string.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (string.equals("i") ? this.m_numAttributes : (string.equals("o") ? this.m_numClasses : (string.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(string).intValue())));
            for (n = 0; n < n3; ++n) {
                NeuralNode neuralNode = new NeuralNode(String.valueOf(this.m_nextId), this.m_random, this.m_sigmoidUnit);
                ++this.m_nextId;
                neuralNode.setX(0.5 / (double)n5 * (double)n2 + 0.25);
                neuralNode.setY(((double)n + 1.0) / (double)(n3 + 1));
                this.addNode(neuralNode);
                if (n2 <= 0) continue;
                for (int i = this.m_neuralNodes.length - n - 1 - n4; i < this.m_neuralNodes.length - n - 1; ++i) {
                    NeuralConnection.connect(this.m_neuralNodes[i], neuralNode);
                }
            }
            n4 = n3;
        }
        stringTokenizer = new StringTokenizer(this.m_hiddenLayers, ",");
        string = stringTokenizer.nextToken();
        n3 = string.equals("a") ? (this.m_numAttributes + this.m_numClasses) / 2 : (string.equals("i") ? this.m_numAttributes : (string.equals("o") ? this.m_numClasses : (string.equals("t") ? this.m_numAttributes + this.m_numClasses : Double.valueOf(string).intValue())));
        if (n3 == 0) {
            for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                for (n = 0; n < this.m_numClasses; ++n) {
                    NeuralConnection.connect(this.m_inputs[n2], this.m_neuralNodes[n]);
                }
            }
        } else {
            for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
                for (n = this.m_numClasses; n < this.m_numClasses + n3; ++n) {
                    NeuralConnection.connect(this.m_inputs[n2], this.m_neuralNodes[n]);
                }
            }
            for (n2 = this.m_neuralNodes.length - n4; n2 < this.m_neuralNodes.length; ++n2) {
                for (n = 0; n < this.m_numClasses; ++n) {
                    NeuralConnection.connect(this.m_neuralNodes[n2], this.m_neuralNodes[n]);
                }
            }
        }
    }

    private void setEndsToLinear() {
        for (int i = 0; i < this.m_neuralNodes.length; ++i) {
            if ((this.m_neuralNodes[i].getType() & 8) == 8) {
                ((NeuralNode)this.m_neuralNodes[i]).setMethod(this.m_linearUnit);
                continue;
            }
            ((NeuralNode)this.m_neuralNodes[i]).setMethod(this.m_sigmoidUnit);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_epoch = 0;
        this.m_error = 0.0;
        this.m_instances = null;
        this.m_currentInstance = null;
        this.m_controlPanel = null;
        this.m_nodePanel = null;
        this.m_outputs = new NeuralEnd[0];
        this.m_inputs = new NeuralEnd[0];
        this.m_numAttributes = 0;
        this.m_numClasses = 0;
        this.m_neuralNodes = new NeuralConnection[0];
        this.m_selected = new FastVector(4);
        this.m_graphers = new FastVector(2);
        this.m_nextId = 0;
        this.m_stopIt = true;
        this.m_stopped = true;
        this.m_accepted = false;
        this.m_instances = new Instances(instances);
        this.m_random = new Random(this.m_randomSeed);
        this.m_instances.randomize(this.m_random);
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter = new NominalToBinary();
            this.m_nominalToBinaryFilter.setInputFormat(this.m_instances);
            this.m_instances = Filter.useFilter(this.m_instances, this.m_nominalToBinaryFilter);
        }
        this.m_numAttributes = this.m_instances.numAttributes() - 1;
        this.m_numClasses = this.m_instances.numClasses();
        this.setClassType(this.m_instances);
        Instances instances2 = null;
        int n2 = (int)((double)this.m_valSize / 100.0 * (double)this.m_instances.numInstances());
        if (this.m_valSize > 0) {
            if (n2 == 0) {
                n2 = 1;
            }
            instances2 = new Instances(this.m_instances, 0, n2);
        }
        this.setupInputs();
        this.setupOutputs();
        if (this.m_autoBuild) {
            this.setupHiddenLayer();
        }
        if (this.m_gui) {
            this.m_win = new JFrame();
            this.m_win.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    boolean bl = MultilayerPerceptron.this.m_stopIt;
                    MultilayerPerceptron.this.m_stopIt = true;
                    int n = JOptionPane.showConfirmDialog(MultilayerPerceptron.this.m_win, "Are You Sure...\nClick Yes To Accept The Neural Network\n Click No To Return", "Accept Neural Network", 0);
                    if (n == 0) {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(2);
                        MultilayerPerceptron.this.m_accepted = true;
                        MultilayerPerceptron.this.blocker(false);
                    } else {
                        MultilayerPerceptron.this.m_win.setDefaultCloseOperation(0);
                    }
                    MultilayerPerceptron.this.m_stopIt = bl;
                }
            });
            this.m_win.getContentPane().setLayout(new BorderLayout());
            this.m_win.setTitle("Neural Network");
            this.m_nodePanel = new NodePanel();
            this.m_nodePanel.setPreferredSize(new Dimension(640, 480));
            this.m_nodePanel.revalidate();
            JScrollPane jScrollPane = new JScrollPane(this.m_nodePanel, 22, 31);
            this.m_controlPanel = new ControlPanel();
            this.m_win.getContentPane().add((Component)jScrollPane, "Center");
            this.m_win.getContentPane().add((Component)this.m_controlPanel, "South");
            this.m_win.setSize(640, 480);
            this.m_win.setVisible(true);
        }
        if (this.m_gui) {
            this.blocker(true);
            this.m_controlPanel.m_changeEpochs.setEnabled(false);
            this.m_controlPanel.m_changeLearning.setEnabled(false);
            this.m_controlPanel.m_changeMomentum.setEnabled(false);
        }
        if (this.m_numeric) {
            this.setEndsToLinear();
        }
        if (this.m_accepted) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.m_learningRate;
        if (n2 == this.m_instances.numInstances()) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (n = n2; n < this.m_instances.numInstances(); ++n) {
            if (this.m_instances.instance(n).classIsMissing()) continue;
            d4 += this.m_instances.instance(n).weight();
        }
        if (this.m_valSize != 0) {
            for (n = 0; n < instances2.numInstances(); ++n) {
                if (instances2.instance(n).classIsMissing()) continue;
                d5 += instances2.instance(n).weight();
            }
        }
        this.m_stopped = false;
        for (n = 1; n < this.m_numEpochs + 1; ++n) {
            int n3;
            d = 0.0;
            for (n3 = n2; n3 < this.m_instances.numInstances(); ++n3) {
                this.m_currentInstance = this.m_instances.instance(n3);
                if (this.m_currentInstance.classIsMissing()) continue;
                this.resetNetwork();
                this.calculateOutputs();
                double d7 = this.m_learningRate * this.m_currentInstance.weight();
                if (this.m_decay) {
                    d7 /= (double)n;
                }
                d += this.calculateErrors() / (double)this.m_instances.numClasses() * this.m_currentInstance.weight();
                this.updateNetworkWeights(d7, this.m_momentum);
            }
            if (Double.isInfinite(d /= d4) || Double.isNaN(d)) {
                if (!this.m_reset) {
                    this.m_instances = null;
                    throw new Exception("Network cannot train. Try restarting with a smaller learning rate.");
                }
                if (this.m_learningRate <= Utils.SMALL) {
                    throw new IllegalStateException("Learning rate got too small (" + this.m_learningRate + " <= " + Utils.SMALL + ")!");
                }
                this.m_learningRate /= 2.0;
                this.buildClassifier(instances);
                this.m_learningRate = d6;
                this.m_instances = new Instances(this.m_instances, 0);
                return;
            }
            if (this.m_valSize != 0) {
                d = 0.0;
                for (n3 = 0; n3 < instances2.numInstances(); ++n3) {
                    this.m_currentInstance = instances2.instance(n3);
                    if (this.m_currentInstance.classIsMissing()) continue;
                    this.resetNetwork();
                    this.calculateOutputs();
                    d += this.calculateErrors() / (double)instances2.numClasses() * this.m_currentInstance.weight();
                }
                d2 = d < d3 ? 0.0 : (d2 += 1.0);
                d3 = d;
                if (d2 > (double)this.m_driftThreshold || n + 1 >= this.m_numEpochs) {
                    this.m_accepted = true;
                }
                d /= d5;
            }
            this.m_epoch = n;
            this.m_error = d;
            this.updateDisplay();
            if (this.m_gui) {
                while ((this.m_stopIt || this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) && !this.m_accepted) {
                    this.m_stopIt = true;
                    this.m_stopped = true;
                    if (this.m_epoch >= this.m_numEpochs && this.m_valSize == 0) {
                        this.m_controlPanel.m_startStop.setEnabled(false);
                    } else {
                        this.m_controlPanel.m_startStop.setEnabled(true);
                    }
                    this.m_controlPanel.m_startStop.setText("Start");
                    this.m_controlPanel.m_startStop.setActionCommand("Start");
                    this.m_controlPanel.m_changeEpochs.setEnabled(true);
                    this.m_controlPanel.m_changeLearning.setEnabled(true);
                    this.m_controlPanel.m_changeMomentum.setEnabled(true);
                    this.blocker(true);
                    if (!this.m_numeric) continue;
                    this.setEndsToLinear();
                }
                this.m_controlPanel.m_changeEpochs.setEnabled(false);
                this.m_controlPanel.m_changeLearning.setEnabled(false);
                this.m_controlPanel.m_changeMomentum.setEnabled(false);
                this.m_stopped = false;
                if (this.m_accepted) {
                    this.m_win.dispose();
                    this.m_controlPanel = null;
                    this.m_nodePanel = null;
                    this.m_instances = new Instances(this.m_instances, 0);
                    return;
                }
            }
            if (!this.m_accepted) continue;
            this.m_instances = new Instances(this.m_instances, 0);
            return;
        }
        if (this.m_gui) {
            this.m_win.dispose();
            this.m_controlPanel = null;
            this.m_nodePanel = null;
        }
        this.m_instances = new Instances(this.m_instances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        if (this.m_useNomToBin) {
            this.m_nominalToBinaryFilter.input(instance);
            this.m_currentInstance = this.m_nominalToBinaryFilter.output();
        } else {
            this.m_currentInstance = instance;
        }
        if (this.m_normalizeAttributes) {
            for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
                if (i == this.m_instances.classIndex()) continue;
                if (this.m_attributeRanges[i] != 0.0) {
                    this.m_currentInstance.setValue(i, (this.m_currentInstance.value(i) - this.m_attributeBases[i]) / this.m_attributeRanges[i]);
                    continue;
                }
                this.m_currentInstance.setValue(i, this.m_currentInstance.value(i) - this.m_attributeBases[i]);
            }
        }
        this.resetNetwork();
        double[] dArray = new double[this.m_numClasses];
        for (int i = 0; i < this.m_numClasses; ++i) {
            dArray[i] = this.m_outputs[i].outputValue(true);
        }
        if (this.m_instances.classAttribute().isNumeric()) {
            return dArray;
        }
        double d = 0.0;
        for (n = 0; n < this.m_numClasses; ++n) {
            d += dArray[n];
        }
        if (d <= 0.0) {
            return null;
        }
        n = 0;
        while (n < this.m_numClasses) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(14);
        vector.addElement(new Option("\tLearning Rate for the backpropagation algorithm.\n\t(Value should be between 0 - 1, Default = 0.3).", "L", 1, "-L <learning rate>"));
        vector.addElement(new Option("\tMomentum Rate for the backpropagation algorithm.\n\t(Value should be between 0 - 1, Default = 0.2).", "M", 1, "-M <momentum>"));
        vector.addElement(new Option("\tNumber of epochs to train through.\n\t(Default = 500).", "N", 1, "-N <number of epochs>"));
        vector.addElement(new Option("\tPercentage size of validation set to use to terminate\n\ttraining (if this is non zero it can pre-empt num of epochs.\n\t(Value should be between 0 - 100, Default = 0).", "V", 1, "-V <percentage size of validation set>"));
        vector.addElement(new Option("\tThe value used to seed the random number generator\n\t(Value should be >= 0 and and a long, Default = 0).", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tThe consequetive number of errors allowed for validation\n\ttesting before the netwrok terminates.\n\t(Value should be > 0, Default = 20).", "E", 1, "-E <threshold for number of consequetive errors>"));
        vector.addElement(new Option("\tGUI will be opened.\n\t(Use this to bring up a GUI).", "G", 0, "-G"));
        vector.addElement(new Option("\tAutocreation of the network connections will NOT be done.\n\t(This will be ignored if -G is NOT set)", "A", 0, "-A"));
        vector.addElement(new Option("\tA NominalToBinary filter will NOT automatically be used.\n\t(Set this to not use a NominalToBinary filter).", "B", 0, "-B"));
        vector.addElement(new Option("\tThe hidden layers to be created for the network.\n\t(Value should be a list of comma separated Natural \n\tnumbers or the letters 'a' = (attribs + classes) / 2, \n\t'i' = attribs, 'o' = classes, 't' = attribs .+ classes)\n\tfor wildcard values, Default = a).", "H", 1, "-H <comma seperated numbers for nodes on each layer>"));
        vector.addElement(new Option("\tNormalizing a numeric class will NOT be done.\n\t(Set this to not normalize the class if it's numeric).", "C", 0, "-C"));
        vector.addElement(new Option("\tNormalizing the attributes will NOT be done.\n\t(Set this to not normalize the attributes).", "I", 0, "-I"));
        vector.addElement(new Option("\tReseting the network will NOT be allowed.\n\t(Set this to not allow the network to reset).", "R", 0, "-R"));
        vector.addElement(new Option("\tLearning rate decay will occur.\n\t(Set this to cause the learning rate to decay).", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setLearningRate(new Double(string));
        } else {
            this.setLearningRate(0.3);
        }
        String string2 = Utils.getOption('M', stringArray);
        if (string2.length() != 0) {
            this.setMomentum(new Double(string2));
        } else {
            this.setMomentum(0.2);
        }
        String string3 = Utils.getOption('N', stringArray);
        if (string3.length() != 0) {
            this.setTrainingTime(Integer.parseInt(string3));
        } else {
            this.setTrainingTime(500);
        }
        String string4 = Utils.getOption('V', stringArray);
        if (string4.length() != 0) {
            this.setValidationSetSize(Integer.parseInt(string4));
        } else {
            this.setValidationSetSize(0);
        }
        String string5 = Utils.getOption('S', stringArray);
        if (string5.length() != 0) {
            this.setRandomSeed(Long.parseLong(string5));
        } else {
            this.setRandomSeed(0L);
        }
        String string6 = Utils.getOption('E', stringArray);
        if (string6.length() != 0) {
            this.setValidationThreshold(Integer.parseInt(string6));
        } else {
            this.setValidationThreshold(20);
        }
        String string7 = Utils.getOption('H', stringArray);
        if (string7.length() != 0) {
            this.setHiddenLayers(string7);
        } else {
            this.setHiddenLayers("a");
        }
        if (Utils.getFlag('G', stringArray)) {
            this.setGUI(true);
        } else {
            this.setGUI(false);
        }
        if (Utils.getFlag('A', stringArray)) {
            this.setAutoBuild(false);
        } else {
            this.setAutoBuild(true);
        }
        if (Utils.getFlag('B', stringArray)) {
            this.setNominalToBinaryFilter(false);
        } else {
            this.setNominalToBinaryFilter(true);
        }
        if (Utils.getFlag('C', stringArray)) {
            this.setNormalizeNumericClass(false);
        } else {
            this.setNormalizeNumericClass(true);
        }
        if (Utils.getFlag('I', stringArray)) {
            this.setNormalizeAttributes(false);
        } else {
            this.setNormalizeAttributes(true);
        }
        if (Utils.getFlag('R', stringArray)) {
            this.setReset(false);
        } else {
            this.setReset(true);
        }
        if (Utils.getFlag('D', stringArray)) {
            this.setDecay(true);
        } else {
            this.setDecay(false);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[21];
        int n = 0;
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.getLearningRate();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMomentum();
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getTrainingTime();
        stringArray[n++] = "-V";
        stringArray[n++] = "" + this.getValidationSetSize();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.getValidationThreshold();
        stringArray[n++] = "-H";
        stringArray[n++] = this.getHiddenLayers();
        if (this.getGUI()) {
            stringArray[n++] = "-G";
        }
        if (!this.getAutoBuild()) {
            stringArray[n++] = "-A";
        }
        if (!this.getNominalToBinaryFilter()) {
            stringArray[n++] = "-B";
        }
        if (!this.getNormalizeNumericClass()) {
            stringArray[n++] = "-C";
        }
        if (!this.getNormalizeAttributes()) {
            stringArray[n++] = "-I";
        }
        if (!this.getReset()) {
            stringArray[n++] = "-R";
        }
        if (this.getDecay()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        int n;
        NeuralConnection[] neuralConnectionArray;
        int n2;
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_neuralNodes.length * 100);
        for (n2 = 0; n2 < this.m_neuralNodes.length; ++n2) {
            NeuralNode neuralNode = (NeuralNode)this.m_neuralNodes[n2];
            double[] dArray = neuralNode.getWeights();
            neuralConnectionArray = neuralNode.getInputs();
            if (neuralNode.getMethod() instanceof SigmoidUnit) {
                stringBuffer.append("Sigmoid ");
            } else if (neuralNode.getMethod() instanceof LinearUnit) {
                stringBuffer.append("Linear ");
            }
            stringBuffer.append("Node " + neuralNode.getId() + "\n    Inputs    Weights\n");
            stringBuffer.append("    Threshold    " + dArray[0] + "\n");
            for (n = 1; n < neuralNode.getNumInputs() + 1; ++n) {
                if ((neuralConnectionArray[n - 1].getType() & 1) == 1) {
                    stringBuffer.append("    Attrib " + this.m_instances.attribute(((NeuralEnd)neuralConnectionArray[n - 1]).getLink()).name() + "    " + dArray[n] + "\n");
                    continue;
                }
                stringBuffer.append("    Node " + neuralConnectionArray[n - 1].getId() + "    " + dArray[n] + "\n");
            }
        }
        for (n2 = 0; n2 < this.m_outputs.length; ++n2) {
            neuralConnectionArray = this.m_outputs[n2].getInputs();
            stringBuffer.append("Class " + this.m_instances.classAttribute().value(this.m_outputs[n2].getLink()) + "\n    Input\n");
            for (n = 0; n < this.m_outputs[n2].getNumInputs(); ++n) {
                if ((neuralConnectionArray[n].getType() & 1) == 1) {
                    stringBuffer.append("    Attrib " + this.m_instances.attribute(((NeuralEnd)neuralConnectionArray[n]).getLink()).name() + "\n");
                    continue;
                }
                stringBuffer.append("    Node " + neuralConnectionArray[n].getId() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String globalInfo() {
        return "A Classifier that uses backpropagation to classify instances.\nThis network can be built by hand, created by an algorithm or both. The network can also be monitored and modified during training time. The nodes in this network are all sigmoid (except for when the class is numeric in which case the the output nodes become unthresholded linear units).";
    }

    public String learningRateTipText() {
        return "The amount the weights are updated.";
    }

    public String momentumTipText() {
        return "Momentum applied to the weights during updating.";
    }

    public String autoBuildTipText() {
        return "Adds and connects up hidden layers in the network.";
    }

    public String randomSeedTipText() {
        return "Seed used to initialise the random number generator.Random numbers are used for setting the initial weights of the connections betweem nodes, and also for shuffling the training data.";
    }

    public String validationThresholdTipText() {
        return "Used to terminate validation testing.The value here dictates how many times in a row the validation set error can get worse before training is terminated.";
    }

    public String GUITipText() {
        return "Brings up a gui interface. This will allow the pausing and altering of the nueral network during training.\n\n* To add a node left click (this node will be automatically selected, ensure no other nodes were selected).\n* To select a node left click on it either while no other node is selected or while holding down the control key (this toggles that node as being selected and not selected.\n* To connect a node, first have the start node(s) selected, then click either the end node or on an empty space (this will create a new node that is connected with the selected nodes). The selection status of nodes will stay the same after the connection. (Note these are directed connections, also a connection between two nodes will not be established more than once and certain connections that are deemed to be invalid will not be made).\n* To remove a connection select one of the connected node(s) in the connection and then right click the other node (it does not matter whether the node is the start or end the connection will be removed).\n* To remove a node right click it while no other nodes (including it) are selected. (This will also remove all connections to it)\n.* To deselect a node either left click it while holding down control, or right click on empty space.\n* The raw inputs are provided from the labels on the left.\n* The red nodes are hidden layers.\n* The orange nodes are the output nodes.\n* The labels on the right show the class the output node represents. Note that with a numeric class the output node will automatically be made into an unthresholded linear unit.\n\nAlterations to the neural network can only be done while the network is not running, This also applies to the learning rate and other fields on the control panel.\n\n* You can accept the network as being finished at any time.\n* The network is automatically paused at the beginning.\n* There is a running indication of what epoch the network is up to and what the (rough) error for that epoch was (or for the validation if that is being used). Note that this error value is based on a network that changes as the value is computed. (also depending on whether the class is normalized will effect the error reported for numeric classes.\n* Once the network is done it will pause again and either wait to be accepted or trained more.\n\nNote that if the gui is not set the network will not require any interaction.\n";
    }

    public String validationSetSizeTipText() {
        return "The percentage size of the validation set.(The training will continue until it is observed that the error on the validation set has been consistently getting worse, or if the training time is reached).\nIf This is set to zero no validation set will be used and instead the network will train for the specified number of epochs.";
    }

    public String trainingTimeTipText() {
        return "The number of epochs to train through. If the validation set is non-zero then it can terminate the network early";
    }

    public String nominalToBinaryFilterTipText() {
        return "This will preprocess the instances with the filter. This could help improve performance if there are nominal attributes in the data.";
    }

    public String hiddenLayersTipText() {
        return "This defines the hidden layers of the neural network. This is a list of positive whole numbers. 1 for each hidden layer. Comma seperated. To have no hidden layers put a single 0 here. This will only be used if autobuild is set. There are also wildcard values 'a' = (attribs + classes) / 2, 'i' = attribs, 'o' = classes , 't' = attribs + classes.";
    }

    public String normalizeNumericClassTipText() {
        return "This will normalize the class if it's numeric. This could help improve performance of the network, It normalizes the class to be between -1 and 1. Note that this is only internally, the output will be scaled back to the original range.";
    }

    public String normalizeAttributesTipText() {
        return "This will normalize the attributes. This could help improve performance of the network. This is not reliant on the class being numeric. This will also normalize nominal attributes as well (after they have been run through the nominal to binary filter if that is in use) so that the nominal values are between -1 and 1";
    }

    public String resetTipText() {
        return "This will allow the network to reset with a lower learning rate. If the network diverges from the answer this will automatically reset the network with a lower learning rate and begin training again. This option is only available if the gui is not set. Note that if the network diverges but isn't allowed to reset it will fail the training process and return an error message.";
    }

    public String decayTipText() {
        return "This will cause the learning rate to decrease. This will divide the starting learning rate by the epoch number, to determine what the current learning rate should be. This may help to stop the network from diverging from the target output, as well as improve general performance. Note that the decaying learning rate will not be shown in the gui, only the original learning rate. If the learning rate is changed in the gui, this is treated as the starting learning rate.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.12 $");
    }

    class ControlPanel
    extends JPanel
    implements RevisionHandler {
        static final long serialVersionUID = 7393543302294142271L;
        public JButton m_startStop;
        public JButton m_acceptButton;
        public JPanel m_epochsLabel;
        public JLabel m_totalEpochsLabel;
        public JTextField m_changeEpochs;
        public JLabel m_learningLabel;
        public JLabel m_momentumLabel;
        public JTextField m_changeLearning;
        public JTextField m_changeMomentum;
        public JPanel m_errorLabel;

        public ControlPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Controls"));
            this.m_totalEpochsLabel = new JLabel("Num Of Epochs  ");
            this.m_epochsLabel = new JPanel(){
                private static final long serialVersionUID = 2562773937093221399L;

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(((MultilayerPerceptron)MultilayerPerceptron.this).m_controlPanel.m_totalEpochsLabel.getForeground());
                    graphics.drawString("Epoch  " + MultilayerPerceptron.this.m_epoch, 0, 10);
                }
            };
            this.m_epochsLabel.setFont(this.m_totalEpochsLabel.getFont());
            this.m_changeEpochs = new JTextField();
            this.m_changeEpochs.setText("" + MultilayerPerceptron.this.m_numEpochs);
            this.m_errorLabel = new JPanel(){
                private static final long serialVersionUID = 4390239056336679189L;

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(((MultilayerPerceptron)MultilayerPerceptron.this).m_controlPanel.m_totalEpochsLabel.getForeground());
                    if (MultilayerPerceptron.this.m_valSize == 0) {
                        graphics.drawString("Error per Epoch = " + Utils.doubleToString(MultilayerPerceptron.this.m_error, 7), 0, 10);
                    } else {
                        graphics.drawString("Validation Error per Epoch = " + Utils.doubleToString(MultilayerPerceptron.this.m_error, 7), 0, 10);
                    }
                }
            };
            this.m_errorLabel.setFont(this.m_epochsLabel.getFont());
            this.m_learningLabel = new JLabel("Learning Rate = ");
            this.m_momentumLabel = new JLabel("Momentum = ");
            this.m_changeLearning = new JTextField();
            this.m_changeMomentum = new JTextField();
            this.m_changeLearning.setText("" + MultilayerPerceptron.this.m_learningRate);
            this.m_changeMomentum.setText("" + MultilayerPerceptron.this.m_momentum);
            this.setLayout(new BorderLayout(15, 10));
            MultilayerPerceptron.this.m_stopIt = true;
            MultilayerPerceptron.this.m_accepted = false;
            this.m_startStop = new JButton("Start");
            this.m_startStop.setActionCommand("Start");
            this.m_acceptButton = new JButton("Accept");
            this.m_acceptButton.setActionCommand("Accept");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.m_startStop);
            jPanel.add(this.m_acceptButton);
            this.add((Component)jPanel, "West");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            Box box = new Box(0);
            box.add(this.m_epochsLabel);
            jPanel2.add(box);
            box = new Box(0);
            Component component = Box.createGlue();
            box.add(this.m_totalEpochsLabel);
            box.add(this.m_changeEpochs);
            this.m_changeEpochs.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            box = new Box(0);
            box.add(this.m_errorLabel);
            jPanel2.add(box);
            this.add((Component)jPanel2, "Center");
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            box = new Box(0);
            component = Box.createGlue();
            box.add(this.m_learningLabel);
            box.add(this.m_changeLearning);
            this.m_changeLearning.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            box = new Box(0);
            component = Box.createGlue();
            box.add(this.m_momentumLabel);
            box.add(this.m_changeMomentum);
            this.m_changeMomentum.setMaximumSize(new Dimension(200, 20));
            box.add(component);
            jPanel2.add(box);
            this.add((Component)jPanel2, "East");
            this.m_startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("Start")) {
                        MultilayerPerceptron.this.m_stopIt = false;
                        ControlPanel.this.m_startStop.setText("Stop");
                        ControlPanel.this.m_startStop.setActionCommand("Stop");
                        int n = Integer.valueOf(ControlPanel.this.m_changeEpochs.getText());
                        MultilayerPerceptron.this.m_numEpochs = n;
                        ControlPanel.this.m_changeEpochs.setText("" + MultilayerPerceptron.this.m_numEpochs);
                        double d = Double.valueOf(ControlPanel.this.m_changeLearning.getText());
                        MultilayerPerceptron.this.setLearningRate(d);
                        ControlPanel.this.m_changeLearning.setText("" + MultilayerPerceptron.this.m_learningRate);
                        d = Double.valueOf(ControlPanel.this.m_changeMomentum.getText());
                        MultilayerPerceptron.this.setMomentum(d);
                        ControlPanel.this.m_changeMomentum.setText("" + MultilayerPerceptron.this.m_momentum);
                        MultilayerPerceptron.this.blocker(false);
                    } else if (actionEvent.getActionCommand().equals("Stop")) {
                        MultilayerPerceptron.this.m_stopIt = true;
                        ControlPanel.this.m_startStop.setText("Start");
                        ControlPanel.this.m_startStop.setActionCommand("Start");
                    }
                }
            });
            this.m_acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MultilayerPerceptron.this.m_accepted = true;
                    MultilayerPerceptron.this.blocker(false);
                }
            });
            this.m_changeEpochs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Integer.valueOf(ControlPanel.this.m_changeEpochs.getText());
                    if (n > 0) {
                        MultilayerPerceptron.this.m_numEpochs = n;
                        MultilayerPerceptron.this.blocker(false);
                    }
                }
            });
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.12 $");
        }
    }

    private class NodePanel
    extends JPanel
    implements RevisionHandler {
        static final long serialVersionUID = -3067621833388149984L;

        public NodePanel() {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!MultilayerPerceptron.this.m_stopped) {
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 0x10) == 16 && !mouseEvent.isAltDown()) {
                        int n;
                        Graphics graphics = NodePanel.this.getGraphics();
                        int n2 = mouseEvent.getX();
                        int n3 = mouseEvent.getY();
                        int n4 = NodePanel.this.getWidth();
                        int n5 = NodePanel.this.getHeight();
                        FastVector fastVector = new FastVector(4);
                        for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                            if (!MultilayerPerceptron.this.m_inputs[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_inputs[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                            if (!MultilayerPerceptron.this.m_outputs[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_outputs[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                            if (!MultilayerPerceptron.this.m_neuralNodes[n].onUnit(graphics, n2, n3, n4, n5)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_neuralNodes[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                            return;
                        }
                        NeuralNode neuralNode = new NeuralNode(String.valueOf(MultilayerPerceptron.this.m_nextId), MultilayerPerceptron.this.m_random, MultilayerPerceptron.this.m_sigmoidUnit);
                        MultilayerPerceptron.this.m_nextId++;
                        neuralNode.setX((double)mouseEvent.getX() / (double)n4);
                        neuralNode.setY((double)mouseEvent.getY() / (double)n5);
                        fastVector.addElement(neuralNode);
                        MultilayerPerceptron.this.addNode(neuralNode);
                        NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, true);
                    } else {
                        int n;
                        Graphics graphics = NodePanel.this.getGraphics();
                        int n6 = mouseEvent.getX();
                        int n7 = mouseEvent.getY();
                        int n8 = NodePanel.this.getWidth();
                        int n9 = NodePanel.this.getHeight();
                        FastVector fastVector = new FastVector(4);
                        for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                            if (!MultilayerPerceptron.this.m_inputs[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_inputs[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                            if (!MultilayerPerceptron.this.m_outputs[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_outputs[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                            if (!MultilayerPerceptron.this.m_neuralNodes[n].onUnit(graphics, n6, n7, n8, n9)) continue;
                            fastVector.addElement(MultilayerPerceptron.this.m_neuralNodes[n]);
                            NodePanel.this.selection(fastVector, (mouseEvent.getModifiers() & 2) == 2, false);
                            return;
                        }
                        NodePanel.this.selection(null, (mouseEvent.getModifiers() & 2) == 2, false);
                    }
                }
            });
        }

        private void selection(FastVector fastVector, boolean bl, boolean bl2) {
            if (fastVector == null) {
                MultilayerPerceptron.this.m_selected.removeAllElements();
                this.repaint();
                return;
            }
            if ((bl || MultilayerPerceptron.this.m_selected.size() == 0) && bl2) {
                boolean bl3 = false;
                for (int i = 0; i < fastVector.size(); ++i) {
                    bl3 = false;
                    for (int j = 0; j < MultilayerPerceptron.this.m_selected.size(); ++j) {
                        if (fastVector.elementAt(i) != MultilayerPerceptron.this.m_selected.elementAt(j)) continue;
                        MultilayerPerceptron.this.m_selected.removeElementAt(j);
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    MultilayerPerceptron.this.m_selected.addElement(fastVector.elementAt(i));
                }
                this.repaint();
                return;
            }
            if (bl2) {
                for (int i = 0; i < MultilayerPerceptron.this.m_selected.size(); ++i) {
                    for (int j = 0; j < fastVector.size(); ++j) {
                        NeuralConnection.connect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i), (NeuralConnection)fastVector.elementAt(j));
                    }
                }
            } else if (MultilayerPerceptron.this.m_selected.size() > 0) {
                for (int i = 0; i < MultilayerPerceptron.this.m_selected.size(); ++i) {
                    for (int j = 0; j < fastVector.size(); ++j) {
                        NeuralConnection.disconnect((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i), (NeuralConnection)fastVector.elementAt(j));
                        NeuralConnection.disconnect((NeuralConnection)fastVector.elementAt(j), (NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < fastVector.size(); ++i) {
                    ((NeuralConnection)fastVector.elementAt(i)).removeAllInputs();
                    ((NeuralConnection)fastVector.elementAt(i)).removeAllOutputs();
                    MultilayerPerceptron.this.removeNode((NeuralConnection)fastVector.elementAt(i));
                }
            }
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            if (25 * MultilayerPerceptron.this.m_numAttributes > 25 * MultilayerPerceptron.this.m_numClasses && 25 * MultilayerPerceptron.this.m_numAttributes > n3) {
                this.setSize(n2, 25 * MultilayerPerceptron.this.m_numAttributes);
            } else if (25 * MultilayerPerceptron.this.m_numClasses > n3) {
                this.setSize(n2, 25 * MultilayerPerceptron.this.m_numClasses);
            } else {
                this.setSize(n2, n3);
            }
            n3 = this.getHeight();
            for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                MultilayerPerceptron.this.m_inputs[n].drawInputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                MultilayerPerceptron.this.m_outputs[n].drawInputLines(graphics, n2, n3);
                MultilayerPerceptron.this.m_outputs[n].drawOutputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                MultilayerPerceptron.this.m_neuralNodes[n].drawInputLines(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numAttributes; ++n) {
                MultilayerPerceptron.this.m_inputs[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_numClasses; ++n) {
                MultilayerPerceptron.this.m_outputs[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_neuralNodes.length; ++n) {
                MultilayerPerceptron.this.m_neuralNodes[n].drawNode(graphics, n2, n3);
            }
            for (n = 0; n < MultilayerPerceptron.this.m_selected.size(); ++n) {
                ((NeuralConnection)MultilayerPerceptron.this.m_selected.elementAt(n)).drawHighlight(graphics, n2, n3);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.12 $");
        }
    }

    protected class NeuralEnd
    extends NeuralConnection {
        static final long serialVersionUID = 7305185603191183338L;
        private int m_link;
        private boolean m_input;

        public NeuralEnd(String string) {
            super(string);
            this.m_link = 0;
            this.m_input = true;
        }

        public boolean onUnit(Graphics graphics, int n, int n2, int n3, int n4) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = (int)(this.m_x * (double)n3) - fontMetrics.stringWidth(this.m_id) / 2;
            int n6 = (int)(this.m_y * (double)n4) - fontMetrics.getHeight() / 2;
            return n >= n5 && n <= n5 + fontMetrics.stringWidth(this.m_id) + 4 && n2 >= n6 && n2 <= n6 + fontMetrics.getHeight() + fontMetrics.getDescent() + 4;
        }

        public void drawNode(Graphics graphics, int n, int n2) {
            if ((this.m_type & 1) == 1) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.orange);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (int)(this.m_x * (double)n) - fontMetrics.stringWidth(this.m_id) / 2;
            int n4 = (int)(this.m_y * (double)n2) - fontMetrics.getHeight() / 2;
            graphics.fill3DRect(n3, n4, fontMetrics.stringWidth(this.m_id) + 4, fontMetrics.getHeight() + fontMetrics.getDescent() + 4, true);
            graphics.setColor(Color.black);
            graphics.drawString(this.m_id, n3 + 2, n4 + fontMetrics.getHeight() + 2);
        }

        public void drawHighlight(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (int)(this.m_x * (double)n) - fontMetrics.stringWidth(this.m_id) / 2;
            int n4 = (int)(this.m_y * (double)n2) - fontMetrics.getHeight() / 2;
            graphics.fillRect(n3 - 2, n4 - 2, fontMetrics.stringWidth(this.m_id) + 8, fontMetrics.getHeight() + fontMetrics.getDescent() + 8);
            this.drawNode(graphics, n, n2);
        }

        public double outputValue(boolean bl) {
            if (Double.isNaN(this.m_unitValue) && bl) {
                if (this.m_input) {
                    this.m_unitValue = MultilayerPerceptron.this.m_currentInstance.isMissing(this.m_link) ? 0.0 : MultilayerPerceptron.this.m_currentInstance.value(this.m_link);
                } else {
                    this.m_unitValue = 0.0;
                    for (int i = 0; i < this.m_numInputs; ++i) {
                        this.m_unitValue += this.m_inputList[i].outputValue(true);
                    }
                    if (MultilayerPerceptron.this.m_numeric && MultilayerPerceptron.this.m_normalizeClass) {
                        this.m_unitValue = this.m_unitValue * MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] + MultilayerPerceptron.this.m_attributeBases[MultilayerPerceptron.this.m_instances.classIndex()];
                    }
                }
            }
            return this.m_unitValue;
        }

        public double errorValue(boolean bl) {
            if (!Double.isNaN(this.m_unitValue) && Double.isNaN(this.m_unitError) && bl) {
                if (this.m_input) {
                    this.m_unitError = 0.0;
                    for (int i = 0; i < this.m_numOutputs; ++i) {
                        this.m_unitError += this.m_outputList[i].errorValue(true);
                    }
                } else if (MultilayerPerceptron.this.m_currentInstance.classIsMissing()) {
                    this.m_unitError = 0.1;
                } else if (MultilayerPerceptron.this.m_instances.classAttribute().isNominal()) {
                    this.m_unitError = MultilayerPerceptron.this.m_currentInstance.classValue() == (double)this.m_link ? 1.0 - this.m_unitValue : 0.0 - this.m_unitValue;
                } else if (MultilayerPerceptron.this.m_numeric) {
                    this.m_unitError = MultilayerPerceptron.this.m_normalizeClass ? (MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()] == 0.0 ? 0.0 : (MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue) / MultilayerPerceptron.this.m_attributeRanges[MultilayerPerceptron.this.m_instances.classIndex()]) : MultilayerPerceptron.this.m_currentInstance.classValue() - this.m_unitValue;
                }
            }
            return this.m_unitError;
        }

        public void reset() {
            if (!Double.isNaN(this.m_unitValue) || !Double.isNaN(this.m_unitError)) {
                this.m_unitValue = Double.NaN;
                this.m_unitError = Double.NaN;
                this.m_weightsUpdated = false;
                for (int i = 0; i < this.m_numInputs; ++i) {
                    this.m_inputList[i].reset();
                }
            }
        }

        public void setLink(boolean bl, int n) throws Exception {
            this.m_input = bl;
            this.m_type = bl ? 1 : 2;
            this.m_link = n < 0 || bl && n > MultilayerPerceptron.this.m_instances.numAttributes() || !bl && MultilayerPerceptron.this.m_instances.classAttribute().isNominal() && n > MultilayerPerceptron.this.m_instances.classAttribute().numValues() ? 0 : n;
        }

        public int getLink() {
            return this.m_link;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.12 $");
        }
    }
}

