/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.net.ADNode;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.SimpleEstimator;
import weka.classifiers.bayes.net.search.SearchAlgorithm;
import weka.classifiers.bayes.net.search.local.K2;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class BayesNet
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Drawable,
AdditionalMeasureProducer {
    static final long serialVersionUID = 746037443258775954L;
    protected ParentSet[] m_ParentSets;
    public Estimator[][] m_Distributions;
    protected Discretize m_DiscretizeFilter = null;
    int m_nNonDiscreteAttribute = -1;
    protected ReplaceMissingValues m_MissingValuesFilter = null;
    protected int m_NumClasses;
    public Instances m_Instances;
    ADNode m_ADTree;
    protected BIFReader m_otherBayesNet = null;
    boolean m_bUseADTree = false;
    SearchAlgorithm m_SearchAlgorithm = new K2();
    BayesNetEstimator m_BayesNetEstimator = new SimpleEstimator();

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        instances = this.normalizeDataSet(instances);
        this.m_Instances = new Instances(instances);
        this.m_NumClasses = instances.numClasses();
        if (this.m_bUseADTree) {
            this.m_ADTree = ADNode.makeADTree(instances);
        }
        this.initStructure();
        this.buildStructure();
        this.estimateCPTs();
        this.m_ADTree = null;
    }

    protected Instances normalizeDataSet(Instances instances) throws Exception {
        this.m_DiscretizeFilter = null;
        this.m_MissingValuesFilter = null;
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.type() != 1) {
                this.m_nNonDiscreteAttribute = attribute.index();
                bl = true;
            }
            Enumeration enumeration2 = instances.enumerateInstances();
            while (enumeration2.hasMoreElements()) {
                if (!((Instance)enumeration2.nextElement()).isMissing(attribute)) continue;
                bl2 = true;
            }
        }
        if (bl) {
            System.err.println("Warning: discretizing data set");
            this.m_DiscretizeFilter = new Discretize();
            this.m_DiscretizeFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_DiscretizeFilter);
        }
        if (bl2) {
            System.err.println("Warning: filling in missing values in data set");
            this.m_MissingValuesFilter = new ReplaceMissingValues();
            this.m_MissingValuesFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_MissingValuesFilter);
        }
        return instances;
    }

    protected Instance normalizeInstance(Instance instance) throws Exception {
        if (this.m_DiscretizeFilter != null && instance.attribute(this.m_nNonDiscreteAttribute).type() != 1) {
            this.m_DiscretizeFilter.input(instance);
            instance = this.m_DiscretizeFilter.output();
        }
        if (this.m_MissingValuesFilter != null) {
            this.m_MissingValuesFilter.input(instance);
            instance = this.m_MissingValuesFilter.output();
        } else {
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                if (i == instance.classIndex() || !instance.isMissing(i)) continue;
                System.err.println("Warning: Found missing value in test set, filling in values.");
                this.m_MissingValuesFilter = new ReplaceMissingValues();
                this.m_MissingValuesFilter.setInputFormat(this.m_Instances);
                Filter.useFilter(this.m_Instances, this.m_MissingValuesFilter);
                this.m_MissingValuesFilter.input(instance);
                instance = this.m_MissingValuesFilter.output();
                i = this.m_Instances.numAttributes();
            }
        }
        return instance;
    }

    public void initStructure() throws Exception {
        int n;
        int n2 = 0;
        for (n = 1; n < this.m_Instances.numAttributes(); ++n) {
            if (n2 != this.m_Instances.classIndex()) continue;
            ++n2;
        }
        this.m_ParentSets = new ParentSet[this.m_Instances.numAttributes()];
        for (n = 0; n < this.m_Instances.numAttributes(); ++n) {
            this.m_ParentSets[n] = new ParentSet(this.m_Instances.numAttributes());
        }
    }

    public void buildStructure() throws Exception {
        this.m_SearchAlgorithm.buildStructure(this, this.m_Instances);
    }

    public void estimateCPTs() throws Exception {
        this.m_BayesNetEstimator.estimateCPTs(this);
    }

    public void initCPTs() throws Exception {
        this.m_BayesNetEstimator.initCPTs(this);
    }

    public void updateClassifier(Instance instance) throws Exception {
        instance = this.normalizeInstance(instance);
        this.m_BayesNetEstimator.updateClassifier(this, instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        instance = this.normalizeInstance(instance);
        return this.m_BayesNetEstimator.distributionForInstance(this, instance);
    }

    public double[] countsForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_NumClasses];
        for (n = 0; n < this.m_NumClasses; ++n) {
            dArray[n] = 0.0;
        }
        n = 0;
        while (n < this.m_NumClasses) {
            double d = 0.0;
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                double d2 = 0.0;
                for (int j = 0; j < this.m_ParentSets[i].getNrOfParents(); ++j) {
                    int n2 = this.m_ParentSets[i].getParent(j);
                    d2 = n2 == this.m_Instances.classIndex() ? d2 * (double)this.m_NumClasses + (double)n : d2 * (double)this.m_Instances.attribute(n2).numValues() + instance.value(n2);
                }
                if (i == this.m_Instances.classIndex()) {
                    d += ((DiscreteEstimatorBayes)this.m_Distributions[i][(int)d2]).getCount(n);
                    continue;
                }
                d += ((DiscreteEstimatorBayes)this.m_Distributions[i][(int)d2]).getCount(instance.value(i));
            }
            int n3 = n++;
            dArray[n3] = dArray[n3] + d;
        }
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tDo not use ADTree data structure\n", "D", 0, "-D"));
        vector.addElement(new Option("\tBIF file to compare with\n", "B", 1, "-B <BIF file>"));
        vector.addElement(new Option("\tSearch algorithm\n", "Q", 1, "-Q weka.classifiers.bayes.net.search.SearchAlgorithm"));
        vector.addElement(new Option("\tEstimator algorithm\n", "E", 1, "-E weka.classifiers.bayes.net.estimate.SimpleEstimator"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.m_bUseADTree = !Utils.getFlag('D', stringArray);
        String string2 = Utils.getOption('B', stringArray);
        if (string2 != null && !string2.equals("")) {
            this.setBIFFile(string2);
        }
        if ((string = Utils.getOption('Q', stringArray)).length() != 0) {
            this.setSearchAlgorithm((SearchAlgorithm)Utils.forName(SearchAlgorithm.class, string, BayesNet.partitionOptions(stringArray)));
        } else {
            this.setSearchAlgorithm(new K2());
        }
        String string3 = Utils.getOption('E', stringArray);
        if (string3.length() != 0) {
            this.setEstimator((BayesNetEstimator)Utils.forName(BayesNetEstimator.class, string3, Utils.partitionOptions(stringArray)));
        } else {
            this.setEstimator(new SimpleEstimator());
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public static String[] partitionOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (!stringArray[i].equals("--")) continue;
            for (n = i; n < stringArray.length && !stringArray[n].equals("-E"); ++n) {
            }
            if (n >= stringArray.length) {
                return new String[0];
            }
            stringArray[i++] = "";
            String[] stringArray2 = new String[stringArray.length - i];
            for (n = i; n < stringArray.length && !stringArray[n].equals("-E"); ++n) {
                stringArray2[n - i] = stringArray[n];
                stringArray[n] = "";
            }
            while (n < stringArray.length) {
                stringArray2[n - i] = "";
                ++n;
            }
            return stringArray2;
        }
        return new String[0];
    }

    public String[] getOptions() {
        int n;
        String[] stringArray = this.m_SearchAlgorithm.getOptions();
        String[] stringArray2 = this.m_BayesNetEstimator.getOptions();
        String[] stringArray3 = new String[11 + stringArray.length + stringArray2.length];
        int n2 = 0;
        if (!this.m_bUseADTree) {
            stringArray3[n2++] = "-D";
        }
        if (this.m_otherBayesNet != null) {
            stringArray3[n2++] = "-B";
            stringArray3[n2++] = this.m_otherBayesNet.getFileName();
        }
        stringArray3[n2++] = "-Q";
        stringArray3[n2++] = "" + this.getSearchAlgorithm().getClass().getName();
        stringArray3[n2++] = "--";
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        stringArray3[n2++] = "-E";
        stringArray3[n2++] = "" + this.getEstimator().getClass().getName();
        stringArray3[n2++] = "--";
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        while (n2 < stringArray3.length) {
            stringArray3[n2++] = "";
        }
        return stringArray3;
    }

    public void setSearchAlgorithm(SearchAlgorithm searchAlgorithm) {
        this.m_SearchAlgorithm = searchAlgorithm;
    }

    public SearchAlgorithm getSearchAlgorithm() {
        return this.m_SearchAlgorithm;
    }

    public void setEstimator(BayesNetEstimator bayesNetEstimator) {
        this.m_BayesNetEstimator = bayesNetEstimator;
    }

    public BayesNetEstimator getEstimator() {
        return this.m_BayesNetEstimator;
    }

    public void setUseADTree(boolean bl) {
        this.m_bUseADTree = bl;
    }

    public boolean getUseADTree() {
        return this.m_bUseADTree;
    }

    public void setBIFFile(String string) {
        try {
            this.m_otherBayesNet = new BIFReader().processFile(string);
        }
        catch (Throwable throwable) {
            this.m_otherBayesNet = null;
        }
    }

    public String getBIFFile() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.getFileName();
        }
        return "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bayes Network Classifier");
        stringBuffer.append("\n" + (this.m_bUseADTree ? "Using " : "not using ") + "ADTree");
        if (this.m_Instances == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            stringBuffer.append("\n#attributes=");
            stringBuffer.append(this.m_Instances.numAttributes());
            stringBuffer.append(" #classindex=");
            stringBuffer.append(this.m_Instances.classIndex());
            stringBuffer.append("\nNetwork structure (nodes followed by parents)\n");
            for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                stringBuffer.append(this.m_Instances.attribute(i).name() + "(" + this.m_Instances.attribute(i).numValues() + "): ");
                for (int j = 0; j < this.m_ParentSets[i].getNrOfParents(); ++j) {
                    stringBuffer.append(this.m_Instances.attribute(this.m_ParentSets[i].getParent(j)).name() + " ");
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("LogScore Bayes: " + this.measureBayesScore() + "\n");
            stringBuffer.append("LogScore BDeu: " + this.measureBDeuScore() + "\n");
            stringBuffer.append("LogScore MDL: " + this.measureMDLScore() + "\n");
            stringBuffer.append("LogScore ENTROPY: " + this.measureEntropyScore() + "\n");
            stringBuffer.append("LogScore AIC: " + this.measureAICScore() + "\n");
            if (this.m_otherBayesNet != null) {
                stringBuffer.append("Missing: " + this.m_otherBayesNet.missingArcs(this) + " Extra: " + this.m_otherBayesNet.extraArcs(this) + " Reversed: " + this.m_otherBayesNet.reversedArcs(this) + "\n");
                stringBuffer.append("Divergence: " + this.m_otherBayesNet.divergence(this) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public int graphType() {
        return 2;
    }

    public String graph() throws Exception {
        return this.toXMLBIF03();
    }

    public String getBIFHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
        stringBuffer.append("<!DOCTYPE BIF [\n");
        stringBuffer.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
        stringBuffer.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
        stringBuffer.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
        stringBuffer.append("\t<!ELEMENT NAME (#PCDATA)>\n");
        stringBuffer.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
        stringBuffer.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
        stringBuffer.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
        stringBuffer.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
        stringBuffer.append("\t<!ELEMENT FOR (#PCDATA)>\n");
        stringBuffer.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
        stringBuffer.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
        stringBuffer.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
        stringBuffer.append("]>\n");
        return stringBuffer.toString();
    }

    public String toXMLBIF03() {
        int n;
        int n2;
        if (this.m_Instances == null) {
            return "<!--No model built yet-->";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBIFHeader());
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("<BIF VERSION=\"0.3\">\n");
        stringBuffer.append("<NETWORK>\n");
        stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (n2 = 0; n2 < this.m_Instances.numAttributes(); ++n2) {
            stringBuffer.append("<VARIABLE TYPE=\"nature\">\n");
            stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</NAME>\n");
            for (n = 0; n < this.m_Instances.attribute(n2).numValues(); ++n) {
                stringBuffer.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(n2).value(n)) + "</OUTCOME>\n");
            }
            stringBuffer.append("</VARIABLE>\n");
        }
        for (n2 = 0; n2 < this.m_Instances.numAttributes(); ++n2) {
            stringBuffer.append("<DEFINITION>\n");
            stringBuffer.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</FOR>\n");
            for (n = 0; n < this.m_ParentSets[n2].getNrOfParents(); ++n) {
                stringBuffer.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[n2].getParent(n)).name()) + "</GIVEN>\n");
            }
            stringBuffer.append("<TABLE>\n");
            for (n = 0; n < this.m_ParentSets[n2].getCardinalityOfParents(); ++n) {
                for (int i = 0; i < this.m_Instances.attribute(n2).numValues(); ++i) {
                    stringBuffer.append(this.m_Distributions[n2][n].getProbability(i));
                    stringBuffer.append(' ');
                }
                stringBuffer.append('\n');
            }
            stringBuffer.append("</TABLE>\n");
            stringBuffer.append("</DEFINITION>\n");
        }
        stringBuffer.append("</NETWORK>\n");
        stringBuffer.append("</BIF>\n");
        return stringBuffer.toString();
    }

    protected String XMLNormalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String useADTreeTipText() {
        return "When ADTree (the data structure for increasing speed on counts, not to be confused with the classifier under the same name) is used learning time goes down typically. However, because ADTrees are memory intensive, memory problems may occur. Switching this option off makes the structure learning algorithms slower, and run with less memory. By default, ADTrees are used.";
    }

    public String searchAlgorithmTipText() {
        return "Select method used for searching network structures.";
    }

    public String estimatorTipText() {
        return "Select Estimator algorithm for finding the conditional probability tables of the Bayes Network.";
    }

    public String BIFFileTipText() {
        return "Set the name of a file in BIF XML format. A Bayes network learned from data can be compared with the Bayes network represented by the BIF file. Statistics calculated are o.a. the number of missing and extra arcs.";
    }

    public String globalInfo() {
        return "Bayes Network learning using various search algorithms and quality measures.\nBase class for a Bayes Network classifier. Provides datastructures (network structure, conditional probability distributions, etc.) and facilities common to Bayes Network learning algorithms like K2 and B.\n\nFor more information see:\n\nhttp://www.cs.waikato.ac.nz/~remco/weka.pdf";
    }

    public static void main(String[] stringArray) {
        BayesNet.runClassifier(new BayesNet(), stringArray);
    }

    public String getName() {
        return this.m_Instances.relationName();
    }

    public int getNrOfNodes() {
        return this.m_Instances.numAttributes();
    }

    public String getNodeName(int n) {
        return this.m_Instances.attribute(n).name();
    }

    public int getCardinality(int n) {
        return this.m_Instances.attribute(n).numValues();
    }

    public String getNodeValue(int n, int n2) {
        return this.m_Instances.attribute(n).value(n2);
    }

    public int getNrOfParents(int n) {
        return this.m_ParentSets[n].getNrOfParents();
    }

    public int getParent(int n, int n2) {
        return this.m_ParentSets[n].getParent(n2);
    }

    public ParentSet[] getParentSets() {
        return this.m_ParentSets;
    }

    public Estimator[][] getDistributions() {
        return this.m_Distributions;
    }

    public int getParentCardinality(int n) {
        return this.m_ParentSets[n].getCardinalityOfParents();
    }

    public double getProbability(int n, int n2, int n3) {
        return this.m_Distributions[n][n2].getProbability(n3);
    }

    public ParentSet getParentSet(int n) {
        return this.m_ParentSets[n];
    }

    public ADNode getADTree() {
        return this.m_ADTree;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(4);
        vector.addElement("measureExtraArcs");
        vector.addElement("measureMissingArcs");
        vector.addElement("measureReversedArcs");
        vector.addElement("measureDivergence");
        vector.addElement("measureBayesScore");
        vector.addElement("measureBDeuScore");
        vector.addElement("measureMDLScore");
        vector.addElement("measureAICScore");
        vector.addElement("measureEntropyScore");
        return vector.elements();
    }

    public double measureExtraArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.extraArcs(this);
        }
        return 0.0;
    }

    public double measureMissingArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.missingArcs(this);
        }
        return 0.0;
    }

    public double measureReversedArcs() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.reversedArcs(this);
        }
        return 0.0;
    }

    public double measureDivergence() {
        if (this.m_otherBayesNet != null) {
            return this.m_otherBayesNet.divergence(this);
        }
        return 0.0;
    }

    public double measureBayesScore() {
        LocalScoreSearchAlgorithm localScoreSearchAlgorithm = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return localScoreSearchAlgorithm.logScore(0);
    }

    public double measureBDeuScore() {
        LocalScoreSearchAlgorithm localScoreSearchAlgorithm = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return localScoreSearchAlgorithm.logScore(1);
    }

    public double measureMDLScore() {
        LocalScoreSearchAlgorithm localScoreSearchAlgorithm = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return localScoreSearchAlgorithm.logScore(2);
    }

    public double measureAICScore() {
        LocalScoreSearchAlgorithm localScoreSearchAlgorithm = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return localScoreSearchAlgorithm.logScore(4);
    }

    public double measureEntropyScore() {
        LocalScoreSearchAlgorithm localScoreSearchAlgorithm = new LocalScoreSearchAlgorithm(this, this.m_Instances);
        return localScoreSearchAlgorithm.logScore(3);
    }

    public double getMeasure(String string) {
        if (string.equals("measureExtraArcs")) {
            return this.measureExtraArcs();
        }
        if (string.equals("measureMissingArcs")) {
            return this.measureMissingArcs();
        }
        if (string.equals("measureReversedArcs")) {
            return this.measureReversedArcs();
        }
        if (string.equals("measureDivergence")) {
            return this.measureDivergence();
        }
        if (string.equals("measureBayesScore")) {
            return this.measureBayesScore();
        }
        if (string.equals("measureBDeuScore")) {
            return this.measureBDeuScore();
        }
        if (string.equals("measureMDLScore")) {
            return this.measureMDLScore();
        }
        if (string.equals("measureAICScore")) {
            return this.measureAICScore();
        }
        if (string.equals("measureEntropyScore")) {
            return this.measureEntropyScore();
        }
        return 0.0;
    }
}

