/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class C45Saver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
OptionHandler {
    static final long serialVersionUID = -821428878384253377L;

    public C45Saver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in the format used by the C4.5 algorithm.\nTherefore it outputs a names and a data file.";
    }

    public String getFileDescription() {
        return "C4.5 file format";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".names");
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        PrintWriter printWriter = null;
        if (instances != null) {
            if (instances.classIndex() == -1) {
                instances.setClassIndex(instances.numAttributes() - 1);
                System.err.println("No class specified. Last attribute is used as class attribute.");
            }
            if (instances.attribute(instances.classIndex()).isNumeric()) {
                throw new IOException("To save in C4.5 format the class attribute cannot be numeric.");
            }
        }
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("C4.5 format requires two files. Therefore no output to standard out can be generated.\nPlease specifiy output files using the -o option.");
        }
        printWriter = new PrintWriter(this.getWriter());
        if (n == 1) {
            if (instances == null) {
                this.setWriteMode(2);
                if (instance != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            n = this.getWriteMode();
        }
        if (n == 2) {
            if (printWriter != null) {
                printWriter.close();
            }
            this.cancel();
        }
        if (n == 3) {
            Serializable serializable;
            int n2;
            this.setWriteMode(0);
            for (n2 = 0; n2 < instances.attribute(instances.classIndex()).numValues(); ++n2) {
                printWriter.write(instances.attribute(instances.classIndex()).value(n2));
                if (n2 < instances.attribute(instances.classIndex()).numValues() - 1) {
                    printWriter.write(",");
                    continue;
                }
                printWriter.write(".\n");
            }
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 == instances.classIndex()) continue;
                printWriter.write(instances.attribute(n2).name() + ": ");
                if (instances.attribute(n2).isNumeric() || instances.attribute(n2).isDate()) {
                    printWriter.write("continuous.\n");
                    continue;
                }
                serializable = instances.attribute(n2);
                for (int i = 0; i < ((Attribute)serializable).numValues(); ++i) {
                    printWriter.write(((Attribute)serializable).value(i));
                    if (i < ((Attribute)serializable).numValues() - 1) {
                        printWriter.write(",");
                        continue;
                    }
                    printWriter.write(".\n");
                }
            }
            printWriter.flush();
            printWriter.close();
            n = this.getWriteMode();
            String string = this.retrieveFile().getAbsolutePath();
            this.setFileExtension(".data");
            string = string.substring(0, string.lastIndexOf(46)) + this.getFileExtension();
            serializable = new File(string);
            try {
                this.setFile((File)serializable);
                this.setDestination((File)serializable);
            }
            catch (Exception exception) {
                throw new IOException("Cannot create data file, only names file created.");
            }
            if (this.retrieveFile() == null || this.getWriter() == null) {
                throw new IOException("Cannot create data file, only names file created.");
            }
            printWriter = new PrintWriter(this.getWriter());
        }
        if (n == 0) {
            if (instances == null) {
                throw new IOException("No instances information available.");
            }
            if (instance != null) {
                for (int i = 0; i < instance.numAttributes(); ++i) {
                    if (i == instances.classIndex()) continue;
                    if (instance.isMissing(i)) {
                        printWriter.write("?,");
                        continue;
                    }
                    if (instances.attribute(i).isNominal() || instances.attribute(i).isString()) {
                        printWriter.write(instances.attribute(i).value((int)instance.value(i)) + ",");
                        continue;
                    }
                    printWriter.write("" + instance.value(i) + ",");
                }
                if (instance.isMissing(instances.classIndex())) {
                    printWriter.write("?");
                } else {
                    printWriter.write(instances.attribute(instances.classIndex()).value((int)instance.value(instances.classIndex())));
                }
                printWriter.write("\n");
                ++this.m_incrementalCounter;
                if (this.m_incrementalCounter > 100) {
                    this.m_incrementalCounter = 0;
                    printWriter.flush();
                }
            } else {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                this.setFileExtension(".names");
                this.m_incrementalCounter = 0;
                this.resetStructure();
                printWriter = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        int n;
        Serializable serializable;
        int n2;
        Instances instances = this.getInstances();
        if (instances == null) {
            throw new IOException("No instances to save");
        }
        if (instances.classIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
            System.err.println("No class specified. Last attribute is used as class attribute.");
        }
        if (instances.attribute(instances.classIndex()).isNumeric()) {
            throw new IOException("To save in C4.5 format the class attribute cannot be numeric.");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("C4.5 format requires two files. Therefore no output to standard out can be generated.\nPlease specifiy output files using the -o option.");
        }
        this.setWriteMode(0);
        this.setFileExtension(".names");
        PrintWriter printWriter = new PrintWriter(this.getWriter());
        for (n2 = 0; n2 < instances.attribute(instances.classIndex()).numValues(); ++n2) {
            printWriter.write(instances.attribute(instances.classIndex()).value(n2));
            if (n2 < instances.attribute(instances.classIndex()).numValues() - 1) {
                printWriter.write(",");
                continue;
            }
            printWriter.write(".\n");
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (n2 == instances.classIndex()) continue;
            printWriter.write(instances.attribute(n2).name() + ": ");
            if (instances.attribute(n2).isNumeric() || instances.attribute(n2).isDate()) {
                printWriter.write("continuous.\n");
                continue;
            }
            serializable = instances.attribute(n2);
            for (n = 0; n < ((Attribute)serializable).numValues(); ++n) {
                printWriter.write(((Attribute)serializable).value(n));
                if (n < ((Attribute)serializable).numValues() - 1) {
                    printWriter.write(",");
                    continue;
                }
                printWriter.write(".\n");
            }
        }
        printWriter.flush();
        printWriter.close();
        String string = this.retrieveFile().getAbsolutePath();
        this.setFileExtension(".data");
        string = string.substring(0, string.lastIndexOf(46)) + this.getFileExtension();
        serializable = new File(string);
        try {
            this.setFile((File)serializable);
            this.setDestination(this.retrieveFile());
        }
        catch (Exception exception) {
            throw new IOException("Cannot create data file, only names file created.");
        }
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("Cannot create data file, only names file created.");
        }
        printWriter = new PrintWriter(this.getWriter());
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance = instances.instance(n);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == instances.classIndex()) continue;
                if (instance.isMissing(i)) {
                    printWriter.write("?,");
                    continue;
                }
                if (instances.attribute(i).isNominal() || instances.attribute(i).isString()) {
                    printWriter.write(instances.attribute(i).value((int)instance.value(i)) + ",");
                    continue;
                }
                printWriter.write("" + instance.value(i) + ",");
            }
            if (instance.isMissing(instances.classIndex())) {
                printWriter.write("?");
            } else {
                printWriter.write(instances.attribute(instances.classIndex()).value((int)instance.value(instances.classIndex())));
            }
            printWriter.write("\n");
        }
        printWriter.flush();
        printWriter.close();
        this.setFileExtension(".names");
        this.setWriteMode(1);
        printWriter = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector(3);
        fastVector.addElement(new Option("The input file", "i", 1, "-i <the input file>"));
        fastVector.addElement(new Option("The output file", "o", 1, "-o <the output file>"));
        fastVector.addElement(new Option("The class index", "c", 1, "-c <the class index>"));
        return fastVector.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOptions(String[] stringArray) throws Exception {
        File file;
        String string = Utils.getOption('o', stringArray);
        String string2 = Utils.getOption('i', stringArray);
        String string3 = Utils.getOption('c', stringArray);
        ArffLoader arffLoader = new ArffLoader();
        this.resetOptions();
        if (string2.length() == 0) throw new IOException("No data set to save.");
        try {
            file = new File(string2);
            arffLoader.setFile(file);
            this.setInstances(arffLoader.getDataSet());
        }
        catch (Exception exception) {
            throw new IOException("No data set loaded. Data set has to be arff format.");
        }
        if (string.length() != 0) {
            if (!string.endsWith(this.getFileExtension())) {
                string = string.lastIndexOf(46) != -1 ? string.substring(0, string.lastIndexOf(46)) + this.getFileExtension() : string + this.getFileExtension();
            }
            try {
                file = new File(string);
                this.setFile(file);
            }
            catch (Exception exception) {
                throw new IOException("Cannot create output file.");
            }
            finally {
                this.setDestination(this.retrieveFile());
            }
        }
        if (string3.length() != 0) {
            if (string3.equals("first")) {
                this.getInstances().setClassIndex(0);
                return;
            } else if (string3.equals("last")) {
                this.getInstances().setClassIndex(this.getInstances().numAttributes() - 1);
                return;
            } else {
                int n = Integer.parseInt(string3);
                if (n < 0 || n >= this.getInstances().numAttributes()) throw new IOException("Invalid class index");
                this.getInstances().setClassIndex(n);
            }
            return;
        } else {
            this.getInstances().setClassIndex(this.getInstances().numAttributes() - 1);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.retrieveFile() != null) {
            stringArray[n++] = "-o";
            stringArray[n++] = "" + this.retrieveFile();
        } else {
            stringArray[n++] = "-o";
            stringArray[n++] = "";
        }
        if (this.getInstances() != null) {
            stringArray[n++] = "-i";
            stringArray[n++] = "" + this.getInstances().relationName();
            stringArray[n++] = "-c";
            stringArray[n++] = "" + this.getInstances().classIndex();
        } else {
            stringArray[n++] = "-i";
            stringArray[n++] = "";
            stringArray[n++] = "-c";
            stringArray[n++] = "";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            C45Saver c45Saver = new C45Saver();
            stringBuffer.append("\n\nC45Saver options:\n\n");
            Enumeration enumeration = c45Saver.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + '\n');
            }
            try {
                c45Saver.setOptions(stringArray);
            }
            catch (Exception exception) {
                System.out.println("\n" + stringBuffer);
                System.exit(1);
            }
            c45Saver.writeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

