/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClusterer
implements OptionHandler {
    protected Clusterer m_Clusterer = new SimpleKMeans();
    protected String[] m_ClustererOptions;
    protected String m_AnalysisResults;
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;
    protected int m_NumInstances = 40;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        vector.addElement(new Option("\tThe number of instances in the datasets (default 40).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tFull name of the clusterer analyzed.\n\teg: weka.clusterers.SimpleKMeans", "W", 1, "-W"));
        if (this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setSilent(Utils.getFlag('S', stringArray));
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else {
            this.setNumInstances(40);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A clusterer must be specified with the -W option.");
        }
        this.setClusterer(Clusterer.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getSilent()) {
            vector.add("-S");
        }
        vector.add("-N");
        vector.add("" + this.getNumInstances());
        if (this.getClusterer() != null) {
            vector.add("-W");
            vector.add(this.getClusterer().getClass().getName());
        }
        if ((stringArray = this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler ? ((OptionHandler)((Object)this.m_Clusterer)).getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void doTests() {
        if (this.getClusterer() == null) {
            this.println("\n=== No clusterer set ===");
            return;
        }
        this.println("\n=== Check on Clusterer: " + this.getClusterer().getClass().getName() + " ===\n");
        this.canTakeOptions();
        boolean bl = this.weightedInstancesHandler()[0];
        boolean bl2 = this.multiInstanceHandler()[0];
        this.runTests(bl, bl2);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean bl) {
        this.m_Silent = bl;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public void setNumInstances(int n) {
        this.m_NumInstances = n;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected void print(Object object) {
        if (!this.getSilent()) {
            System.out.print(object);
        }
    }

    protected void println(Object object) {
        this.print(object + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected void runTests(boolean bl, boolean bl2) {
        boolean bl3 = this.canPredict(true, false, false, false, false, bl2)[0];
        boolean bl4 = this.canPredict(false, true, false, false, false, bl2)[0];
        boolean bl5 = this.canPredict(false, false, true, false, false, bl2)[0];
        boolean bl6 = this.canPredict(false, false, false, true, false, bl2)[0];
        boolean bl7 = !bl2 ? this.canPredict(false, false, false, false, true, bl2)[0] : false;
        if (bl3 || bl4 || bl5 || bl6 || bl7) {
            if (bl) {
                this.instanceWeights(bl3, bl4, bl5, bl6, bl7, bl2);
            }
            this.canHandleZeroTraining(bl3, bl4, bl5, bl6, bl7, bl2);
            boolean bl8 = this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, true, 20)[0];
            if (bl8) {
                this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, true, 100);
            }
            this.correctBuildInitialisation(bl3, bl4, bl5, bl6, bl7, bl2);
            this.datasetIntegrity(bl3, bl4, bl5, bl6, bl7, bl2, bl8);
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Clusterer instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances clusterer...");
        if (this.m_Clusterer instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] blArray = new boolean[2];
        this.print("multi-instance clusterer...");
        if (this.m_Clusterer instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] canPredict(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("date");
        fastVector.addElement("relational");
        fastVector.addElement("multi-instance");
        fastVector.addElement("not in classpath");
        int n = this.getNumInstances();
        int n2 = this.getNumInstances();
        int n3 = 0;
        boolean bl7 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n3, bl7, n, n2, fastVector);
    }

    protected boolean[] canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n = 0;
        int n2 = this.getNumInstances();
        int n3 = 0;
        boolean bl7 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n3, bl7, n, n2, fastVector);
    }

    protected boolean[] correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        boolean[] blArray;
        block16: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildClusterer");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 0;
            boolean bl7 = false;
            Instances instances = null;
            Instances instances2 = null;
            Instances instances3 = null;
            Instances instances4 = null;
            Clusterer clusterer = null;
            ClusterEvaluation clusterEvaluation = null;
            ClusterEvaluation clusterEvaluation2 = null;
            ClusterEvaluation clusterEvaluation3 = null;
            boolean bl8 = false;
            int n4 = 0;
            try {
                instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances3 = this.makeTestDataset(84, n, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances4 = this.makeTestDataset(48, n2, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                    instances3.deleteAttributeAt(0);
                    instances4.deleteAttributeAt(0);
                }
                if (n3 > 0) {
                    this.addMissing(instances, n3, bl7);
                    this.addMissing(instances2, Math.min(n3, 50), bl7);
                    this.addMissing(instances3, n3, bl7);
                    this.addMissing(instances4, Math.min(n3, 50), bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
                clusterEvaluation = new ClusterEvaluation();
                clusterEvaluation2 = new ClusterEvaluation();
                clusterEvaluation3 = new ClusterEvaluation();
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n4 = 0;
                clusterer.buildClusterer(instances);
                clusterEvaluation.setClusterer(clusterer);
                clusterEvaluation.evaluateClusterer(instances);
                bl8 = true;
                n4 = 1;
                bl8 = false;
                clusterer.buildClusterer(instances3);
                clusterEvaluation3.setClusterer(clusterer);
                clusterEvaluation3.evaluateClusterer(instances3);
                bl8 = true;
                n4 = 2;
                bl8 = false;
                clusterer.buildClusterer(instances);
                clusterEvaluation2.setClusterer(clusterer);
                clusterEvaluation2.evaluateClusterer(instances);
                bl8 = true;
                n4 = 3;
                if (!clusterEvaluation.equals(clusterEvaluation2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n");
                        this.println("First buildClusterer()");
                        this.println(clusterEvaluation.clusterResultsToString() + "\n\n");
                        this.println("Second buildClusterer()");
                        this.println(clusterEvaluation2.clusterResultsToString() + "\n\n");
                    }
                    throw new Exception("Results differ between buildClusterer calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block16;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl8) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (n4) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + instances3.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + instances4.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n) {
        if (n == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl7) {
            this.print(" predictor");
        }
        this.print(" values");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, bl7, n2, n3, fastVector);
    }

    protected boolean[] instanceWeights(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        boolean[] blArray;
        block14: {
            this.print("clusterer uses instance weights");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = 2 * this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 0;
            boolean bl7 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Clusterer[] clustererArray = null;
            ClusterEvaluation clusterEvaluation = null;
            ClusterEvaluation clusterEvaluation2 = null;
            boolean bl8 = false;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances2 = this.makeTestDataset(24, n2, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n3 > 0) {
                    this.addMissing(instances, n3, bl7);
                    this.addMissing(instances2, Math.min(n3, 50), bl7);
                }
                clustererArray = Clusterer.makeCopies(this.getClusterer(), 2);
                clusterEvaluation = new ClusterEvaluation();
                clusterEvaluation2 = new ClusterEvaluation();
                clustererArray[0].buildClusterer(instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n4 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n5 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n4).setWeight(n5);
                }
                clustererArray[1].buildClusterer(instances);
                bl8 = true;
                if (clusterEvaluation.equals(clusterEvaluation2)) {
                    bl9 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block14;
                this.println("\n=== Full Report ===");
                if (bl9) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println("\nboth methods\n");
                    this.println(clusterEvaluation.clusterResultsToString());
                } else {
                    this.print("Problem during");
                    if (bl8) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        boolean[] blArray;
        block8: {
            this.print("clusterer doesn't alter original datasets");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 20;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Clusterer clusterer = null;
            boolean bl8 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n3 > 0) {
                    this.addMissing(instances, n3, bl7);
                    this.addMissing(instances2, Math.min(n3, 50), bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances3 = new Instances(instances);
                Instances instances4 = new Instances(instances2);
                clusterer.buildClusterer(instances3);
                this.compareDatasets(instances, instances3);
                bl8 = true;
                this.compareDatasets(instances2, instances4);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block8;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl8) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, int n2, int n3, FastVector fastVector) {
        boolean[] blArray;
        block12: {
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Clusterer clusterer = null;
            boolean bl8 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                instances2 = this.makeTestDataset(24, n3, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, bl5 ? 1 : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n > 0) {
                    this.addMissing(instances, n, bl7);
                    this.addMissing(instances2, Math.min(n, 50), bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                clusterer.buildClusterer(instances);
                bl8 = true;
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n4;
                boolean bl9 = false;
                String string = exception.getMessage().toLowerCase();
                for (n4 = 0; n4 < fastVector.size(); ++n4) {
                    if (string.indexOf((String)fastVector.elementAt(n4)) < 0) continue;
                    bl9 = true;
                }
                this.println("no" + (bl9 ? " (OK error message)" : ""));
                blArray[1] = bl9;
                if (!this.m_Debug) break block12;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl8) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                if (bl9) break block12;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n4 = 0; n4 < fastVector.size(); ++n4) {
                        if (n4 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n4) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected void compareDatasets(Instances instances, Instances instances2) throws Exception {
        if (!instances2.equalHeaders(instances)) {
            throw new Exception("header has been modified");
        }
        if (instances2.numInstances() != instances.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Instance instance2 = instances2.instance(i);
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j) ? !instance2.isMissing(j) : instance.value(j) != instance2.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (instance.weight() == instance2.weight()) continue;
                throw new Exception("instance weights have changed");
            }
        }
    }

    protected void addMissing(Instances instances, int n, boolean bl) {
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!bl || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws Exception {
        TestInstances testInstances = new TestInstances();
        testInstances.setSeed(n);
        testInstances.setNumInstances(n2);
        testInstances.setNumNominal(n3);
        testInstances.setNumNumeric(n4);
        testInstances.setNumString(n5);
        testInstances.setNumDate(n6);
        testInstances.setNumRelational(n7);
        testInstances.setClassIndex(-2);
        testInstances.setMultiInstance(bl);
        return testInstances.generate();
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        String string = "";
        if (bl2) {
            string = string + "numeric";
        }
        if (bl) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "nominal";
        }
        if (bl3) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "string";
        }
        if (bl4) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "date";
        }
        if (bl5) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "relational";
        }
        string = " (" + string + " predictors)";
        this.print(string);
    }

    public static void main(String[] stringArray) {
        try {
            CheckClusterer checkClusterer = new CheckClusterer();
            try {
                checkClusterer.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\n\n" + checkClusterer.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration enumeration = checkClusterer.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            checkClusterer.doTests();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

