/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.supervised.attribute.Discretize;

public class FilteredClassifier
extends SingleClassifierEnhancer
implements Drawable {
    static final long serialVersionUID = -4523450618538717400L;
    protected Filter m_Filter = new AttributeSelection();
    protected Instances m_FilteredInstances;

    public String globalInfo() {
        return "Class for running an arbitrary classifier on data that has been passed through an arbitrary filter. Like the classifier, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public FilteredClassifier() {
        this.m_Classifier = new J48();
        this.m_Filter = new Discretize();
    }

    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.AttributeFilter -V -R 1,2\"", "F", 1, "-F <filter specification>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        if (string.length() > 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string2, stringArray2));
        } else {
            this.setFilter(new Discretize());
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        int n = 0;
        stringArray2[n++] = "-F";
        stringArray2[n++] = "" + this.getFilterSpec();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        if (filter instanceof OptionHandler) {
            return filter.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return filter.getClass().getName();
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifiers have been set!");
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Filter.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Filter);
        this.getCapabilities().testWithFail(instances);
        this.m_FilteredInstances = instances.stringFreeStructure();
        this.m_Classifier.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            throw new Exception("Filter didn't make the test instance immediately available!");
        }
        this.m_Filter.batchFinished();
        Instance instance2 = this.m_Filter.output();
        return this.m_Classifier.distributionForInstance(instance2);
    }

    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "FilteredClassifier: No model built yet.";
        }
        String string = "FilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new FilteredClassifier(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

