/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.stemmers.Stemmer;
import weka.core.stemmers.Stemming;

public class SnowballStemmer
implements Stemmer,
OptionHandler {
    public static final String PACKAGE = "org.tartarus.snowball";
    public static final String PACKAGE_EXT = "org.tartarus.snowball.ext";
    protected static final String SNOWBALL_PROGRAM = "org.tartarus.snowball.SnowballProgram";
    protected static boolean m_Present = false;
    protected static Vector m_Stemmers;
    protected Object m_Stemmer;
    protected transient Method m_StemMethod;
    protected transient Method m_SetCurrentMethod;
    protected transient Method m_GetCurrentMethod;
    static /* synthetic */ Class class$java$lang$String;

    public SnowballStemmer() {
        this("porter");
    }

    public SnowballStemmer(String string) {
        this.setStemmer(string);
    }

    private static void checkForSnowball() {
        try {
            Class.forName(SNOWBALL_PROGRAM);
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }

    public String globalInfo() {
        return "A wrapper class for the Snowball stemmers. Only available if the Snowball classes are in the classpath.\nFor more information visit these web sites:\n  http://www.cs.waikato.ac.nz/~ml/weka/stemmers/\n  http://snowball.tartarus.org/\n";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe name of the snowball stemmer (default 'porter').\n\tavailable stemmers:\n" + SnowballStemmer.getStemmerList(65, "\t   "), "S", 1, "-S <name>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setStemmer(string);
        } else {
            this.setStemmer("porter");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getStemmer() != null) {
            vector.add("-S");
            vector.add("" + this.getStemmer());
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static String getStemmerName(String string) {
        return string.replaceAll(".*\\.", "").replaceAll("Stemmer$", "");
    }

    private static String getStemmerClassname(String string) {
        return "org.tartarus.snowball.ext." + string + "Stemmer";
    }

    private static void loadStemmers() {
        m_Stemmers = new Vector();
        if (!m_Present) {
            return;
        }
        Vector vector = ClassDiscovery.find(SNOWBALL_PROGRAM, PACKAGE_EXT);
        for (int i = 0; i < vector.size(); ++i) {
            m_Stemmers.add(SnowballStemmer.getStemmerName(vector.get(i).toString()));
        }
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Enumeration listStemmers() {
        return m_Stemmers.elements();
    }

    private static String getStemmerList(int n, String string) {
        String string2 = "";
        String string3 = "";
        Enumeration enumeration = SnowballStemmer.listStemmers();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            if (n > 0 && string3.length() + string4.length() > n) {
                string2 = string2 + string + string3 + "\n";
                string3 = "";
            }
            string3 = string3 + string4;
        }
        if (string3.length() > 0) {
            string2 = string2 + string + string3 + "\n";
        }
        return string2;
    }

    public String getStemmer() {
        if (this.m_Stemmer == null) {
            return null;
        }
        return SnowballStemmer.getStemmerName(this.m_Stemmer.getClass().getName());
    }

    public void setStemmer(String string) {
        if (m_Stemmers.contains(string)) {
            try {
                Class<?> clazz = Class.forName(SnowballStemmer.getStemmerClassname(string));
                this.m_Stemmer = clazz.newInstance();
                Class[] classArray = new Class[]{};
                this.m_StemMethod = clazz.getMethod("stem", classArray);
                classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SnowballStemmer.class$("java.lang.String")) : class$java$lang$String};
                this.m_SetCurrentMethod = clazz.getMethod("setCurrent", classArray);
                classArray = new Class[]{};
                this.m_GetCurrentMethod = clazz.getMethod("getCurrent", classArray);
            }
            catch (Exception exception) {
                System.out.println("Error initializing stemmer '" + string + "'!" + exception.getMessage());
                this.m_Stemmer = null;
            }
        } else {
            System.out.println("Stemmer '" + string + "' unknown!");
            this.m_Stemmer = null;
        }
    }

    public String stemmerTipText() {
        return "The Snowball stemmer to use, available: " + SnowballStemmer.getStemmerList(0, "");
    }

    public String stem(String string) {
        String string2;
        if (this.m_Stemmer == null) {
            string2 = new String(string);
        } else {
            try {
                Object[] objectArray = new Object[]{string};
                this.m_SetCurrentMethod.invoke(this.m_Stemmer, objectArray);
                objectArray = new Object[]{};
                this.m_StemMethod.invoke(this.m_Stemmer, objectArray);
                objectArray = new Object[]{};
                string2 = (String)this.m_GetCurrentMethod.invoke(this.m_Stemmer, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string2 = string;
            }
        }
        return string2;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + " " + Utils.joinOptions(this.getOptions());
        return string.trim();
    }

    public static void main(String[] stringArray) {
        try {
            Stemming.useStemmer(new SnowballStemmer(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SnowballStemmer.checkForSnowball();
        SnowballStemmer.loadStemmers();
    }
}

