/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomForest
extends Classifier
implements OptionHandler,
Randomizable,
WeightedInstancesHandler,
AdditionalMeasureProducer {
    protected int m_numTrees = 10;
    protected int m_numFeatures = 0;
    protected int m_randomSeed = 1;
    protected int m_KValue = 0;
    protected Bagging m_bagger = null;

    public String globalInfo() {
        return "Class for constructing a forest of random trees. For more information see: \n\nLeo Breiman. \"Random Forests\". Machine Learning 45 (1):5-32, October 2001.";
    }

    public String numTreesTipText() {
        return "The number of trees to be generated.";
    }

    public int getNumTrees() {
        return this.m_numTrees;
    }

    public void setNumTrees(int n) {
        this.m_numTrees = n;
    }

    public String numFeaturesTipText() {
        return "The number of attributes to be used in random selection (see RandomTree).";
    }

    public int getNumFeatures() {
        return this.m_numFeatures;
    }

    public void setNumFeatures(int n) {
        this.m_numFeatures = n;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public double measureOutOfBagError() {
        if (this.m_bagger != null) {
            return this.m_bagger.measureOutOfBagError();
        }
        return Double.NaN;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureOutOfBagError");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(string + " not supported (RandomForest)");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tNumber of trees to build.", "I", 1, "-I <number of trees>"));
        vector.addElement(new Option("\tNumber of features to consider (<1=int(logM+1)).", "K", 1, "-K <number of features>"));
        vector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        return vector.elements();
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumTrees();
        stringArray[n++] = "-K";
        stringArray[n++] = "" + this.getNumFeatures();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        this.m_numTrees = string.length() != 0 ? Integer.parseInt(string) : 10;
        String string2 = Utils.getOption('K', stringArray);
        this.m_numFeatures = string2.length() != 0 ? Integer.parseInt(string2) : 0;
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        } else {
            this.setSeed(1);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_bagger = new Bagging();
        RandomTree randomTree = new RandomTree();
        this.m_KValue = this.m_numFeatures;
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(instances.numAttributes()) + 1;
        }
        randomTree.setKValue(this.m_KValue);
        this.m_bagger.setClassifier(randomTree);
        this.m_bagger.setSeed(this.m_randomSeed);
        this.m_bagger.setNumIterations(this.m_numTrees);
        this.m_bagger.setCalcOutOfBag(true);
        this.m_bagger.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_bagger.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_bagger == null) {
            return "Random forest not built yet";
        }
        return "Random forest of " + this.m_numTrees + " trees, each constructed while considering " + this.m_KValue + " random feature" + (this.m_KValue == 1 ? "" : "s") + ".\n" + "Out of bag error: " + Utils.doubleToString(this.m_bagger.measureOutOfBagError(), 4) + "\n\n";
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new RandomForest(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

