/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class AddNoise
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -8499673222857299082L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private boolean m_UseMissing = false;
    private int m_Percent = 10;
    private int m_RandomSeed = 1;

    public String globalInfo() {
        return "An instance filter that changes a percentage of a given attributes values. The attribute must be nominal. Missing value can be treated as value itself.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tIndex of the attribute to be changed \n\t(default last attribute)", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tTreat missing values as an extra value \n", "M", 1, "-M"));
        vector.addElement(new Option("\tSpecify the percentage of noise introduced \n\tto the data (default 10)", "P", 1, "-P <num>"));
        vector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            this.setAttributeIndex(string2);
        } else {
            this.setAttributeIndex("last");
        }
        if (Utils.getFlag('M', stringArray)) {
            this.setUseMissing(true);
        }
        if ((string = Utils.getOption('P', stringArray)).length() != 0) {
            this.setPercent((int)Double.valueOf(string).doubleValue());
        } else {
            this.setPercent(10);
        }
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string3));
        } else {
            this.setRandomSeed(1);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        if (this.getUseMissing()) {
            stringArray[n++] = "-M";
        }
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.getPercent();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String useMissingTipText() {
        return "Flag to set if missing values are used.";
    }

    public boolean getUseMissing() {
        return this.m_UseMissing;
    }

    public void setUseMissing(boolean bl) {
        this.m_UseMissing = bl;
    }

    public String randomSeedTipText() {
        return "Random number seed.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String percentTipText() {
        return "Percentage of introduced noise to data.";
    }

    public int getPercent() {
        return this.m_Percent;
    }

    public void setPercent(int n) {
        this.m_Percent = n;
    }

    public String attIndexSetTipText() {
        return "Index of the attribute that is to changed.";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(this.getInputFormat().numAttributes() - 1);
        if (!this.getInputFormat().attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new Exception("Adding noise is not possible:Chosen attribute is numeric.");
        }
        if (this.getInputFormat().attribute(this.m_AttIndex.getIndex()).numValues() < 2 && !this.m_UseMissing) {
            throw new Exception("Adding noise is not possible:Chosen attribute has less than two values.");
        }
        this.setOutputFormat(this.getInputFormat());
        this.m_NewBatch = true;
        return false;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new Exception("No input instance format defined");
        }
        this.addNoise(this.getInputFormat(), this.m_RandomSeed, this.m_Percent, this.m_AttIndex.getIndex(), this.m_UseMissing);
        for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
            this.push((Instance)this.getInputFormat().instance(i).copy());
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void addNoise(Instances instances, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        double d = n2;
        int[] nArray = new int[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            nArray[i] = i;
        }
        Random random = new Random(n);
        for (n7 = instances.numInstances() - 1; n7 >= 0; --n7) {
            n6 = nArray[n7];
            n5 = (int)(random.nextDouble() * (double)n7);
            nArray[n7] = nArray[n5];
            nArray[n5] = n6;
        }
        n7 = instances.attribute(n3).numValues();
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        n6 = 0;
        n5 = 0;
        for (int i = 0; i < n7; ++i) {
            nArray2[i] = 0;
            nArray3[i] = 0;
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.isMissing(n3)) {
                ++n5;
                continue;
            }
            int n8 = (int)instance.value(n3);
            int n9 = (int)instance.value(n3);
            nArray3[n9] = nArray3[n9] + 1;
        }
        n5 = !bl ? n6 : (int)((double)n5 / 100.0 * d + 0.5);
        int n10 = n5;
        for (n4 = 0; n4 < n7; ++n4) {
            nArray3[n4] = (int)((double)nArray3[n4] / 100.0 * d + 0.5);
            n10 += nArray3[n4];
        }
        n4 = 0;
        Random random2 = new Random(n);
        int n11 = instances.attribute(n3).numValues();
        for (int i = 0; i < instances.numInstances() && n4 < n10; ++i) {
            Instance instance = instances.instance(nArray[i]);
            if (instance.isMissing(n3)) {
                if (n6 >= n5) continue;
                this.changeValueRandomly(random2, n11, n3, instance, bl);
                ++n6;
                ++n4;
                continue;
            }
            int n12 = (int)instance.value(n3);
            if (nArray2[n12] >= nArray3[n12]) continue;
            this.changeValueRandomly(random2, n11, n3, instance, bl);
            int n13 = n12;
            nArray2[n13] = nArray2[n13] + 1;
            ++n4;
        }
    }

    private void changeValueRandomly(Random random, int n, int n2, Instance instance, boolean bl) {
        int n3 = instance.isMissing(n2) ? n : (int)instance.value(n2);
        if (n == 2 && !instance.isMissing(n2)) {
            instance.setValue(n2, (double)((n3 + 1) % 2));
        } else {
            int n4;
            while ((n4 = bl ? (int)(random.nextDouble() * (double)(n + 1)) : (int)(random.nextDouble() * (double)n)) == n3) {
            }
            if (n4 == n) {
                instance.setMissing(n2);
            } else {
                instance.setValue(n2, (double)n4);
            }
        }
    }

    public static void main(String[] stringArray) {
        AddNoise.runFilter(new AddNoise(), stringArray);
    }
}

