/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class Stacking
extends RandomizableMultipleClassifiersCombiner {
    protected Classifier m_MetaClassifier = new ZeroR();
    protected Instances m_MetaFormat = null;
    protected Instances m_BaseFormat = null;
    protected int m_NumFolds = 10;

    public String globalInfo() {
        return "Combines several classifiers using the stacking method. Can do classification or regression. For more information, see\n\nDavid H. Wolpert (1992). \"Stacked generalization\". Neural Networks, 5:241-259, Pergamon Press.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(this.metaOption(), "M", 0, "-M <scheme specification>"));
        vector.addElement(new Option("\tSets the number of cross-validation folds.", "X", 1, "-X <number of folds>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    protected String metaOption() {
        return "\tFull name of meta classifier, followed by options.\n\t(default: \"weka.classifiers.rules.Zero\")";
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(10);
        }
        this.processMetaOptions(stringArray);
        super.setOptions(stringArray);
    }

    protected void processMetaOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('M', stringArray);
        String[] stringArray2 = Utils.splitOptions(string2);
        if (stringArray2.length == 0) {
            string = "weka.classifiers.rules.ZeroR";
        } else {
            string = stringArray2[0];
            stringArray2[0] = "";
        }
        this.setMetaClassifier(Classifier.forName(string, stringArray2));
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 4];
        int n = 0;
        stringArray2[n++] = "-X";
        stringArray2[n++] = "" + this.getNumFolds();
        stringArray2[n++] = "-M";
        stringArray2[n++] = this.getMetaClassifier().getClass().getName() + " " + Utils.joinOptions(this.getMetaClassifier().getOptions());
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String numFoldsTipText() {
        return "The number of folds used for cross-validation.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("Stacking: Number of cross-validation folds must be positive.");
        }
        this.m_NumFolds = n;
    }

    public String metaClassifierTipText() {
        return "The meta classifiers to be used.";
    }

    public void setMetaClassifier(Classifier classifier) {
        this.m_MetaClassifier = classifier;
    }

    public Classifier getMetaClassifier() {
        return this.m_MetaClassifier;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_MetaClassifier == null) {
            throw new IllegalArgumentException("No meta classifier has been set");
        }
        if (!instances.classAttribute().isNominal() && !instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("Class attribute has to be nominal or numeric!");
        }
        Instances instances2 = new Instances(instances);
        this.m_BaseFormat = new Instances(instances, 0);
        instances2.deleteWithMissingClass();
        if (instances2.numInstances() == 0) {
            throw new IllegalArgumentException("No training instances without missing class!");
        }
        Random random = new Random(this.m_Seed);
        instances2.randomize(random);
        if (instances2.classAttribute().isNominal()) {
            instances2.stratify(this.m_NumFolds);
        }
        this.generateMetaLevel(instances2, random);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.getClassifier(i).buildClassifier(instances2);
        }
    }

    protected void generateMetaLevel(Instances instances, Random random) throws Exception {
        Instances instances2 = this.metaFormat(instances);
        this.m_MetaFormat = new Instances(instances2, 0);
        for (int i = 0; i < this.m_NumFolds; ++i) {
            Instances instances3 = instances.trainCV(this.m_NumFolds, i, random);
            for (int j = 0; j < this.m_Classifiers.length; ++j) {
                this.getClassifier(j).buildClassifier(instances3);
            }
            Instances instances4 = instances.testCV(this.m_NumFolds, i);
            for (int j = 0; j < instances4.numInstances(); ++j) {
                instances2.add(this.metaInstance(instances4.instance(j)));
            }
        }
        this.m_MetaClassifier.buildClassifier(instances2);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_MetaClassifier.distributionForInstance(this.metaInstance(instance));
    }

    public String toString() {
        if (this.m_Classifiers.length == 0) {
            return "Stacking: No base schemes entered.";
        }
        if (this.m_MetaClassifier == null) {
            return "Stacking: No meta scheme selected.";
        }
        if (this.m_MetaFormat == null) {
            return "Stacking: No model built yet.";
        }
        String string = "Stacking\n\nBase classifiers\n\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            string = string + this.getClassifier(i).toString() + "\n\n";
        }
        string = string + "\n\nMeta classifier\n\n";
        string = string + this.m_MetaClassifier.toString();
        return string;
    }

    protected Instances metaFormat(Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        boolean bl = false;
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            Classifier classifier = this.getClassifier(i);
            String string = classifier.getClass().getName();
            if (this.m_BaseFormat.classAttribute().isNumeric()) {
                fastVector.addElement(new Attribute(string));
                continue;
            }
            for (int j = 0; j < this.m_BaseFormat.classAttribute().numValues(); ++j) {
                fastVector.addElement(new Attribute(string + ":" + this.m_BaseFormat.classAttribute().value(j)));
            }
        }
        fastVector.addElement(this.m_BaseFormat.classAttribute().copy());
        Instances instances2 = new Instances("Meta format", fastVector, 0);
        instances2.setClassIndex(instances2.numAttributes() - 1);
        return instances2;
    }

    protected Instance metaInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.m_MetaFormat.numAttributes()];
        int n = 0;
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            Classifier classifier = this.getClassifier(i);
            if (this.m_BaseFormat.classAttribute().isNumeric()) {
                dArray[n++] = classifier.classifyInstance(instance);
                continue;
            }
            double[] dArray2 = classifier.distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                dArray[n++] = dArray2[j];
            }
        }
        dArray[n] = instance.classValue();
        Instance instance2 = new Instance(1.0, dArray);
        instance2.setDataset(this.m_MetaFormat);
        return instance2;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Stacking(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

