% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataFromRdf.R
\name{getDataForAllScens}
\alias{getDataForAllScens}
\title{Get and aggregate data from an rdf file(s)}
\usage{
getDataForAllScens(scenFolders, scenNames, slotAggList, scenPath,
  oFile = NULL, retFile = NULL, findAllSlots = TRUE)
}
\arguments{
\item{scenFolders}{A string vector containing the folder names (scenarios)
that the rdf files are saved in.}

\item{scenNames}{A string vector containing the scenario names.  This should
be the same length as \code{scenFolders}. The scenario names are used as
attributes to the data in the \code{Scenario} column.}

\item{slotAggList}{The slot aggregation list. Either an object of class
\link{slot_agg_list} or a "special" list with the keyword \code{"all"}. If, it is
a \link{slot_agg_list}, see that documentation for how to control the
aggregation methods used in this function. If all of the slots in an
entire rdf are desired, use a list of lists with each entry containing an
rdf file and the keyword \code{"all"} for the slots, e.g.,
\code{list(list(rdf = 'KeySlots.rdf',slots = 'all'))}. If this option is used,
the function will return raw monthly, or annual data, i.e., no aggregation
methods will be applied to the data in the rdf file.}

\item{scenPath}{An absolute or relative path to the folder containing
\code{scenFolders}.}

\item{oFile}{If not \code{NULL}, then an absolute or relative path with the file
name of the location the table will be saved to. Valid file types are
.csv, .txt, or .feather.}

\item{retFile}{Deprecated. Data are always returned invisibly.}

\item{findAllSlots}{Boolean; if \code{TRUE} (default), then the function will
abort if it cannot find a particular slot. If \code{FALSE}, then the
function will continue, even if a slot cannot be found. If a slot is not
found, then the function will return \code{-99} for the Trace, Year, and Value.}
}
\value{
A data.frame returned invisibly.
}
\description{
\code{getDataForAllScens()} gets slot data from multiple rdf files and/or multiple
scenarios, aggregates it, and saves it as a data.frame. The slot data can be
aggregated in multiple ways (see \link{slot_agg_list}).
}
\examples{
# get a specified set of slots and apply some aggregation method to them
# get the data from two scenarios
scenFolders <- c('ISM1988_2014,2007Dems,IG,Most', 
  'ISM1988_2014,2007Dems,IG,2002') 
# slotAggTable.csv lists the slots to obtain, and the aggregation method to 
# apply to them
slotAggList <- slot_agg_list(
  system.file('extdata','SlotAggTable.csv',package = 'RWDataPlyr')
)
scenPath <- system.file('extdata','Scenario/',package = 'RWDataPlyr')
# expect Deprecated warning
testthat::expect_warning(
  keyData <- getDataForAllScens(
    scenFolders, 
    scenNames = scenFolders, 
    slotAggList = slotAggList, 
    scenPath = scenPath
  )
)

# get all of the data from the KeySlots rdf file
scenFolders <- scenFolders[1] # only one scenario
slotAggList <- list(list(rdf = 'KeySlots.rdf', slots = 'all'))
# will return monthly data for all slots in KeySlots.rdf
# expect Deprecated warning
testthat::expect_warning(
  allData <- getDataForAllScens(
    scenFolders, 
    scenNames = scenFolders, 
    slotAggList = slotAggList, 
    scenPath = scenPath
  )
)

}
\seealso{
\code{\link[=slot_agg_list]{slot_agg_list()}}
}
