% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\name{RTestCase}
\alias{RTestCase}
\title{Constructor for RTestCase}
\usage{
RTestCase(ID = NULL, tc.type = NULL, synopsis = NULL, xml.fPath = NULL,
  xml.root = NULL, input.data = NULL, tests = NULL, test.for = NULL,
  test.result = NULL)
}
\arguments{
\item{ID}{(\code{character}) ID of the TC.}

\item{tc.type}{(\code{character}) Type of the TC (i.e. the class name).}

\item{synopsis}{(\code{list}) Synopsis information of the TC (as defined in the XSD
ComplexType 'RTestSynopis').}

\item{xml.fPath}{(\code{character}) Path to XML definition file of the TC.}

\item{xml.root}{(\code{XMLNode}) The imported TC definition as \code{XMLNode}-class 
object.}

\item{input.data}{(\code{list}) The input data of the test case, which will be filled
using the method \code{\link{readXMLInputData}}.}

\item{tests}{(\code{list}) A list with the test results or NULL, if the test case 
has not been executed (see 'Details').}

\item{test.for}{(\code{character}) Names of the packages, which were tested in the last
execution of the test case. NULL, if the test case has not been 
executed.}

\item{test.result}{(\code{character}) Result of the last test case execution ('SUCCESS' or 
'FAILURE'). NULL, if the test case has not been executed.}
}
\value{
(.Object) \code{RTestCase} Object
}
\description{
Constructor for RTestCase
}
\examples{

xml.root <- XML::newXMLNode("func01")
xmlFromList(xml.root,
		list(
				params=list(mult=list(attributes=c(value="1",type="numeric"))),
				testspec=list(
execution=list(attributes=c("execution-type"="silent")),
"return-value"=list(attributes=c(
"compare-type"="equal",
"diff-type"="absolute",
"tolerance"=0.001
))
				)			
		)
)	
# Add the reference result to the params and testspec and read it in again
xml.root <- XML::xmlRoot(XML::xmlTreeParse(
				paste0("<root>",
						capture_output(print(xml.root[[1]])),
						capture_output(print(xml.root[[2]])),
						paste(xmlWriteData_data.frame(
										"reference",
	                  data=data.frame(x=c(1,1),y=c(2,2),sum=c(3,3)),
										printXML=FALSE)
								,collapse="\\n"),"</root>")
		))

# Define what to test in the first test
# Please check the function test.RTest.funct_01 to see
# how it tests the code of the function ("test_fun")
tests <- new.env()
testEntry <- list(
		"pkg"            = "RTest",                  # test description
		"pgk-iter"       = "1",
		"func"           = "funct_01",
		"func-iter"      = "1",
		"test-code"      = "RTest::funct_01",
		"test-adapter"   = "RTestCase",
		"test-func"      = "test.RTest.funct_01",
		"pkg-desc"       = "no package desc",
		"func-desc"      = "Simple add func",
		"xpath"          = "/root",
		"reporter"       = NA,   # field for testthat reporter
		"result"         = NA,   # field for test result (failed/success)
		"cache"          = NA,   # field for caching test results
		"execresid"      = NA,	 # field for test execution result id
		"specid"         = "0",	 # field for test function id
		"riskid"         = "0"	 # field for test function risk id
)

# Assign test entry to test environment 
#      pkg-name  pkg-iter    func-name  func-iter
tests[["RTest"]][["1"]][["funct_01"]][["1"]] <- testEntry

# Create a TestCase Object
object <- RTestCase(
		ID="1",
		tc.type="RTestCase",
		synopsis= list(version="v1",author="Sebastian Wolf"),
		xml.fPath="",
		xml.root=xml.root,
		input.data=list("one"=
						data.frame(x=c(1,1),y=c(2,2))
		),
		tests=tests,
		test.for="RTest",
		test.result=NA
)

# Run the test
object <- test(object,test.for="RTest")
stopifnot(object@test.result=="success")

# Run a failing test

object@input.data <- list("one"=
				data.frame(x=c(1,2),y=c(2,1))
)
object <- test(object,test.for="RTest")
stopifnot(object@test.result=="failed")

}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
