% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morningstar.R
\name{getCurve}
\alias{getCurve}
\title{Morningstar Commodities API forward curves}
\usage{
getCurve(
  feed = "CME_NymexFutures_EOD_continuous",
  contract = "CL",
  numOfcontracts = 12,
  date = "2023-08-24",
  fields =
    c("open_price, high_price, low_price, settlement_price, volume, open_interest"),
  iuser = "x@xyz.com",
  ipassword = "pass"
)
}
\arguments{
\item{feed}{Morningstar Feed Table e.g "Crb_Futures_Price_Volume_And_Open_Interest". \code{character}}

\item{contract}{Morningstar contract root e.g. "CL" for CME WTI and "BG" for ICE Brent. \code{character}}

\item{numOfcontracts}{Number of listed contracts to retrieve. \code{numeric}}

\item{date}{Date yyyy-mm-dd. \code{character}}

\item{fields}{Defaults to c("open_price, high_price, low_price, settlement_price, volume, open_interest"). \code{character}}

\item{iuser}{Morningstar user name as character - sourced locally in examples. \code{character}}

\item{ipassword}{Morningstar user password as character - sourced locally in examples. \code{character}}
}
\value{
wide data frame. \code{tibble}
}
\description{
Returns forward curves from Morningstar API. See below for current feeds supported.
You need your own credentials with Morningstar.
}
\section{Current Feeds Supported}{

\itemize{
\item CME_NymexFutures_EOD_continuous
}
}

\examples{
\dontrun{
# CME WTI Futures
getCurve(
  feed = "CME_NymexFutures_EOD_continuous", contract = "CL",
  date = "2023-08-24",
  fields = c("open_price, high_price, low_price, settlement_price, volume, open_interest"),
  iuser = "x@xyz.com", ipassword = "pass"
)
}

}
\author{
Philippe Cote
}
