% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{dis.template}
\alias{dis.template}
\title{Generating templates for district-level data of Switzerland}
\usage{
dis.template(year, add_geodata_path = ".", endofyear = FALSE,
  cantons = NULL, districts = NULL)
}
\arguments{
\item{year}{numeric. Available with package: \code{2016}. For additional years, see: \code{map.load}.}

\item{add_geodata_path}{a character string with the path to the folder where additional geodata is saved.}

\item{endofyear}{if \code{TRUE}, districts as by December 31 of \code{year} are used for the template.}

\item{cantons}{input either numeric (canton identification numbers) or character (canton abbreviations)
vector to create canton-specific templates.}

\item{districts}{input either numeric (district identification numbers) or character (district names)
vector to create tailor-made templates.}
}
\description{
\code{dis.template} offers the possbility to generate Swiss district-level data templates in
    the form of data frames. The package comes with data for \code{2016}.  Additional data can be
    downloaded with \code{map.load}.  The templates contain the district identification numbers
    as used by the Swiss Federal Statistical Office and the district names.
}
\examples{
# Generating template:
dis.template(2016)

# Generating template for the districts of the canton of Aargau:
dis.template(2016, cantons = c("AG", "ZH"))
}
