% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_api_tmpl.R
\name{tmpl_register}
\alias{tmpl_register}
\title{Registers the template specified with the path argument.}
\usage{
tmpl_register(path = NULL, global = FALSE)
}
\arguments{
\item{path}{path to the directory where the template should be created
(type: character, default: NA)}

\item{global}{flag specifying if the template will be registered in the user's
local template directory (taken from rsuite.user_templ_path) or in the global
template directory (/etc/.rsuite/templates on Linux platforms)}
}
\description{
Registers the template specified with the path argument.
}
\details{
All templates have specific requirements:
    Project templates have to contain a PARAMETERS file.
    Package templates have to contain a DESCRIPTION file.

The user's local template directory is taken from the
rsuite.user_templ_path option. The global template is specified
as '/etc/.rsuite/templates' and only concerns Linux platforms
}
\examples{
\donttest{
  # setup
  old_option_value <- getOption("rsuite.user_templ_path")
  tmpl_dir <- tempfile("user_templates_")
  dir.create(tmpl_dir, recursive = TRUE, showWarnings = FALSE)

  options(rsuite.user_templ_path = tmpl_dir)
  user_templ <- tempfile("usr_templ_")

  # initialize template from builtin
  tmpl_start(basename(user_templ), path = tempdir())
  # register it
  tmpl_register(user_templ)

  # clean up
  options(rsuite.user_templ_path = old_option_value)
  unlink(tmpl_dir, recursive = TRUE, force = TRUE)
  unlink(user_templ, recursive = TRUE, force = TRUE)
}

}
\seealso{
Other miscellaneous: \code{\link{rsuite_check_version}},
  \code{\link{rsuite_getLogger}},
  \code{\link{rsuite_get_ci_adapter_names}},
  \code{\link{rsuite_get_os_info}},
  \code{\link{rsuite_get_rc_adapter_names}},
  \code{\link{rsuite_get_repo_adapter_names}},
  \code{\link{rsuite_register_ci_adapter}},
  \code{\link{rsuite_register_rc_adapter}},
  \code{\link{rsuite_register_repo_adapter}},
  \code{\link{rsuite_unregister_ci_adapter}},
  \code{\link{rsuite_unregister_rc_adapter}},
  \code{\link{rsuite_unregister_repo_adapter}},
  \code{\link{rsuite_update}}
}
