% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_repo_adapter.R
\name{repo_adapter_create_manager}
\alias{repo_adapter_create_manager}
\title{Creates repo manager to manage its repository.}
\usage{
repo_adapter_create_manager(repo_adapter, ...)
}
\arguments{
\item{repo_adapter}{repo adapter on which manager is base. (type: rsuite_repo_adapter)}

\item{...}{manager specific parameters.}
}
\value{
object of type rsuite_repo_adapter
}
\description{
For repositories which needs some kind of connection to manage it initializes
appropriate resources.
}
\details{
Raises error if fails to create manager.
}
\examples{
# create you own Repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
